<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesResponseType extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * @var \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType
     */
    public $ResponseStatus;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType[]
     */
    public $Alert;
    /**
     * The AlertDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesDetailType[]
     */
    public $AlertDetail;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for ResponseType
     * @uses Ups_ratesResponseType::setResponseStatus()
     * @uses Ups_ratesResponseType::setAlert()
     * @uses Ups_ratesResponseType::setAlertDetail()
     * @uses Ups_ratesResponseType::setTransactionReference()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $responseStatus
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType[] $alert
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDetailType[] $alertDetail
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTransactionReferenceType $transactionReference
     */
    public function __construct(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $responseStatus = null, array $alert = array(), array $alertDetail = array(), \Ups_rates\UPSratesStruct\Ups_ratesTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setAlert($alert)
            ->setAlertDetail($alertDetail)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get ResponseStatus value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $responseStatus
     * @return \Ups_rates\UPSratesStruct\Ups_ratesResponseType
     */
    public function setResponseStatus(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get Alert value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType) {
                $invalidValues[] = is_object($responseTypeAlertItem) ? get_class($responseTypeAlertItem) : sprintf('%s(%s)', gettype($responseTypeAlertItem), var_export($responseTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType[] $alert
     * @return \Ups_rates\UPSratesStruct\Ups_ratesResponseType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesResponseType
     */
    public function addToAlert(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get AlertDetail value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesDetailType[]|null
     */
    public function getAlertDetail()
    {
        return $this->AlertDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAlertDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlertDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertDetailForArrayConstraintsFromSetAlertDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertDetailItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertDetailItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesDetailType) {
                $invalidValues[] = is_object($responseTypeAlertDetailItem) ? get_class($responseTypeAlertDetailItem) : sprintf('%s(%s)', gettype($responseTypeAlertDetailItem), var_export($responseTypeAlertDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlertDetail property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDetailType[] $alertDetail
     * @return \Ups_rates\UPSratesStruct\Ups_ratesResponseType
     */
    public function setAlertDetail(array $alertDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($alertDetailArrayErrorMessage = self::validateAlertDetailForArrayConstraintsFromSetAlertDetail($alertDetail))) {
            throw new \InvalidArgumentException($alertDetailArrayErrorMessage, __LINE__);
        }
        $this->AlertDetail = $alertDetail;
        return $this;
    }
    /**
     * Add item to AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDetailType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesResponseType
     */
    public function addToAlertDetail(\Ups_rates\UPSratesStruct\Ups_ratesDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesDetailType) {
            throw new \InvalidArgumentException(sprintf('The AlertDetail property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlertDetail[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTransactionReferenceType $transactionReference
     * @return \Ups_rates\UPSratesStruct\Ups_ratesResponseType
     */
    public function setTransactionReference(\Ups_rates\UPSratesStruct\Ups_ratesTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
