<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteedDeliveryType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesGuaranteedDeliveryType extends AbstractStructBase
{
    /**
     * The BusinessDaysInTransit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BusinessDaysInTransit;
    /**
     * The DeliveryByTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryByTime;
    /**
     * Constructor method for GuaranteedDeliveryType
     * @uses Ups_ratesGuaranteedDeliveryType::setBusinessDaysInTransit()
     * @uses Ups_ratesGuaranteedDeliveryType::setDeliveryByTime()
     * @param string $businessDaysInTransit
     * @param string $deliveryByTime
     */
    public function __construct($businessDaysInTransit = null, $deliveryByTime = null)
    {
        $this
            ->setBusinessDaysInTransit($businessDaysInTransit)
            ->setDeliveryByTime($deliveryByTime);
    }
    /**
     * Get BusinessDaysInTransit value
     * @return string|null
     */
    public function getBusinessDaysInTransit()
    {
        return $this->BusinessDaysInTransit;
    }
    /**
     * Set BusinessDaysInTransit value
     * @param string $businessDaysInTransit
     * @return \Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType
     */
    public function setBusinessDaysInTransit($businessDaysInTransit = null)
    {
        // validation for constraint: string
        if (!is_null($businessDaysInTransit) && !is_string($businessDaysInTransit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessDaysInTransit, true), gettype($businessDaysInTransit)), __LINE__);
        }
        $this->BusinessDaysInTransit = $businessDaysInTransit;
        return $this;
    }
    /**
     * Get DeliveryByTime value
     * @return string|null
     */
    public function getDeliveryByTime()
    {
        return $this->DeliveryByTime;
    }
    /**
     * Set DeliveryByTime value
     * @param string $deliveryByTime
     * @return \Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType
     */
    public function setDeliveryByTime($deliveryByTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryByTime) && !is_string($deliveryByTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryByTime, true), gettype($deliveryByTime)), __LINE__);
        }
        $this->DeliveryByTime = $deliveryByTime;
        return $this;
    }
}
