<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentRatingOptionsType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesShipmentRatingOptionsType extends AbstractStructBase
{
    /**
     * The NegotiatedRatesIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NegotiatedRatesIndicator;
    /**
     * The FRSShipmentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FRSShipmentIndicator;
    /**
     * The RateChartIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateChartIndicator;
    /**
     * The UserLevelDiscountIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UserLevelDiscountIndicator;
    /**
     * Constructor method for ShipmentRatingOptionsType
     * @uses Ups_ratesShipmentRatingOptionsType::setNegotiatedRatesIndicator()
     * @uses Ups_ratesShipmentRatingOptionsType::setFRSShipmentIndicator()
     * @uses Ups_ratesShipmentRatingOptionsType::setRateChartIndicator()
     * @uses Ups_ratesShipmentRatingOptionsType::setUserLevelDiscountIndicator()
     * @param string $negotiatedRatesIndicator
     * @param string $fRSShipmentIndicator
     * @param string $rateChartIndicator
     * @param string $userLevelDiscountIndicator
     */
    public function __construct($negotiatedRatesIndicator = null, $fRSShipmentIndicator = null, $rateChartIndicator = null, $userLevelDiscountIndicator = null)
    {
        $this
            ->setNegotiatedRatesIndicator($negotiatedRatesIndicator)
            ->setFRSShipmentIndicator($fRSShipmentIndicator)
            ->setRateChartIndicator($rateChartIndicator)
            ->setUserLevelDiscountIndicator($userLevelDiscountIndicator);
    }
    /**
     * Get NegotiatedRatesIndicator value
     * @return string|null
     */
    public function getNegotiatedRatesIndicator()
    {
        return $this->NegotiatedRatesIndicator;
    }
    /**
     * Set NegotiatedRatesIndicator value
     * @param string $negotiatedRatesIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType
     */
    public function setNegotiatedRatesIndicator($negotiatedRatesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($negotiatedRatesIndicator) && !is_string($negotiatedRatesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($negotiatedRatesIndicator, true), gettype($negotiatedRatesIndicator)), __LINE__);
        }
        $this->NegotiatedRatesIndicator = $negotiatedRatesIndicator;
        return $this;
    }
    /**
     * Get FRSShipmentIndicator value
     * @return string|null
     */
    public function getFRSShipmentIndicator()
    {
        return $this->FRSShipmentIndicator;
    }
    /**
     * Set FRSShipmentIndicator value
     * @param string $fRSShipmentIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType
     */
    public function setFRSShipmentIndicator($fRSShipmentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($fRSShipmentIndicator) && !is_string($fRSShipmentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fRSShipmentIndicator, true), gettype($fRSShipmentIndicator)), __LINE__);
        }
        $this->FRSShipmentIndicator = $fRSShipmentIndicator;
        return $this;
    }
    /**
     * Get RateChartIndicator value
     * @return string|null
     */
    public function getRateChartIndicator()
    {
        return $this->RateChartIndicator;
    }
    /**
     * Set RateChartIndicator value
     * @param string $rateChartIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType
     */
    public function setRateChartIndicator($rateChartIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($rateChartIndicator) && !is_string($rateChartIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateChartIndicator, true), gettype($rateChartIndicator)), __LINE__);
        }
        $this->RateChartIndicator = $rateChartIndicator;
        return $this;
    }
    /**
     * Get UserLevelDiscountIndicator value
     * @return string|null
     */
    public function getUserLevelDiscountIndicator()
    {
        return $this->UserLevelDiscountIndicator;
    }
    /**
     * Set UserLevelDiscountIndicator value
     * @param string $userLevelDiscountIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType
     */
    public function setUserLevelDiscountIndicator($userLevelDiscountIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($userLevelDiscountIndicator) && !is_string($userLevelDiscountIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLevelDiscountIndicator, true), gettype($userLevelDiscountIndicator)), __LINE__);
        }
        $this->UserLevelDiscountIndicator = $userLevelDiscountIndicator;
        return $this;
    }
}
