<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetailsType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesPaymentDetailsType extends AbstractStructBase
{
    /**
     * The ShipmentCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType[]
     */
    public $ShipmentCharge;
    /**
     * The SplitDutyVATIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SplitDutyVATIndicator;
    /**
     * Constructor method for PaymentDetailsType
     * @uses Ups_ratesPaymentDetailsType::setShipmentCharge()
     * @uses Ups_ratesPaymentDetailsType::setSplitDutyVATIndicator()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType[] $shipmentCharge
     * @param string $splitDutyVATIndicator
     */
    public function __construct(array $shipmentCharge = array(), $splitDutyVATIndicator = null)
    {
        $this
            ->setShipmentCharge($shipmentCharge)
            ->setSplitDutyVATIndicator($splitDutyVATIndicator);
    }
    /**
     * Get ShipmentCharge value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType[]|null
     */
    public function getShipmentCharge()
    {
        return $this->ShipmentCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentChargeForArrayConstraintsFromSetShipmentCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentDetailsTypeShipmentChargeItem) {
            // validation for constraint: itemType
            if (!$paymentDetailsTypeShipmentChargeItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType) {
                $invalidValues[] = is_object($paymentDetailsTypeShipmentChargeItem) ? get_class($paymentDetailsTypeShipmentChargeItem) : sprintf('%s(%s)', gettype($paymentDetailsTypeShipmentChargeItem), var_export($paymentDetailsTypeShipmentChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentCharge property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentCharge value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType[] $shipmentCharge
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType
     */
    public function setShipmentCharge(array $shipmentCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentChargeArrayErrorMessage = self::validateShipmentChargeForArrayConstraintsFromSetShipmentCharge($shipmentCharge))) {
            throw new \InvalidArgumentException($shipmentChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($shipmentCharge) && count($shipmentCharge) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($shipmentCharge)), __LINE__);
        }
        $this->ShipmentCharge = $shipmentCharge;
        return $this;
    }
    /**
     * Add item to ShipmentCharge value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType
     */
    public function addToShipmentCharge(\Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentCharge property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesShipmentChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->ShipmentCharge) && count($this->ShipmentCharge) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->ShipmentCharge)), __LINE__);
        }
        $this->ShipmentCharge[] = $item;
        return $this;
    }
    /**
     * Get SplitDutyVATIndicator value
     * @return string|null
     */
    public function getSplitDutyVATIndicator()
    {
        return $this->SplitDutyVATIndicator;
    }
    /**
     * Set SplitDutyVATIndicator value
     * @param string $splitDutyVATIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType
     */
    public function setSplitDutyVATIndicator($splitDutyVATIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($splitDutyVATIndicator) && !is_string($splitDutyVATIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($splitDutyVATIndicator, true), gettype($splitDutyVATIndicator)), __LINE__);
        }
        $this->SplitDutyVATIndicator = $splitDutyVATIndicator;
        return $this;
    }
}
