<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DryIceType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesDryIceType extends AbstractStructBase
{
    /**
     * The RegulationSet
     * @var string
     */
    public $RegulationSet;
    /**
     * The DryIceWeight
     * @var \Ups_rates\UPSratesStruct\Ups_ratesDryIceWeightType
     */
    public $DryIceWeight;
    /**
     * The MedicalUseIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MedicalUseIndicator;
    /**
     * The AuditRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AuditRequired;
    /**
     * Constructor method for DryIceType
     * @uses Ups_ratesDryIceType::setRegulationSet()
     * @uses Ups_ratesDryIceType::setDryIceWeight()
     * @uses Ups_ratesDryIceType::setMedicalUseIndicator()
     * @uses Ups_ratesDryIceType::setAuditRequired()
     * @param string $regulationSet
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDryIceWeightType $dryIceWeight
     * @param string $medicalUseIndicator
     * @param string $auditRequired
     */
    public function __construct($regulationSet = null, \Ups_rates\UPSratesStruct\Ups_ratesDryIceWeightType $dryIceWeight = null, $medicalUseIndicator = null, $auditRequired = null)
    {
        $this
            ->setRegulationSet($regulationSet)
            ->setDryIceWeight($dryIceWeight)
            ->setMedicalUseIndicator($medicalUseIndicator)
            ->setAuditRequired($auditRequired);
    }
    /**
     * Get RegulationSet value
     * @return string|null
     */
    public function getRegulationSet()
    {
        return $this->RegulationSet;
    }
    /**
     * Set RegulationSet value
     * @param string $regulationSet
     * @return \Ups_rates\UPSratesStruct\Ups_ratesDryIceType
     */
    public function setRegulationSet($regulationSet = null)
    {
        // validation for constraint: string
        if (!is_null($regulationSet) && !is_string($regulationSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regulationSet, true), gettype($regulationSet)), __LINE__);
        }
        $this->RegulationSet = $regulationSet;
        return $this;
    }
    /**
     * Get DryIceWeight value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesDryIceWeightType|null
     */
    public function getDryIceWeight()
    {
        return $this->DryIceWeight;
    }
    /**
     * Set DryIceWeight value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDryIceWeightType $dryIceWeight
     * @return \Ups_rates\UPSratesStruct\Ups_ratesDryIceType
     */
    public function setDryIceWeight(\Ups_rates\UPSratesStruct\Ups_ratesDryIceWeightType $dryIceWeight = null)
    {
        $this->DryIceWeight = $dryIceWeight;
        return $this;
    }
    /**
     * Get MedicalUseIndicator value
     * @return string|null
     */
    public function getMedicalUseIndicator()
    {
        return $this->MedicalUseIndicator;
    }
    /**
     * Set MedicalUseIndicator value
     * @param string $medicalUseIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesDryIceType
     */
    public function setMedicalUseIndicator($medicalUseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($medicalUseIndicator) && !is_string($medicalUseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalUseIndicator, true), gettype($medicalUseIndicator)), __LINE__);
        }
        $this->MedicalUseIndicator = $medicalUseIndicator;
        return $this;
    }
    /**
     * Get AuditRequired value
     * @return string|null
     */
    public function getAuditRequired()
    {
        return $this->AuditRequired;
    }
    /**
     * Set AuditRequired value
     * @param string $auditRequired
     * @return \Ups_rates\UPSratesStruct\Ups_ratesDryIceType
     */
    public function setAuditRequired($auditRequired = null)
    {
        // validation for constraint: string
        if (!is_null($auditRequired) && !is_string($auditRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auditRequired, true), gettype($auditRequired)), __LINE__);
        }
        $this->AuditRequired = $auditRequired;
        return $this;
    }
}
