<?php

namespace Ups_rates\UPSratesService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process UPSratesService
 * @package Ups_rates
 * @subpackage Services
 */
class Ups_ratesProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_rates\UPSratesStruct\Ups_ratesUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessRate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_rates\UPSratesStruct\Ups_ratesUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRateRequest $body
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRateResponse|bool
     */
    public function ProcessRate(\Ups_rates\UPSratesStruct\Ups_ratesRateRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessRate($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
