<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeInTransitResponseType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesTimeInTransitResponseType extends AbstractStructBase
{
    /**
     * The PickupDate
     * @var string
     */
    public $PickupDate;
    /**
     * The DocumentsOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentsOnlyIndicator;
    /**
     * The PackageBillType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageBillType;
    /**
     * The AutoDutyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AutoDutyCode;
    /**
     * The Disclaimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Disclaimer;
    /**
     * The ServiceSummary
     * @var \Ups_rates\UPSratesStruct\Ups_ratesServiceSummaryType
     */
    public $ServiceSummary;
    /**
     * Constructor method for TimeInTransitResponseType
     * @uses Ups_ratesTimeInTransitResponseType::setPickupDate()
     * @uses Ups_ratesTimeInTransitResponseType::setDocumentsOnlyIndicator()
     * @uses Ups_ratesTimeInTransitResponseType::setPackageBillType()
     * @uses Ups_ratesTimeInTransitResponseType::setAutoDutyCode()
     * @uses Ups_ratesTimeInTransitResponseType::setDisclaimer()
     * @uses Ups_ratesTimeInTransitResponseType::setServiceSummary()
     * @param string $pickupDate
     * @param string $documentsOnlyIndicator
     * @param string $packageBillType
     * @param string $autoDutyCode
     * @param string $disclaimer
     * @param \Ups_rates\UPSratesStruct\Ups_ratesServiceSummaryType $serviceSummary
     */
    public function __construct($pickupDate = null, $documentsOnlyIndicator = null, $packageBillType = null, $autoDutyCode = null, $disclaimer = null, \Ups_rates\UPSratesStruct\Ups_ratesServiceSummaryType $serviceSummary = null)
    {
        $this
            ->setPickupDate($pickupDate)
            ->setDocumentsOnlyIndicator($documentsOnlyIndicator)
            ->setPackageBillType($packageBillType)
            ->setAutoDutyCode($autoDutyCode)
            ->setDisclaimer($disclaimer)
            ->setServiceSummary($serviceSummary);
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get DocumentsOnlyIndicator value
     * @return string|null
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->DocumentsOnlyIndicator;
    }
    /**
     * Set DocumentsOnlyIndicator value
     * @param string $documentsOnlyIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType
     */
    public function setDocumentsOnlyIndicator($documentsOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($documentsOnlyIndicator) && !is_string($documentsOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsOnlyIndicator, true), gettype($documentsOnlyIndicator)), __LINE__);
        }
        $this->DocumentsOnlyIndicator = $documentsOnlyIndicator;
        return $this;
    }
    /**
     * Get PackageBillType value
     * @return string|null
     */
    public function getPackageBillType()
    {
        return $this->PackageBillType;
    }
    /**
     * Set PackageBillType value
     * @param string $packageBillType
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType
     */
    public function setPackageBillType($packageBillType = null)
    {
        // validation for constraint: string
        if (!is_null($packageBillType) && !is_string($packageBillType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageBillType, true), gettype($packageBillType)), __LINE__);
        }
        $this->PackageBillType = $packageBillType;
        return $this;
    }
    /**
     * Get AutoDutyCode value
     * @return string|null
     */
    public function getAutoDutyCode()
    {
        return $this->AutoDutyCode;
    }
    /**
     * Set AutoDutyCode value
     * @param string $autoDutyCode
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType
     */
    public function setAutoDutyCode($autoDutyCode = null)
    {
        // validation for constraint: string
        if (!is_null($autoDutyCode) && !is_string($autoDutyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoDutyCode, true), gettype($autoDutyCode)), __LINE__);
        }
        $this->AutoDutyCode = $autoDutyCode;
        return $this;
    }
    /**
     * Get Disclaimer value
     * @return string|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * Set Disclaimer value
     * @param string $disclaimer
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType
     */
    public function setDisclaimer($disclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($disclaimer) && !is_string($disclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclaimer, true), gettype($disclaimer)), __LINE__);
        }
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Get ServiceSummary value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesServiceSummaryType|null
     */
    public function getServiceSummary()
    {
        return $this->ServiceSummary;
    }
    /**
     * Set ServiceSummary value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesServiceSummaryType $serviceSummary
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType
     */
    public function setServiceSummary(\Ups_rates\UPSratesStruct\Ups_ratesServiceSummaryType $serviceSummary = null)
    {
        $this->ServiceSummary = $serviceSummary;
        return $this;
    }
}
