<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatedShipmentType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesRatedShipmentType extends AbstractStructBase
{
    /**
     * The Disclaimer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType[]
     */
    public $Disclaimer;
    /**
     * The Service
     * @var \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType
     */
    public $Service;
    /**
     * The RateChart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RateChart;
    /**
     * The RatedShipmentAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType[]
     */
    public $RatedShipmentAlert;
    /**
     * The BillableWeightCalculationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillableWeightCalculationMethod;
    /**
     * The RatingMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RatingMethod;
    /**
     * The BillingWeight
     * @var \Ups_rates\UPSratesStruct\Ups_ratesBillingWeightType
     */
    public $BillingWeight;
    /**
     * The TransportationCharges
     * @var \Ups_rates\UPSratesStruct\Ups_ratesChargesType
     */
    public $TransportationCharges;
    /**
     * The BaseServiceCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesChargesType
     */
    public $BaseServiceCharge;
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesChargesType[]
     */
    public $ItemizedCharges;
    /**
     * The FRSShipmentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesFRSShipmentType
     */
    public $FRSShipmentData;
    /**
     * The ServiceOptionsCharges
     * @var \Ups_rates\UPSratesStruct\Ups_ratesChargesType
     */
    public $ServiceOptionsCharges;
    /**
     * The TaxCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType[]
     */
    public $TaxCharges;
    /**
     * The TotalCharges
     * @var \Ups_rates\UPSratesStruct\Ups_ratesChargesType
     */
    public $TotalCharges;
    /**
     * The TotalChargesWithTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesChargesType
     */
    public $TotalChargesWithTaxes;
    /**
     * The NegotiatedRateCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesTotalChargeType
     */
    public $NegotiatedRateCharges;
    /**
     * The GuaranteedDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType
     */
    public $GuaranteedDelivery;
    /**
     * The RatedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType[]
     */
    public $RatedPackage;
    /**
     * The TimeInTransit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType
     */
    public $TimeInTransit;
    /**
     * Constructor method for RatedShipmentType
     * @uses Ups_ratesRatedShipmentType::setDisclaimer()
     * @uses Ups_ratesRatedShipmentType::setService()
     * @uses Ups_ratesRatedShipmentType::setRateChart()
     * @uses Ups_ratesRatedShipmentType::setRatedShipmentAlert()
     * @uses Ups_ratesRatedShipmentType::setBillableWeightCalculationMethod()
     * @uses Ups_ratesRatedShipmentType::setRatingMethod()
     * @uses Ups_ratesRatedShipmentType::setBillingWeight()
     * @uses Ups_ratesRatedShipmentType::setTransportationCharges()
     * @uses Ups_ratesRatedShipmentType::setBaseServiceCharge()
     * @uses Ups_ratesRatedShipmentType::setItemizedCharges()
     * @uses Ups_ratesRatedShipmentType::setFRSShipmentData()
     * @uses Ups_ratesRatedShipmentType::setServiceOptionsCharges()
     * @uses Ups_ratesRatedShipmentType::setTaxCharges()
     * @uses Ups_ratesRatedShipmentType::setTotalCharges()
     * @uses Ups_ratesRatedShipmentType::setTotalChargesWithTaxes()
     * @uses Ups_ratesRatedShipmentType::setNegotiatedRateCharges()
     * @uses Ups_ratesRatedShipmentType::setGuaranteedDelivery()
     * @uses Ups_ratesRatedShipmentType::setRatedPackage()
     * @uses Ups_ratesRatedShipmentType::setTimeInTransit()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType[] $disclaimer
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service
     * @param string $rateChart
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType[] $ratedShipmentAlert
     * @param string $billableWeightCalculationMethod
     * @param string $ratingMethod
     * @param \Ups_rates\UPSratesStruct\Ups_ratesBillingWeightType $billingWeight
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $transportationCharges
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $baseServiceCharge
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType[] $itemizedCharges
     * @param \Ups_rates\UPSratesStruct\Ups_ratesFRSShipmentType $fRSShipmentData
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $serviceOptionsCharges
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType[] $taxCharges
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalCharges
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalChargesWithTaxes
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTotalChargeType $negotiatedRateCharges
     * @param \Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType $guaranteedDelivery
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType[] $ratedPackage
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType $timeInTransit
     */
    public function __construct(array $disclaimer = array(), \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service = null, $rateChart = null, array $ratedShipmentAlert = array(), $billableWeightCalculationMethod = null, $ratingMethod = null, \Ups_rates\UPSratesStruct\Ups_ratesBillingWeightType $billingWeight = null, \Ups_rates\UPSratesStruct\Ups_ratesChargesType $transportationCharges = null, \Ups_rates\UPSratesStruct\Ups_ratesChargesType $baseServiceCharge = null, array $itemizedCharges = array(), \Ups_rates\UPSratesStruct\Ups_ratesFRSShipmentType $fRSShipmentData = null, \Ups_rates\UPSratesStruct\Ups_ratesChargesType $serviceOptionsCharges = null, array $taxCharges = array(), \Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalCharges = null, \Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalChargesWithTaxes = null, \Ups_rates\UPSratesStruct\Ups_ratesTotalChargeType $negotiatedRateCharges = null, \Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType $guaranteedDelivery = null, array $ratedPackage = array(), \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType $timeInTransit = null)
    {
        $this
            ->setDisclaimer($disclaimer)
            ->setService($service)
            ->setRateChart($rateChart)
            ->setRatedShipmentAlert($ratedShipmentAlert)
            ->setBillableWeightCalculationMethod($billableWeightCalculationMethod)
            ->setRatingMethod($ratingMethod)
            ->setBillingWeight($billingWeight)
            ->setTransportationCharges($transportationCharges)
            ->setBaseServiceCharge($baseServiceCharge)
            ->setItemizedCharges($itemizedCharges)
            ->setFRSShipmentData($fRSShipmentData)
            ->setServiceOptionsCharges($serviceOptionsCharges)
            ->setTaxCharges($taxCharges)
            ->setTotalCharges($totalCharges)
            ->setTotalChargesWithTaxes($totalChargesWithTaxes)
            ->setNegotiatedRateCharges($negotiatedRateCharges)
            ->setGuaranteedDelivery($guaranteedDelivery)
            ->setRatedPackage($ratedPackage)
            ->setTimeInTransit($timeInTransit);
    }
    /**
     * Get Disclaimer value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType[]|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclaimer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclaimer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclaimerForArrayConstraintsFromSetDisclaimer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratedShipmentTypeDisclaimerItem) {
            // validation for constraint: itemType
            if (!$ratedShipmentTypeDisclaimerItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType) {
                $invalidValues[] = is_object($ratedShipmentTypeDisclaimerItem) ? get_class($ratedShipmentTypeDisclaimerItem) : sprintf('%s(%s)', gettype($ratedShipmentTypeDisclaimerItem), var_export($ratedShipmentTypeDisclaimerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disclaimer property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType[] $disclaimer
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setDisclaimer(array $disclaimer = array())
    {
        // validation for constraint: array
        if ('' !== ($disclaimerArrayErrorMessage = self::validateDisclaimerForArrayConstraintsFromSetDisclaimer($disclaimer))) {
            throw new \InvalidArgumentException($disclaimerArrayErrorMessage, __LINE__);
        }
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Add item to Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function addToDisclaimer(\Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType) {
            throw new \InvalidArgumentException(sprintf('The Disclaimer property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesDisclaimerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disclaimer[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setService(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get RateChart value
     * @return string|null
     */
    public function getRateChart()
    {
        return $this->RateChart;
    }
    /**
     * Set RateChart value
     * @param string $rateChart
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setRateChart($rateChart = null)
    {
        // validation for constraint: string
        if (!is_null($rateChart) && !is_string($rateChart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateChart, true), gettype($rateChart)), __LINE__);
        }
        $this->RateChart = $rateChart;
        return $this;
    }
    /**
     * Get RatedShipmentAlert value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType[]|null
     */
    public function getRatedShipmentAlert()
    {
        return $this->RatedShipmentAlert;
    }
    /**
     * This method is responsible for validating the values passed to the setRatedShipmentAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRatedShipmentAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatedShipmentAlertForArrayConstraintsFromSetRatedShipmentAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratedShipmentTypeRatedShipmentAlertItem) {
            // validation for constraint: itemType
            if (!$ratedShipmentTypeRatedShipmentAlertItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType) {
                $invalidValues[] = is_object($ratedShipmentTypeRatedShipmentAlertItem) ? get_class($ratedShipmentTypeRatedShipmentAlertItem) : sprintf('%s(%s)', gettype($ratedShipmentTypeRatedShipmentAlertItem), var_export($ratedShipmentTypeRatedShipmentAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RatedShipmentAlert property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RatedShipmentAlert value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType[] $ratedShipmentAlert
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setRatedShipmentAlert(array $ratedShipmentAlert = array())
    {
        // validation for constraint: array
        if ('' !== ($ratedShipmentAlertArrayErrorMessage = self::validateRatedShipmentAlertForArrayConstraintsFromSetRatedShipmentAlert($ratedShipmentAlert))) {
            throw new \InvalidArgumentException($ratedShipmentAlertArrayErrorMessage, __LINE__);
        }
        $this->RatedShipmentAlert = $ratedShipmentAlert;
        return $this;
    }
    /**
     * Add item to RatedShipmentAlert value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function addToRatedShipmentAlert(\Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType) {
            throw new \InvalidArgumentException(sprintf('The RatedShipmentAlert property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RatedShipmentAlert[] = $item;
        return $this;
    }
    /**
     * Get BillableWeightCalculationMethod value
     * @return string|null
     */
    public function getBillableWeightCalculationMethod()
    {
        return $this->BillableWeightCalculationMethod;
    }
    /**
     * Set BillableWeightCalculationMethod value
     * @param string $billableWeightCalculationMethod
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setBillableWeightCalculationMethod($billableWeightCalculationMethod = null)
    {
        // validation for constraint: string
        if (!is_null($billableWeightCalculationMethod) && !is_string($billableWeightCalculationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billableWeightCalculationMethod, true), gettype($billableWeightCalculationMethod)), __LINE__);
        }
        $this->BillableWeightCalculationMethod = $billableWeightCalculationMethod;
        return $this;
    }
    /**
     * Get RatingMethod value
     * @return string|null
     */
    public function getRatingMethod()
    {
        return $this->RatingMethod;
    }
    /**
     * Set RatingMethod value
     * @param string $ratingMethod
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setRatingMethod($ratingMethod = null)
    {
        // validation for constraint: string
        if (!is_null($ratingMethod) && !is_string($ratingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratingMethod, true), gettype($ratingMethod)), __LINE__);
        }
        $this->RatingMethod = $ratingMethod;
        return $this;
    }
    /**
     * Get BillingWeight value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesBillingWeightType|null
     */
    public function getBillingWeight()
    {
        return $this->BillingWeight;
    }
    /**
     * Set BillingWeight value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesBillingWeightType $billingWeight
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setBillingWeight(\Ups_rates\UPSratesStruct\Ups_ratesBillingWeightType $billingWeight = null)
    {
        $this->BillingWeight = $billingWeight;
        return $this;
    }
    /**
     * Get TransportationCharges value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesChargesType|null
     */
    public function getTransportationCharges()
    {
        return $this->TransportationCharges;
    }
    /**
     * Set TransportationCharges value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $transportationCharges
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setTransportationCharges(\Ups_rates\UPSratesStruct\Ups_ratesChargesType $transportationCharges = null)
    {
        $this->TransportationCharges = $transportationCharges;
        return $this;
    }
    /**
     * Get BaseServiceCharge value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesChargesType|null
     */
    public function getBaseServiceCharge()
    {
        return $this->BaseServiceCharge;
    }
    /**
     * Set BaseServiceCharge value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $baseServiceCharge
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setBaseServiceCharge(\Ups_rates\UPSratesStruct\Ups_ratesChargesType $baseServiceCharge = null)
    {
        $this->BaseServiceCharge = $baseServiceCharge;
        return $this;
    }
    /**
     * Get ItemizedCharges value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesChargesType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratedShipmentTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$ratedShipmentTypeItemizedChargesItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesChargesType) {
                $invalidValues[] = is_object($ratedShipmentTypeItemizedChargesItem) ? get_class($ratedShipmentTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($ratedShipmentTypeItemizedChargesItem), var_export($ratedShipmentTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesChargesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType[] $itemizedCharges
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function addToItemizedCharges(\Ups_rates\UPSratesStruct\Ups_ratesChargesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesChargesType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesChargesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get FRSShipmentData value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesFRSShipmentType|null
     */
    public function getFRSShipmentData()
    {
        return $this->FRSShipmentData;
    }
    /**
     * Set FRSShipmentData value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesFRSShipmentType $fRSShipmentData
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setFRSShipmentData(\Ups_rates\UPSratesStruct\Ups_ratesFRSShipmentType $fRSShipmentData = null)
    {
        $this->FRSShipmentData = $fRSShipmentData;
        return $this;
    }
    /**
     * Get ServiceOptionsCharges value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesChargesType|null
     */
    public function getServiceOptionsCharges()
    {
        return $this->ServiceOptionsCharges;
    }
    /**
     * Set ServiceOptionsCharges value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $serviceOptionsCharges
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setServiceOptionsCharges(\Ups_rates\UPSratesStruct\Ups_ratesChargesType $serviceOptionsCharges = null)
    {
        $this->ServiceOptionsCharges = $serviceOptionsCharges;
        return $this;
    }
    /**
     * Get TaxCharges value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType[]|null
     */
    public function getTaxCharges()
    {
        return $this->TaxCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxChargesForArrayConstraintsFromSetTaxCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratedShipmentTypeTaxChargesItem) {
            // validation for constraint: itemType
            if (!$ratedShipmentTypeTaxChargesItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType) {
                $invalidValues[] = is_object($ratedShipmentTypeTaxChargesItem) ? get_class($ratedShipmentTypeTaxChargesItem) : sprintf('%s(%s)', gettype($ratedShipmentTypeTaxChargesItem), var_export($ratedShipmentTypeTaxChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCharges property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType[] $taxCharges
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setTaxCharges(array $taxCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($taxChargesArrayErrorMessage = self::validateTaxChargesForArrayConstraintsFromSetTaxCharges($taxCharges))) {
            throw new \InvalidArgumentException($taxChargesArrayErrorMessage, __LINE__);
        }
        $this->TaxCharges = $taxCharges;
        return $this;
    }
    /**
     * Add item to TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function addToTaxCharges(\Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType) {
            throw new \InvalidArgumentException(sprintf('The TaxCharges property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesTaxChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCharges[] = $item;
        return $this;
    }
    /**
     * Get TotalCharges value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesChargesType|null
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalCharges
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setTotalCharges(\Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalCharges = null)
    {
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get TotalChargesWithTaxes value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesChargesType|null
     */
    public function getTotalChargesWithTaxes()
    {
        return $this->TotalChargesWithTaxes;
    }
    /**
     * Set TotalChargesWithTaxes value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalChargesWithTaxes
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setTotalChargesWithTaxes(\Ups_rates\UPSratesStruct\Ups_ratesChargesType $totalChargesWithTaxes = null)
    {
        $this->TotalChargesWithTaxes = $totalChargesWithTaxes;
        return $this;
    }
    /**
     * Get NegotiatedRateCharges value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTotalChargeType|null
     */
    public function getNegotiatedRateCharges()
    {
        return $this->NegotiatedRateCharges;
    }
    /**
     * Set NegotiatedRateCharges value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTotalChargeType $negotiatedRateCharges
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setNegotiatedRateCharges(\Ups_rates\UPSratesStruct\Ups_ratesTotalChargeType $negotiatedRateCharges = null)
    {
        $this->NegotiatedRateCharges = $negotiatedRateCharges;
        return $this;
    }
    /**
     * Get GuaranteedDelivery value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType|null
     */
    public function getGuaranteedDelivery()
    {
        return $this->GuaranteedDelivery;
    }
    /**
     * Set GuaranteedDelivery value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType $guaranteedDelivery
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setGuaranteedDelivery(\Ups_rates\UPSratesStruct\Ups_ratesGuaranteedDeliveryType $guaranteedDelivery = null)
    {
        $this->GuaranteedDelivery = $guaranteedDelivery;
        return $this;
    }
    /**
     * Get RatedPackage value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType[]|null
     */
    public function getRatedPackage()
    {
        return $this->RatedPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setRatedPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRatedPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatedPackageForArrayConstraintsFromSetRatedPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratedShipmentTypeRatedPackageItem) {
            // validation for constraint: itemType
            if (!$ratedShipmentTypeRatedPackageItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType) {
                $invalidValues[] = is_object($ratedShipmentTypeRatedPackageItem) ? get_class($ratedShipmentTypeRatedPackageItem) : sprintf('%s(%s)', gettype($ratedShipmentTypeRatedPackageItem), var_export($ratedShipmentTypeRatedPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RatedPackage property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RatedPackage value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType[] $ratedPackage
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setRatedPackage(array $ratedPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($ratedPackageArrayErrorMessage = self::validateRatedPackageForArrayConstraintsFromSetRatedPackage($ratedPackage))) {
            throw new \InvalidArgumentException($ratedPackageArrayErrorMessage, __LINE__);
        }
        $this->RatedPackage = $ratedPackage;
        return $this;
    }
    /**
     * Add item to RatedPackage value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function addToRatedPackage(\Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType) {
            throw new \InvalidArgumentException(sprintf('The RatedPackage property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesRatedPackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RatedPackage[] = $item;
        return $this;
    }
    /**
     * Get TimeInTransit value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType|null
     */
    public function getTimeInTransit()
    {
        return $this->TimeInTransit;
    }
    /**
     * Set TimeInTransit value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType $timeInTransit
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType
     */
    public function setTimeInTransit(\Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitResponseType $timeInTransit = null)
    {
        $this->TimeInTransit = $timeInTransit;
        return $this;
    }
}
