<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazMatType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesHazMatType extends AbstractStructBase
{
    /**
     * The PackageIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageIdentifier;
    /**
     * The QValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QValue;
    /**
     * The OverPackedIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OverPackedIndicator;
    /**
     * The AllPackedInOneIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AllPackedInOneIndicator;
    /**
     * The HazMatChemicalRecord
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * @var \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType[]
     */
    public $HazMatChemicalRecord;
    /**
     * Constructor method for HazMatType
     * @uses Ups_ratesHazMatType::setPackageIdentifier()
     * @uses Ups_ratesHazMatType::setQValue()
     * @uses Ups_ratesHazMatType::setOverPackedIndicator()
     * @uses Ups_ratesHazMatType::setAllPackedInOneIndicator()
     * @uses Ups_ratesHazMatType::setHazMatChemicalRecord()
     * @param string $packageIdentifier
     * @param string $qValue
     * @param string $overPackedIndicator
     * @param string $allPackedInOneIndicator
     * @param \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType[] $hazMatChemicalRecord
     */
    public function __construct($packageIdentifier = null, $qValue = null, $overPackedIndicator = null, $allPackedInOneIndicator = null, array $hazMatChemicalRecord = array())
    {
        $this
            ->setPackageIdentifier($packageIdentifier)
            ->setQValue($qValue)
            ->setOverPackedIndicator($overPackedIndicator)
            ->setAllPackedInOneIndicator($allPackedInOneIndicator)
            ->setHazMatChemicalRecord($hazMatChemicalRecord);
    }
    /**
     * Get PackageIdentifier value
     * @return string|null
     */
    public function getPackageIdentifier()
    {
        return $this->PackageIdentifier;
    }
    /**
     * Set PackageIdentifier value
     * @param string $packageIdentifier
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHazMatType
     */
    public function setPackageIdentifier($packageIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($packageIdentifier) && !is_string($packageIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageIdentifier, true), gettype($packageIdentifier)), __LINE__);
        }
        $this->PackageIdentifier = $packageIdentifier;
        return $this;
    }
    /**
     * Get QValue value
     * @return string|null
     */
    public function getQValue()
    {
        return $this->QValue;
    }
    /**
     * Set QValue value
     * @param string $qValue
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHazMatType
     */
    public function setQValue($qValue = null)
    {
        // validation for constraint: string
        if (!is_null($qValue) && !is_string($qValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qValue, true), gettype($qValue)), __LINE__);
        }
        $this->QValue = $qValue;
        return $this;
    }
    /**
     * Get OverPackedIndicator value
     * @return string|null
     */
    public function getOverPackedIndicator()
    {
        return $this->OverPackedIndicator;
    }
    /**
     * Set OverPackedIndicator value
     * @param string $overPackedIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHazMatType
     */
    public function setOverPackedIndicator($overPackedIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($overPackedIndicator) && !is_string($overPackedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overPackedIndicator, true), gettype($overPackedIndicator)), __LINE__);
        }
        $this->OverPackedIndicator = $overPackedIndicator;
        return $this;
    }
    /**
     * Get AllPackedInOneIndicator value
     * @return string|null
     */
    public function getAllPackedInOneIndicator()
    {
        return $this->AllPackedInOneIndicator;
    }
    /**
     * Set AllPackedInOneIndicator value
     * @param string $allPackedInOneIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHazMatType
     */
    public function setAllPackedInOneIndicator($allPackedInOneIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($allPackedInOneIndicator) && !is_string($allPackedInOneIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allPackedInOneIndicator, true), gettype($allPackedInOneIndicator)), __LINE__);
        }
        $this->AllPackedInOneIndicator = $allPackedInOneIndicator;
        return $this;
    }
    /**
     * Get HazMatChemicalRecord value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType[]|null
     */
    public function getHazMatChemicalRecord()
    {
        return $this->HazMatChemicalRecord;
    }
    /**
     * This method is responsible for validating the values passed to the setHazMatChemicalRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazMatChemicalRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazMatChemicalRecordForArrayConstraintsFromSetHazMatChemicalRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hazMatTypeHazMatChemicalRecordItem) {
            // validation for constraint: itemType
            if (!$hazMatTypeHazMatChemicalRecordItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType) {
                $invalidValues[] = is_object($hazMatTypeHazMatChemicalRecordItem) ? get_class($hazMatTypeHazMatChemicalRecordItem) : sprintf('%s(%s)', gettype($hazMatTypeHazMatChemicalRecordItem), var_export($hazMatTypeHazMatChemicalRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazMatChemicalRecord property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HazMatChemicalRecord value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType[] $hazMatChemicalRecord
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHazMatType
     */
    public function setHazMatChemicalRecord(array $hazMatChemicalRecord = array())
    {
        // validation for constraint: array
        if ('' !== ($hazMatChemicalRecordArrayErrorMessage = self::validateHazMatChemicalRecordForArrayConstraintsFromSetHazMatChemicalRecord($hazMatChemicalRecord))) {
            throw new \InvalidArgumentException($hazMatChemicalRecordArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($hazMatChemicalRecord) && count($hazMatChemicalRecord) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($hazMatChemicalRecord)), __LINE__);
        }
        $this->HazMatChemicalRecord = $hazMatChemicalRecord;
        return $this;
    }
    /**
     * Add item to HazMatChemicalRecord value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHazMatType
     */
    public function addToHazMatChemicalRecord(\Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType) {
            throw new \InvalidArgumentException(sprintf('The HazMatChemicalRecord property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesHazMatChemicalRecordType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->HazMatChemicalRecord) && count($this->HazMatChemicalRecord) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->HazMatChemicalRecord)), __LINE__);
        }
        $this->HazMatChemicalRecord[] = $item;
        return $this;
    }
}
