<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesHandlingUnitsType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Type
     * @var \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType
     */
    public $Type;
    /**
     * The Dimensions
     * @var \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsDimensionsType
     */
    public $Dimensions;
    /**
     * Constructor method for HandlingUnitsType
     * @uses Ups_ratesHandlingUnitsType::setQuantity()
     * @uses Ups_ratesHandlingUnitsType::setType()
     * @uses Ups_ratesHandlingUnitsType::setDimensions()
     * @param string $quantity
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type
     * @param \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsDimensionsType $dimensions
     */
    public function __construct($quantity = null, \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type = null, \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsDimensionsType $dimensions = null)
    {
        $this
            ->setQuantity($quantity)
            ->setType($type)
            ->setDimensions($dimensions);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsType
     */
    public function setType(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsDimensionsType $dimensions
     * @return \Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsType
     */
    public function setDimensions(\Ups_rates\UPSratesStruct\Ups_ratesHandlingUnitsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
}
