<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateResponse UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesRateResponse extends AbstractStructBase
{
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - ref: common:Response
     * @var \Ups_rates\UPSratesStruct\Ups_ratesResponseType
     */
    public $Response;
    /**
     * The RatedShipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType[]
     */
    public $RatedShipment;
    /**
     * Constructor method for RateResponse
     * @uses Ups_ratesRateResponse::setResponse()
     * @uses Ups_ratesRateResponse::setRatedShipment()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesResponseType $response
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType[] $ratedShipment
     */
    public function __construct(\Ups_rates\UPSratesStruct\Ups_ratesResponseType $response = null, array $ratedShipment = array())
    {
        $this
            ->setResponse($response)
            ->setRatedShipment($ratedShipment);
    }
    /**
     * Get Response value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesResponseType|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesResponseType $response
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRateResponse
     */
    public function setResponse(\Ups_rates\UPSratesStruct\Ups_ratesResponseType $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get RatedShipment value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType[]|null
     */
    public function getRatedShipment()
    {
        return $this->RatedShipment;
    }
    /**
     * This method is responsible for validating the values passed to the setRatedShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRatedShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatedShipmentForArrayConstraintsFromSetRatedShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateResponseRatedShipmentItem) {
            // validation for constraint: itemType
            if (!$rateResponseRatedShipmentItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType) {
                $invalidValues[] = is_object($rateResponseRatedShipmentItem) ? get_class($rateResponseRatedShipmentItem) : sprintf('%s(%s)', gettype($rateResponseRatedShipmentItem), var_export($rateResponseRatedShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RatedShipment property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RatedShipment value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType[] $ratedShipment
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRateResponse
     */
    public function setRatedShipment(array $ratedShipment = array())
    {
        // validation for constraint: array
        if ('' !== ($ratedShipmentArrayErrorMessage = self::validateRatedShipmentForArrayConstraintsFromSetRatedShipment($ratedShipment))) {
            throw new \InvalidArgumentException($ratedShipmentArrayErrorMessage, __LINE__);
        }
        $this->RatedShipment = $ratedShipment;
        return $this;
    }
    /**
     * Add item to RatedShipment value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesRateResponse
     */
    public function addToRatedShipment(\Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType) {
            throw new \InvalidArgumentException(sprintf('The RatedShipment property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesRatedShipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RatedShipment[] = $item;
        return $this;
    }
}
