<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FRSPaymentInfoType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesFRSPaymentInfoType extends AbstractStructBase
{
    /**
     * The Type
     * @var \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType
     */
    public $Type;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesPayerAddressType
     */
    public $Address;
    /**
     * Constructor method for FRSPaymentInfoType
     * @uses Ups_ratesFRSPaymentInfoType::setType()
     * @uses Ups_ratesFRSPaymentInfoType::setAccountNumber()
     * @uses Ups_ratesFRSPaymentInfoType::setAddress()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type
     * @param string $accountNumber
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPayerAddressType $address
     */
    public function __construct(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type = null, $accountNumber = null, \Ups_rates\UPSratesStruct\Ups_ratesPayerAddressType $address = null)
    {
        $this
            ->setType($type)
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get Type value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type
     * @return \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType
     */
    public function setType(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPayerAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPayerAddressType $address
     * @return \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType
     */
    public function setAddress(\Ups_rates\UPSratesStruct\Ups_ratesPayerAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
