<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedArrivalType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesEstimatedArrivalType extends AbstractStructBase
{
    /**
     * The Arrival
     * @var \Ups_rates\UPSratesStruct\Ups_ratesPickupType
     */
    public $Arrival;
    /**
     * The BusinessDaysInTransit
     * @var string
     */
    public $BusinessDaysInTransit;
    /**
     * The Pickup
     * @var \Ups_rates\UPSratesStruct\Ups_ratesPickupType
     */
    public $Pickup;
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DayOfWeek;
    /**
     * The CustomerCenterCutoff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCenterCutoff;
    /**
     * The DelayCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DelayCount;
    /**
     * The HolidayCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HolidayCount;
    /**
     * The RestDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RestDays;
    /**
     * The TotalTransitDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalTransitDays;
    /**
     * Constructor method for EstimatedArrivalType
     * @uses Ups_ratesEstimatedArrivalType::setArrival()
     * @uses Ups_ratesEstimatedArrivalType::setBusinessDaysInTransit()
     * @uses Ups_ratesEstimatedArrivalType::setPickup()
     * @uses Ups_ratesEstimatedArrivalType::setDayOfWeek()
     * @uses Ups_ratesEstimatedArrivalType::setCustomerCenterCutoff()
     * @uses Ups_ratesEstimatedArrivalType::setDelayCount()
     * @uses Ups_ratesEstimatedArrivalType::setHolidayCount()
     * @uses Ups_ratesEstimatedArrivalType::setRestDays()
     * @uses Ups_ratesEstimatedArrivalType::setTotalTransitDays()
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPickupType $arrival
     * @param string $businessDaysInTransit
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPickupType $pickup
     * @param string $dayOfWeek
     * @param string $customerCenterCutoff
     * @param string $delayCount
     * @param string $holidayCount
     * @param string $restDays
     * @param string $totalTransitDays
     */
    public function __construct(\Ups_rates\UPSratesStruct\Ups_ratesPickupType $arrival = null, $businessDaysInTransit = null, \Ups_rates\UPSratesStruct\Ups_ratesPickupType $pickup = null, $dayOfWeek = null, $customerCenterCutoff = null, $delayCount = null, $holidayCount = null, $restDays = null, $totalTransitDays = null)
    {
        $this
            ->setArrival($arrival)
            ->setBusinessDaysInTransit($businessDaysInTransit)
            ->setPickup($pickup)
            ->setDayOfWeek($dayOfWeek)
            ->setCustomerCenterCutoff($customerCenterCutoff)
            ->setDelayCount($delayCount)
            ->setHolidayCount($holidayCount)
            ->setRestDays($restDays)
            ->setTotalTransitDays($totalTransitDays);
    }
    /**
     * Get Arrival value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPickupType|null
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPickupType $arrival
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setArrival(\Ups_rates\UPSratesStruct\Ups_ratesPickupType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get BusinessDaysInTransit value
     * @return string|null
     */
    public function getBusinessDaysInTransit()
    {
        return $this->BusinessDaysInTransit;
    }
    /**
     * Set BusinessDaysInTransit value
     * @param string $businessDaysInTransit
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setBusinessDaysInTransit($businessDaysInTransit = null)
    {
        // validation for constraint: string
        if (!is_null($businessDaysInTransit) && !is_string($businessDaysInTransit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessDaysInTransit, true), gettype($businessDaysInTransit)), __LINE__);
        }
        $this->BusinessDaysInTransit = $businessDaysInTransit;
        return $this;
    }
    /**
     * Get Pickup value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPickupType|null
     */
    public function getPickup()
    {
        return $this->Pickup;
    }
    /**
     * Set Pickup value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPickupType $pickup
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setPickup(\Ups_rates\UPSratesStruct\Ups_ratesPickupType $pickup = null)
    {
        $this->Pickup = $pickup;
        return $this;
    }
    /**
     * Get DayOfWeek value
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return $this->DayOfWeek;
    }
    /**
     * Set DayOfWeek value
     * @param string $dayOfWeek
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfWeek) && !is_string($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayOfWeek, true), gettype($dayOfWeek)), __LINE__);
        }
        $this->DayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get CustomerCenterCutoff value
     * @return string|null
     */
    public function getCustomerCenterCutoff()
    {
        return $this->CustomerCenterCutoff;
    }
    /**
     * Set CustomerCenterCutoff value
     * @param string $customerCenterCutoff
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setCustomerCenterCutoff($customerCenterCutoff = null)
    {
        // validation for constraint: string
        if (!is_null($customerCenterCutoff) && !is_string($customerCenterCutoff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCenterCutoff, true), gettype($customerCenterCutoff)), __LINE__);
        }
        $this->CustomerCenterCutoff = $customerCenterCutoff;
        return $this;
    }
    /**
     * Get DelayCount value
     * @return string|null
     */
    public function getDelayCount()
    {
        return $this->DelayCount;
    }
    /**
     * Set DelayCount value
     * @param string $delayCount
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setDelayCount($delayCount = null)
    {
        // validation for constraint: string
        if (!is_null($delayCount) && !is_string($delayCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delayCount, true), gettype($delayCount)), __LINE__);
        }
        $this->DelayCount = $delayCount;
        return $this;
    }
    /**
     * Get HolidayCount value
     * @return string|null
     */
    public function getHolidayCount()
    {
        return $this->HolidayCount;
    }
    /**
     * Set HolidayCount value
     * @param string $holidayCount
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setHolidayCount($holidayCount = null)
    {
        // validation for constraint: string
        if (!is_null($holidayCount) && !is_string($holidayCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holidayCount, true), gettype($holidayCount)), __LINE__);
        }
        $this->HolidayCount = $holidayCount;
        return $this;
    }
    /**
     * Get RestDays value
     * @return string|null
     */
    public function getRestDays()
    {
        return $this->RestDays;
    }
    /**
     * Set RestDays value
     * @param string $restDays
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setRestDays($restDays = null)
    {
        // validation for constraint: string
        if (!is_null($restDays) && !is_string($restDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restDays, true), gettype($restDays)), __LINE__);
        }
        $this->RestDays = $restDays;
        return $this;
    }
    /**
     * Get TotalTransitDays value
     * @return string|null
     */
    public function getTotalTransitDays()
    {
        return $this->TotalTransitDays;
    }
    /**
     * Set TotalTransitDays value
     * @param string $totalTransitDays
     * @return \Ups_rates\UPSratesStruct\Ups_ratesEstimatedArrivalType
     */
    public function setTotalTransitDays($totalTransitDays = null)
    {
        // validation for constraint: string
        if (!is_null($totalTransitDays) && !is_string($totalTransitDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalTransitDays, true), gettype($totalTransitDays)), __LINE__);
        }
        $this->TotalTransitDays = $totalTransitDays;
        return $this;
    }
}
