<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CODType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesCODType extends AbstractStructBase
{
    /**
     * The CODFundsCode
     * @var string
     */
    public $CODFundsCode;
    /**
     * The CODAmount
     * @var \Ups_rates\UPSratesStruct\Ups_ratesCODAmountType
     */
    public $CODAmount;
    /**
     * Constructor method for CODType
     * @uses Ups_ratesCODType::setCODFundsCode()
     * @uses Ups_ratesCODType::setCODAmount()
     * @param string $cODFundsCode
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCODAmountType $cODAmount
     */
    public function __construct($cODFundsCode = null, \Ups_rates\UPSratesStruct\Ups_ratesCODAmountType $cODAmount = null)
    {
        $this
            ->setCODFundsCode($cODFundsCode)
            ->setCODAmount($cODAmount);
    }
    /**
     * Get CODFundsCode value
     * @return string|null
     */
    public function getCODFundsCode()
    {
        return $this->CODFundsCode;
    }
    /**
     * Set CODFundsCode value
     * @param string $cODFundsCode
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCODType
     */
    public function setCODFundsCode($cODFundsCode = null)
    {
        // validation for constraint: string
        if (!is_null($cODFundsCode) && !is_string($cODFundsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODFundsCode, true), gettype($cODFundsCode)), __LINE__);
        }
        $this->CODFundsCode = $cODFundsCode;
        return $this;
    }
    /**
     * Get CODAmount value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCODAmountType|null
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCODAmountType $cODAmount
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCODType
     */
    public function setCODAmount(\Ups_rates\UPSratesStruct\Ups_ratesCODAmountType $cODAmount = null)
    {
        $this->CODAmount = $cODAmount;
        return $this;
    }
}
