<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillThirdPartyChargeType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesBillThirdPartyChargeType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesAddressType
     */
    public $Address;
    /**
     * Constructor method for BillThirdPartyChargeType
     * @uses Ups_ratesBillThirdPartyChargeType::setAccountNumber()
     * @uses Ups_ratesBillThirdPartyChargeType::setAddress()
     * @param string $accountNumber
     * @param \Ups_rates\UPSratesStruct\Ups_ratesAddressType $address
     */
    public function __construct($accountNumber = null, \Ups_rates\UPSratesStruct\Ups_ratesAddressType $address = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups_rates\UPSratesStruct\Ups_ratesBillThirdPartyChargeType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesAddressType $address
     * @return \Ups_rates\UPSratesStruct\Ups_ratesBillThirdPartyChargeType
     */
    public function setAddress(\Ups_rates\UPSratesStruct\Ups_ratesAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
