<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType UPStrackStruct
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackResponseType extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * @var \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType
     */
    public $ResponseStatus;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType[]
     */
    public $Alert;
    /**
     * The AlertDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDetailType[]
     */
    public $AlertDetail;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for ResponseType
     * @uses Ups_trackResponseType::setResponseStatus()
     * @uses Ups_trackResponseType::setAlert()
     * @uses Ups_trackResponseType::setAlertDetail()
     * @uses Ups_trackResponseType::setTransactionReference()
     * @param \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType $responseStatus
     * @param \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType[] $alert
     * @param \Ups_track\UPStrackStruct\Ups_trackDetailType[] $alertDetail
     * @param \Ups_track\UPStrackStruct\Ups_trackTransactionReferenceType $transactionReference
     */
    public function __construct(\Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType $responseStatus = null, array $alert = array(), array $alertDetail = array(), \Ups_track\UPStrackStruct\Ups_trackTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setAlert($alert)
            ->setAlertDetail($alertDetail)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get ResponseStatus value
     * @return \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType $responseStatus
     * @return \Ups_track\UPStrackStruct\Ups_trackResponseType
     */
    public function setResponseStatus(\Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get Alert value
     * @return \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertItem instanceof \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType) {
                $invalidValues[] = is_object($responseTypeAlertItem) ? get_class($responseTypeAlertItem) : sprintf('%s(%s)', gettype($responseTypeAlertItem), var_export($responseTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType[] $alert
     * @return \Ups_track\UPStrackStruct\Ups_trackResponseType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackResponseType
     */
    public function addToAlert(\Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get AlertDetail value
     * @return \Ups_track\UPStrackStruct\Ups_trackDetailType[]|null
     */
    public function getAlertDetail()
    {
        return $this->AlertDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAlertDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlertDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertDetailForArrayConstraintsFromSetAlertDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertDetailItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertDetailItem instanceof \Ups_track\UPStrackStruct\Ups_trackDetailType) {
                $invalidValues[] = is_object($responseTypeAlertDetailItem) ? get_class($responseTypeAlertDetailItem) : sprintf('%s(%s)', gettype($responseTypeAlertDetailItem), var_export($responseTypeAlertDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlertDetail property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDetailType[] $alertDetail
     * @return \Ups_track\UPStrackStruct\Ups_trackResponseType
     */
    public function setAlertDetail(array $alertDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($alertDetailArrayErrorMessage = self::validateAlertDetailForArrayConstraintsFromSetAlertDetail($alertDetail))) {
            throw new \InvalidArgumentException($alertDetailArrayErrorMessage, __LINE__);
        }
        $this->AlertDetail = $alertDetail;
        return $this;
    }
    /**
     * Add item to AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDetailType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackResponseType
     */
    public function addToAlertDetail(\Ups_track\UPStrackStruct\Ups_trackDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackDetailType) {
            throw new \InvalidArgumentException(sprintf('The AlertDetail property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlertDetail[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups_track\UPStrackStruct\Ups_trackTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups_track\UPStrackStruct\Ups_trackTransactionReferenceType $transactionReference
     * @return \Ups_track\UPStrackStruct\Ups_trackResponseType
     */
    public function setTransactionReference(\Ups_track\UPStrackStruct\Ups_trackTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
