<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureImageType UPStrackStruct
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackSignatureImageType extends AbstractStructBase
{
    /**
     * The GraphicImage
     * @var string
     */
    public $GraphicImage;
    /**
     * The ImageFormat
     * @var \Ups_track\UPStrackStruct\Ups_trackImageFormatType
     */
    public $ImageFormat;
    /**
     * Constructor method for SignatureImageType
     * @uses Ups_trackSignatureImageType::setGraphicImage()
     * @uses Ups_trackSignatureImageType::setImageFormat()
     * @param string $graphicImage
     * @param \Ups_track\UPStrackStruct\Ups_trackImageFormatType $imageFormat
     */
    public function __construct($graphicImage = null, \Ups_track\UPStrackStruct\Ups_trackImageFormatType $imageFormat = null)
    {
        $this
            ->setGraphicImage($graphicImage)
            ->setImageFormat($imageFormat);
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups_track\UPStrackStruct\Ups_trackSignatureImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
    /**
     * Get ImageFormat value
     * @return \Ups_track\UPStrackStruct\Ups_trackImageFormatType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \Ups_track\UPStrackStruct\Ups_trackImageFormatType $imageFormat
     * @return \Ups_track\UPStrackStruct\Ups_trackSignatureImageType
     */
    public function setImageFormat(\Ups_track\UPStrackStruct\Ups_trackImageFormatType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
}
