<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestTransactionReferenceType UPStrackStruct
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackRequestTransactionReferenceType extends AbstractStructBase
{
    /**
     * The CustomerContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerContext;
    /**
     * The TransactionIdentifierPlayback
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionIdentifierPlayback;
    /**
     * Constructor method for RequestTransactionReferenceType
     * @uses Ups_trackRequestTransactionReferenceType::setCustomerContext()
     * @uses Ups_trackRequestTransactionReferenceType::setTransactionIdentifierPlayback()
     * @param string $customerContext
     * @param string $transactionIdentifierPlayback
     */
    public function __construct($customerContext = null, $transactionIdentifierPlayback = null)
    {
        $this
            ->setCustomerContext($customerContext)
            ->setTransactionIdentifierPlayback($transactionIdentifierPlayback);
    }
    /**
     * Get CustomerContext value
     * @return string|null
     */
    public function getCustomerContext()
    {
        return $this->CustomerContext;
    }
    /**
     * Set CustomerContext value
     * @param string $customerContext
     * @return \Ups_track\UPStrackStruct\Ups_trackRequestTransactionReferenceType
     */
    public function setCustomerContext($customerContext = null)
    {
        // validation for constraint: string
        if (!is_null($customerContext) && !is_string($customerContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerContext, true), gettype($customerContext)), __LINE__);
        }
        $this->CustomerContext = $customerContext;
        return $this;
    }
    /**
     * Get TransactionIdentifierPlayback value
     * @return string|null
     */
    public function getTransactionIdentifierPlayback()
    {
        return $this->TransactionIdentifierPlayback;
    }
    /**
     * Set TransactionIdentifierPlayback value
     * @param string $transactionIdentifierPlayback
     * @return \Ups_track\UPStrackStruct\Ups_trackRequestTransactionReferenceType
     */
    public function setTransactionIdentifierPlayback($transactionIdentifierPlayback = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifierPlayback) && !is_string($transactionIdentifierPlayback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifierPlayback, true), gettype($transactionIdentifierPlayback)), __LINE__);
        }
        $this->TransactionIdentifierPlayback = $transactionIdentifierPlayback;
        return $this;
    }
}
