<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType UPStrackStruct
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackPackageType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The DeliveryIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryIndicator;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Redirect
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackRedirectType
     */
    public $Redirect;
    /**
     * The DeliveryDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[]
     */
    public $DeliveryDetail;
    /**
     * The PackageAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackPackageAddressType[]
     */
    public $PackageAddress;
    /**
     * The PackageServiceOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackServiceOptionType[]
     */
    public $PackageServiceOption;
    /**
     * The COD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackCODType
     */
    public $COD;
    /**
     * The SRSizeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SRSizeCode;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackActivityType[]
     */
    public $Activity;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackMessageType[]
     */
    public $Message;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackWeightType
     */
    public $PackageWeight;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType[]
     */
    public $ReferenceNumber;
    /**
     * The AlternateTrackingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AlternateTrackingNumber;
    /**
     * The AlternateTrackingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[]
     */
    public $AlternateTrackingInfo;
    /**
     * The DimensionalWeightScanIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DimensionalWeightScanIndicator;
    /**
     * The PreauthorizedReturnInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackPreauthorizedReturnInformationType
     */
    public $PreauthorizedReturnInformation;
    /**
     * Constructor method for PackageType
     * @uses Ups_trackPackageType::setTrackingNumber()
     * @uses Ups_trackPackageType::setDeliveryIndicator()
     * @uses Ups_trackPackageType::setDeliveryDate()
     * @uses Ups_trackPackageType::setRedirect()
     * @uses Ups_trackPackageType::setDeliveryDetail()
     * @uses Ups_trackPackageType::setPackageAddress()
     * @uses Ups_trackPackageType::setPackageServiceOption()
     * @uses Ups_trackPackageType::setCOD()
     * @uses Ups_trackPackageType::setSRSizeCode()
     * @uses Ups_trackPackageType::setActivity()
     * @uses Ups_trackPackageType::setMessage()
     * @uses Ups_trackPackageType::setPackageWeight()
     * @uses Ups_trackPackageType::setReferenceNumber()
     * @uses Ups_trackPackageType::setAlternateTrackingNumber()
     * @uses Ups_trackPackageType::setAlternateTrackingInfo()
     * @uses Ups_trackPackageType::setDimensionalWeightScanIndicator()
     * @uses Ups_trackPackageType::setPreauthorizedReturnInformation()
     * @param string $trackingNumber
     * @param string $deliveryIndicator
     * @param string $deliveryDate
     * @param \Ups_track\UPStrackStruct\Ups_trackRedirectType $redirect
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[] $deliveryDetail
     * @param \Ups_track\UPStrackStruct\Ups_trackPackageAddressType[] $packageAddress
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceOptionType[] $packageServiceOption
     * @param \Ups_track\UPStrackStruct\Ups_trackCODType $cOD
     * @param string $sRSizeCode
     * @param \Ups_track\UPStrackStruct\Ups_trackActivityType[] $activity
     * @param \Ups_track\UPStrackStruct\Ups_trackMessageType[] $message
     * @param \Ups_track\UPStrackStruct\Ups_trackWeightType $packageWeight
     * @param \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType[] $referenceNumber
     * @param string[] $alternateTrackingNumber
     * @param \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[] $alternateTrackingInfo
     * @param string $dimensionalWeightScanIndicator
     * @param \Ups_track\UPStrackStruct\Ups_trackPreauthorizedReturnInformationType $preauthorizedReturnInformation
     */
    public function __construct($trackingNumber = null, $deliveryIndicator = null, $deliveryDate = null, \Ups_track\UPStrackStruct\Ups_trackRedirectType $redirect = null, array $deliveryDetail = array(), array $packageAddress = array(), array $packageServiceOption = array(), \Ups_track\UPStrackStruct\Ups_trackCODType $cOD = null, $sRSizeCode = null, array $activity = array(), array $message = array(), \Ups_track\UPStrackStruct\Ups_trackWeightType $packageWeight = null, array $referenceNumber = array(), array $alternateTrackingNumber = array(), array $alternateTrackingInfo = array(), $dimensionalWeightScanIndicator = null, \Ups_track\UPStrackStruct\Ups_trackPreauthorizedReturnInformationType $preauthorizedReturnInformation = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setDeliveryIndicator($deliveryIndicator)
            ->setDeliveryDate($deliveryDate)
            ->setRedirect($redirect)
            ->setDeliveryDetail($deliveryDetail)
            ->setPackageAddress($packageAddress)
            ->setPackageServiceOption($packageServiceOption)
            ->setCOD($cOD)
            ->setSRSizeCode($sRSizeCode)
            ->setActivity($activity)
            ->setMessage($message)
            ->setPackageWeight($packageWeight)
            ->setReferenceNumber($referenceNumber)
            ->setAlternateTrackingNumber($alternateTrackingNumber)
            ->setAlternateTrackingInfo($alternateTrackingInfo)
            ->setDimensionalWeightScanIndicator($dimensionalWeightScanIndicator)
            ->setPreauthorizedReturnInformation($preauthorizedReturnInformation);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get DeliveryIndicator value
     * @return string|null
     */
    public function getDeliveryIndicator()
    {
        return $this->DeliveryIndicator;
    }
    /**
     * Set DeliveryIndicator value
     * @param string $deliveryIndicator
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setDeliveryIndicator($deliveryIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryIndicator) && !is_string($deliveryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryIndicator, true), gettype($deliveryIndicator)), __LINE__);
        }
        $this->DeliveryIndicator = $deliveryIndicator;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \Ups_track\UPStrackStruct\Ups_trackRedirectType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \Ups_track\UPStrackStruct\Ups_trackRedirectType $redirect
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setRedirect(\Ups_track\UPStrackStruct\Ups_trackRedirectType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get DeliveryDetail value
     * @return \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[]|null
     */
    public function getDeliveryDetail()
    {
        return $this->DeliveryDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryDetailForArrayConstraintsFromSetDeliveryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeDeliveryDetailItem) {
            // validation for constraint: itemType
            if (!$packageTypeDeliveryDetailItem instanceof \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType) {
                $invalidValues[] = is_object($packageTypeDeliveryDetailItem) ? get_class($packageTypeDeliveryDetailItem) : sprintf('%s(%s)', gettype($packageTypeDeliveryDetailItem), var_export($packageTypeDeliveryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryDetail property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[] $deliveryDetail
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setDeliveryDetail(array $deliveryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryDetailArrayErrorMessage = self::validateDeliveryDetailForArrayConstraintsFromSetDeliveryDetail($deliveryDetail))) {
            throw new \InvalidArgumentException($deliveryDetailArrayErrorMessage, __LINE__);
        }
        $this->DeliveryDetail = $deliveryDetail;
        return $this;
    }
    /**
     * Add item to DeliveryDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToDeliveryDetail(\Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryDetail property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryDetail[] = $item;
        return $this;
    }
    /**
     * Get PackageAddress value
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageAddressType[]|null
     */
    public function getPackageAddress()
    {
        return $this->PackageAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageAddressForArrayConstraintsFromSetPackageAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypePackageAddressItem) {
            // validation for constraint: itemType
            if (!$packageTypePackageAddressItem instanceof \Ups_track\UPStrackStruct\Ups_trackPackageAddressType) {
                $invalidValues[] = is_object($packageTypePackageAddressItem) ? get_class($packageTypePackageAddressItem) : sprintf('%s(%s)', gettype($packageTypePackageAddressItem), var_export($packageTypePackageAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageAddress property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackPackageAddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageAddress value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackPackageAddressType[] $packageAddress
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setPackageAddress(array $packageAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($packageAddressArrayErrorMessage = self::validatePackageAddressForArrayConstraintsFromSetPackageAddress($packageAddress))) {
            throw new \InvalidArgumentException($packageAddressArrayErrorMessage, __LINE__);
        }
        $this->PackageAddress = $packageAddress;
        return $this;
    }
    /**
     * Add item to PackageAddress value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackPackageAddressType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToPackageAddress(\Ups_track\UPStrackStruct\Ups_trackPackageAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackPackageAddressType) {
            throw new \InvalidArgumentException(sprintf('The PackageAddress property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackPackageAddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageAddress[] = $item;
        return $this;
    }
    /**
     * Get PackageServiceOption value
     * @return \Ups_track\UPStrackStruct\Ups_trackServiceOptionType[]|null
     */
    public function getPackageServiceOption()
    {
        return $this->PackageServiceOption;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageServiceOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageServiceOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageServiceOptionForArrayConstraintsFromSetPackageServiceOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypePackageServiceOptionItem) {
            // validation for constraint: itemType
            if (!$packageTypePackageServiceOptionItem instanceof \Ups_track\UPStrackStruct\Ups_trackServiceOptionType) {
                $invalidValues[] = is_object($packageTypePackageServiceOptionItem) ? get_class($packageTypePackageServiceOptionItem) : sprintf('%s(%s)', gettype($packageTypePackageServiceOptionItem), var_export($packageTypePackageServiceOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageServiceOption property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackServiceOptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageServiceOption value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceOptionType[] $packageServiceOption
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setPackageServiceOption(array $packageServiceOption = array())
    {
        // validation for constraint: array
        if ('' !== ($packageServiceOptionArrayErrorMessage = self::validatePackageServiceOptionForArrayConstraintsFromSetPackageServiceOption($packageServiceOption))) {
            throw new \InvalidArgumentException($packageServiceOptionArrayErrorMessage, __LINE__);
        }
        $this->PackageServiceOption = $packageServiceOption;
        return $this;
    }
    /**
     * Add item to PackageServiceOption value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceOptionType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToPackageServiceOption(\Ups_track\UPStrackStruct\Ups_trackServiceOptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackServiceOptionType) {
            throw new \InvalidArgumentException(sprintf('The PackageServiceOption property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackServiceOptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageServiceOption[] = $item;
        return $this;
    }
    /**
     * Get COD value
     * @return \Ups_track\UPStrackStruct\Ups_trackCODType|null
     */
    public function getCOD()
    {
        return $this->COD;
    }
    /**
     * Set COD value
     * @param \Ups_track\UPStrackStruct\Ups_trackCODType $cOD
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setCOD(\Ups_track\UPStrackStruct\Ups_trackCODType $cOD = null)
    {
        $this->COD = $cOD;
        return $this;
    }
    /**
     * Get SRSizeCode value
     * @return string|null
     */
    public function getSRSizeCode()
    {
        return $this->SRSizeCode;
    }
    /**
     * Set SRSizeCode value
     * @param string $sRSizeCode
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setSRSizeCode($sRSizeCode = null)
    {
        // validation for constraint: string
        if (!is_null($sRSizeCode) && !is_string($sRSizeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sRSizeCode, true), gettype($sRSizeCode)), __LINE__);
        }
        $this->SRSizeCode = $sRSizeCode;
        return $this;
    }
    /**
     * Get Activity value
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeActivityItem) {
            // validation for constraint: itemType
            if (!$packageTypeActivityItem instanceof \Ups_track\UPStrackStruct\Ups_trackActivityType) {
                $invalidValues[] = is_object($packageTypeActivityItem) ? get_class($packageTypeActivityItem) : sprintf('%s(%s)', gettype($packageTypeActivityItem), var_export($packageTypeActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackActivityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackActivityType[] $activity
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackActivityType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToActivity(\Ups_track\UPStrackStruct\Ups_trackActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackActivityType) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackActivityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return \Ups_track\UPStrackStruct\Ups_trackMessageType[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * This method is responsible for validating the values passed to the setMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageForArrayConstraintsFromSetMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeMessageItem) {
            // validation for constraint: itemType
            if (!$packageTypeMessageItem instanceof \Ups_track\UPStrackStruct\Ups_trackMessageType) {
                $invalidValues[] = is_object($packageTypeMessageItem) ? get_class($packageTypeMessageItem) : sprintf('%s(%s)', gettype($packageTypeMessageItem), var_export($packageTypeMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Message property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackMessageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackMessageType[] $message
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setMessage(array $message = array())
    {
        // validation for constraint: array
        if ('' !== ($messageArrayErrorMessage = self::validateMessageForArrayConstraintsFromSetMessage($message))) {
            throw new \InvalidArgumentException($messageArrayErrorMessage, __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackMessageType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToMessage(\Ups_track\UPStrackStruct\Ups_trackMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackMessageType) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackMessageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return \Ups_track\UPStrackStruct\Ups_trackWeightType|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param \Ups_track\UPStrackStruct\Ups_trackWeightType $packageWeight
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setPackageWeight(\Ups_track\UPStrackStruct\Ups_trackWeightType $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!$packageTypeReferenceNumberItem instanceof \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType) {
                $invalidValues[] = is_object($packageTypeReferenceNumberItem) ? get_class($packageTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($packageTypeReferenceNumberItem), var_export($packageTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType[] $referenceNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToReferenceNumber(\Ups_track\UPStrackStruct\Ups_trackReferenceNumberType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
    /**
     * Get AlternateTrackingNumber value
     * @return string[]|null
     */
    public function getAlternateTrackingNumber()
    {
        return $this->AlternateTrackingNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateTrackingNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateTrackingNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateTrackingNumberForArrayConstraintsFromSetAlternateTrackingNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeAlternateTrackingNumberItem) {
            // validation for constraint: itemType
            if (!is_string($packageTypeAlternateTrackingNumberItem)) {
                $invalidValues[] = is_object($packageTypeAlternateTrackingNumberItem) ? get_class($packageTypeAlternateTrackingNumberItem) : sprintf('%s(%s)', gettype($packageTypeAlternateTrackingNumberItem), var_export($packageTypeAlternateTrackingNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternateTrackingNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternateTrackingNumber value
     * @throws \InvalidArgumentException
     * @param string[] $alternateTrackingNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setAlternateTrackingNumber(array $alternateTrackingNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateTrackingNumberArrayErrorMessage = self::validateAlternateTrackingNumberForArrayConstraintsFromSetAlternateTrackingNumber($alternateTrackingNumber))) {
            throw new \InvalidArgumentException($alternateTrackingNumberArrayErrorMessage, __LINE__);
        }
        $this->AlternateTrackingNumber = $alternateTrackingNumber;
        return $this;
    }
    /**
     * Add item to AlternateTrackingNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToAlternateTrackingNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AlternateTrackingNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlternateTrackingNumber[] = $item;
        return $this;
    }
    /**
     * Get AlternateTrackingInfo value
     * @return \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[]|null
     */
    public function getAlternateTrackingInfo()
    {
        return $this->AlternateTrackingInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateTrackingInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateTrackingInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateTrackingInfoForArrayConstraintsFromSetAlternateTrackingInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeAlternateTrackingInfoItem) {
            // validation for constraint: itemType
            if (!$packageTypeAlternateTrackingInfoItem instanceof \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType) {
                $invalidValues[] = is_object($packageTypeAlternateTrackingInfoItem) ? get_class($packageTypeAlternateTrackingInfoItem) : sprintf('%s(%s)', gettype($packageTypeAlternateTrackingInfoItem), var_export($packageTypeAlternateTrackingInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternateTrackingInfo property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternateTrackingInfo value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[] $alternateTrackingInfo
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setAlternateTrackingInfo(array $alternateTrackingInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateTrackingInfoArrayErrorMessage = self::validateAlternateTrackingInfoForArrayConstraintsFromSetAlternateTrackingInfo($alternateTrackingInfo))) {
            throw new \InvalidArgumentException($alternateTrackingInfoArrayErrorMessage, __LINE__);
        }
        $this->AlternateTrackingInfo = $alternateTrackingInfo;
        return $this;
    }
    /**
     * Add item to AlternateTrackingInfo value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function addToAlternateTrackingInfo(\Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType) {
            throw new \InvalidArgumentException(sprintf('The AlternateTrackingInfo property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlternateTrackingInfo[] = $item;
        return $this;
    }
    /**
     * Get DimensionalWeightScanIndicator value
     * @return string|null
     */
    public function getDimensionalWeightScanIndicator()
    {
        return $this->DimensionalWeightScanIndicator;
    }
    /**
     * Set DimensionalWeightScanIndicator value
     * @param string $dimensionalWeightScanIndicator
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setDimensionalWeightScanIndicator($dimensionalWeightScanIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($dimensionalWeightScanIndicator) && !is_string($dimensionalWeightScanIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dimensionalWeightScanIndicator, true), gettype($dimensionalWeightScanIndicator)), __LINE__);
        }
        $this->DimensionalWeightScanIndicator = $dimensionalWeightScanIndicator;
        return $this;
    }
    /**
     * Get PreauthorizedReturnInformation value
     * @return \Ups_track\UPStrackStruct\Ups_trackPreauthorizedReturnInformationType|null
     */
    public function getPreauthorizedReturnInformation()
    {
        return $this->PreauthorizedReturnInformation;
    }
    /**
     * Set PreauthorizedReturnInformation value
     * @param \Ups_track\UPStrackStruct\Ups_trackPreauthorizedReturnInformationType $preauthorizedReturnInformation
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType
     */
    public function setPreauthorizedReturnInformation(\Ups_track\UPStrackStruct\Ups_trackPreauthorizedReturnInformationType $preauthorizedReturnInformation = null)
    {
        $this->PreauthorizedReturnInformation = $preauthorizedReturnInformation;
        return $this;
    }
}
