<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackRequest UPStrackStruct
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackTrackRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_track\UPStrackStruct\Ups_trackRequestType
     */
    public $Request;
    /**
     * The InquiryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InquiryNumber;
    /**
     * The IncludeMailInnovationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IncludeMailInnovationIndicator;
    /**
     * The TrackingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingOption;
    /**
     * The CandidateBookmark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CandidateBookmark;
    /**
     * The ReferenceNumber
     * @var \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType
     */
    public $ReferenceNumber;
    /**
     * The PickupDateRange
     * @var \Ups_track\UPStrackStruct\Ups_trackPickupDateRangeType
     */
    public $PickupDateRange;
    /**
     * The ShipperNumber
     * @var string
     */
    public $ShipperNumber;
    /**
     * The ShipFrom
     * @var \Ups_track\UPStrackStruct\Ups_trackShipFromRequestType
     */
    public $ShipFrom;
    /**
     * The ShipTo
     * @var \Ups_track\UPStrackStruct\Ups_trackShipToRequestType
     */
    public $ShipTo;
    /**
     * The ShipmentType
     * @var \Ups_track\UPStrackStruct\Ups_trackRefShipmentType
     */
    public $ShipmentType;
    /**
     * The ShipperAccountInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackShipperAccountInfoType
     */
    public $ShipperAccountInfo;
    /**
     * The PreauthorizedReturnIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreauthorizedReturnIndicator;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Locale;
    /**
     * Constructor method for TrackRequest
     * @uses Ups_trackTrackRequest::setRequest()
     * @uses Ups_trackTrackRequest::setInquiryNumber()
     * @uses Ups_trackTrackRequest::setIncludeMailInnovationIndicator()
     * @uses Ups_trackTrackRequest::setTrackingOption()
     * @uses Ups_trackTrackRequest::setCandidateBookmark()
     * @uses Ups_trackTrackRequest::setReferenceNumber()
     * @uses Ups_trackTrackRequest::setPickupDateRange()
     * @uses Ups_trackTrackRequest::setShipperNumber()
     * @uses Ups_trackTrackRequest::setShipFrom()
     * @uses Ups_trackTrackRequest::setShipTo()
     * @uses Ups_trackTrackRequest::setShipmentType()
     * @uses Ups_trackTrackRequest::setShipperAccountInfo()
     * @uses Ups_trackTrackRequest::setPreauthorizedReturnIndicator()
     * @uses Ups_trackTrackRequest::setLocale()
     * @param \Ups_track\UPStrackStruct\Ups_trackRequestType $request
     * @param string $inquiryNumber
     * @param string $includeMailInnovationIndicator
     * @param string $trackingOption
     * @param string $candidateBookmark
     * @param \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType $referenceNumber
     * @param \Ups_track\UPStrackStruct\Ups_trackPickupDateRangeType $pickupDateRange
     * @param string $shipperNumber
     * @param \Ups_track\UPStrackStruct\Ups_trackShipFromRequestType $shipFrom
     * @param \Ups_track\UPStrackStruct\Ups_trackShipToRequestType $shipTo
     * @param \Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType
     * @param \Ups_track\UPStrackStruct\Ups_trackShipperAccountInfoType $shipperAccountInfo
     * @param string $preauthorizedReturnIndicator
     * @param string $locale
     */
    public function __construct(\Ups_track\UPStrackStruct\Ups_trackRequestType $request = null, $inquiryNumber = null, $includeMailInnovationIndicator = null, $trackingOption = null, $candidateBookmark = null, \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType $referenceNumber = null, \Ups_track\UPStrackStruct\Ups_trackPickupDateRangeType $pickupDateRange = null, $shipperNumber = null, \Ups_track\UPStrackStruct\Ups_trackShipFromRequestType $shipFrom = null, \Ups_track\UPStrackStruct\Ups_trackShipToRequestType $shipTo = null, \Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType = null, \Ups_track\UPStrackStruct\Ups_trackShipperAccountInfoType $shipperAccountInfo = null, $preauthorizedReturnIndicator = null, $locale = null)
    {
        $this
            ->setRequest($request)
            ->setInquiryNumber($inquiryNumber)
            ->setIncludeMailInnovationIndicator($includeMailInnovationIndicator)
            ->setTrackingOption($trackingOption)
            ->setCandidateBookmark($candidateBookmark)
            ->setReferenceNumber($referenceNumber)
            ->setPickupDateRange($pickupDateRange)
            ->setShipperNumber($shipperNumber)
            ->setShipFrom($shipFrom)
            ->setShipTo($shipTo)
            ->setShipmentType($shipmentType)
            ->setShipperAccountInfo($shipperAccountInfo)
            ->setPreauthorizedReturnIndicator($preauthorizedReturnIndicator)
            ->setLocale($locale);
    }
    /**
     * Get Request value
     * @return \Ups_track\UPStrackStruct\Ups_trackRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_track\UPStrackStruct\Ups_trackRequestType $request
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setRequest(\Ups_track\UPStrackStruct\Ups_trackRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get InquiryNumber value
     * @return string|null
     */
    public function getInquiryNumber()
    {
        return $this->InquiryNumber;
    }
    /**
     * Set InquiryNumber value
     * @param string $inquiryNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setInquiryNumber($inquiryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($inquiryNumber) && !is_string($inquiryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inquiryNumber, true), gettype($inquiryNumber)), __LINE__);
        }
        $this->InquiryNumber = $inquiryNumber;
        return $this;
    }
    /**
     * Get IncludeMailInnovationIndicator value
     * @return string|null
     */
    public function getIncludeMailInnovationIndicator()
    {
        return $this->IncludeMailInnovationIndicator;
    }
    /**
     * Set IncludeMailInnovationIndicator value
     * @param string $includeMailInnovationIndicator
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setIncludeMailInnovationIndicator($includeMailInnovationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($includeMailInnovationIndicator) && !is_string($includeMailInnovationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includeMailInnovationIndicator, true), gettype($includeMailInnovationIndicator)), __LINE__);
        }
        $this->IncludeMailInnovationIndicator = $includeMailInnovationIndicator;
        return $this;
    }
    /**
     * Get TrackingOption value
     * @return string|null
     */
    public function getTrackingOption()
    {
        return $this->TrackingOption;
    }
    /**
     * Set TrackingOption value
     * @param string $trackingOption
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setTrackingOption($trackingOption = null)
    {
        // validation for constraint: string
        if (!is_null($trackingOption) && !is_string($trackingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingOption, true), gettype($trackingOption)), __LINE__);
        }
        $this->TrackingOption = $trackingOption;
        return $this;
    }
    /**
     * Get CandidateBookmark value
     * @return string|null
     */
    public function getCandidateBookmark()
    {
        return $this->CandidateBookmark;
    }
    /**
     * Set CandidateBookmark value
     * @param string $candidateBookmark
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setCandidateBookmark($candidateBookmark = null)
    {
        // validation for constraint: string
        if (!is_null($candidateBookmark) && !is_string($candidateBookmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidateBookmark, true), gettype($candidateBookmark)), __LINE__);
        }
        $this->CandidateBookmark = $candidateBookmark;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param \Ups_track\UPStrackStruct\Ups_trackReferenceNumberType $referenceNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setReferenceNumber(\Ups_track\UPStrackStruct\Ups_trackReferenceNumberType $referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get PickupDateRange value
     * @return \Ups_track\UPStrackStruct\Ups_trackPickupDateRangeType|null
     */
    public function getPickupDateRange()
    {
        return $this->PickupDateRange;
    }
    /**
     * Set PickupDateRange value
     * @param \Ups_track\UPStrackStruct\Ups_trackPickupDateRangeType $pickupDateRange
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setPickupDateRange(\Ups_track\UPStrackStruct\Ups_trackPickupDateRangeType $pickupDateRange = null)
    {
        $this->PickupDateRange = $pickupDateRange;
        return $this;
    }
    /**
     * Get ShipperNumber value
     * @return string|null
     */
    public function getShipperNumber()
    {
        return $this->ShipperNumber;
    }
    /**
     * Set ShipperNumber value
     * @param string $shipperNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setShipperNumber($shipperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperNumber) && !is_string($shipperNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperNumber, true), gettype($shipperNumber)), __LINE__);
        }
        $this->ShipperNumber = $shipperNumber;
        return $this;
    }
    /**
     * Get ShipFrom value
     * @return \Ups_track\UPStrackStruct\Ups_trackShipFromRequestType|null
     */
    public function getShipFrom()
    {
        return $this->ShipFrom;
    }
    /**
     * Set ShipFrom value
     * @param \Ups_track\UPStrackStruct\Ups_trackShipFromRequestType $shipFrom
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setShipFrom(\Ups_track\UPStrackStruct\Ups_trackShipFromRequestType $shipFrom = null)
    {
        $this->ShipFrom = $shipFrom;
        return $this;
    }
    /**
     * Get ShipTo value
     * @return \Ups_track\UPStrackStruct\Ups_trackShipToRequestType|null
     */
    public function getShipTo()
    {
        return $this->ShipTo;
    }
    /**
     * Set ShipTo value
     * @param \Ups_track\UPStrackStruct\Ups_trackShipToRequestType $shipTo
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setShipTo(\Ups_track\UPStrackStruct\Ups_trackShipToRequestType $shipTo = null)
    {
        $this->ShipTo = $shipTo;
        return $this;
    }
    /**
     * Get ShipmentType value
     * @return \Ups_track\UPStrackStruct\Ups_trackRefShipmentType|null
     */
    public function getShipmentType()
    {
        return $this->ShipmentType;
    }
    /**
     * Set ShipmentType value
     * @param \Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setShipmentType(\Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType = null)
    {
        $this->ShipmentType = $shipmentType;
        return $this;
    }
    /**
     * Get ShipperAccountInfo value
     * @return \Ups_track\UPStrackStruct\Ups_trackShipperAccountInfoType|null
     */
    public function getShipperAccountInfo()
    {
        return $this->ShipperAccountInfo;
    }
    /**
     * Set ShipperAccountInfo value
     * @param \Ups_track\UPStrackStruct\Ups_trackShipperAccountInfoType $shipperAccountInfo
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setShipperAccountInfo(\Ups_track\UPStrackStruct\Ups_trackShipperAccountInfoType $shipperAccountInfo = null)
    {
        $this->ShipperAccountInfo = $shipperAccountInfo;
        return $this;
    }
    /**
     * Get PreauthorizedReturnIndicator value
     * @return string|null
     */
    public function getPreauthorizedReturnIndicator()
    {
        return $this->PreauthorizedReturnIndicator;
    }
    /**
     * Set PreauthorizedReturnIndicator value
     * @param string $preauthorizedReturnIndicator
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setPreauthorizedReturnIndicator($preauthorizedReturnIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($preauthorizedReturnIndicator) && !is_string($preauthorizedReturnIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preauthorizedReturnIndicator, true), gettype($preauthorizedReturnIndicator)), __LINE__);
        }
        $this->PreauthorizedReturnIndicator = $preauthorizedReturnIndicator;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackRequest
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
}
