<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackResponse UPStrackStruct
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackTrackResponse extends AbstractStructBase
{
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - ref: common:Response
     * @var \Ups_track\UPStrackStruct\Ups_trackResponseType
     */
    public $Response;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups_track\UPStrackStruct\Ups_trackShipmentType[]
     */
    public $Shipment;
    /**
     * The Disclaimer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Disclaimer;
    /**
     * Constructor method for TrackResponse
     * @uses Ups_trackTrackResponse::setResponse()
     * @uses Ups_trackTrackResponse::setShipment()
     * @uses Ups_trackTrackResponse::setDisclaimer()
     * @param \Ups_track\UPStrackStruct\Ups_trackResponseType $response
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentType[] $shipment
     * @param string[] $disclaimer
     */
    public function __construct(\Ups_track\UPStrackStruct\Ups_trackResponseType $response = null, array $shipment = array(), array $disclaimer = array())
    {
        $this
            ->setResponse($response)
            ->setShipment($shipment)
            ->setDisclaimer($disclaimer);
    }
    /**
     * Get Response value
     * @return \Ups_track\UPStrackStruct\Ups_trackResponseType|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \Ups_track\UPStrackStruct\Ups_trackResponseType $response
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackResponse
     */
    public function setResponse(\Ups_track\UPStrackStruct\Ups_trackResponseType $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType[]|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * This method is responsible for validating the values passed to the setShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentForArrayConstraintsFromSetShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackResponseShipmentItem) {
            // validation for constraint: itemType
            if (!$trackResponseShipmentItem instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentType) {
                $invalidValues[] = is_object($trackResponseShipmentItem) ? get_class($trackResponseShipmentItem) : sprintf('%s(%s)', gettype($trackResponseShipmentItem), var_export($trackResponseShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Shipment property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Shipment value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentType[] $shipment
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackResponse
     */
    public function setShipment(array $shipment = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentArrayErrorMessage = self::validateShipmentForArrayConstraintsFromSetShipment($shipment))) {
            throw new \InvalidArgumentException($shipmentArrayErrorMessage, __LINE__);
        }
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Add item to Shipment value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackResponse
     */
    public function addToShipment(\Ups_track\UPStrackStruct\Ups_trackShipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentType) {
            throw new \InvalidArgumentException(sprintf('The Shipment property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Shipment[] = $item;
        return $this;
    }
    /**
     * Get Disclaimer value
     * @return string[]|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclaimer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclaimer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclaimerForArrayConstraintsFromSetDisclaimer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trackResponseDisclaimerItem) {
            // validation for constraint: itemType
            if (!is_string($trackResponseDisclaimerItem)) {
                $invalidValues[] = is_object($trackResponseDisclaimerItem) ? get_class($trackResponseDisclaimerItem) : sprintf('%s(%s)', gettype($trackResponseDisclaimerItem), var_export($trackResponseDisclaimerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disclaimer property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disclaimer value
     * @throws \InvalidArgumentException
     * @param string[] $disclaimer
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackResponse
     */
    public function setDisclaimer(array $disclaimer = array())
    {
        // validation for constraint: array
        if ('' !== ($disclaimerArrayErrorMessage = self::validateDisclaimerForArrayConstraintsFromSetDisclaimer($disclaimer))) {
            throw new \InvalidArgumentException($disclaimerArrayErrorMessage, __LINE__);
        }
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Add item to Disclaimer value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackResponse
     */
    public function addToDisclaimer($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Disclaimer property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disclaimer[] = $item;
        return $this;
    }
}
