<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType UPStrackStruct
 * Meta information extracted from the WSDL
 * - minOccurs: 0
 * - type: trk:RefShipmentType
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackShipmentType extends AbstractStructBase
{
    /**
     * The InquiryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionValueType
     */
    public $InquiryNumber;
    /**
     * The ShipmentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackRefShipmentType
     */
    public $ShipmentType;
    /**
     * The CandidateBookmark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CandidateBookmark;
    /**
     * The ShipperNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperNumber;
    /**
     * The ShipmentAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType[]
     */
    public $ShipmentAddress;
    /**
     * The ShipmentWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackWeightType
     */
    public $ShipmentWeight;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackServiceType
     */
    public $Service;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType[]
     */
    public $ReferenceNumber;
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackCommonCodeDescriptionType
     */
    public $CurrentStatus;
    /**
     * The PickupDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PickupDate;
    /**
     * The ServiceCenter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackServiceCenterType[]
     */
    public $ServiceCenter;
    /**
     * The DeliveryDateUnavailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDeliveryDateUnavailableType
     */
    public $DeliveryDateUnavailable;
    /**
     * The DeliveryDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[]
     */
    public $DeliveryDetail;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackVolumeType
     */
    public $Volume;
    /**
     * The BillToName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BillToName;
    /**
     * The NumberOfPackagingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType[]
     */
    public $NumberOfPackagingUnit;
    /**
     * The COD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackCODType
     */
    public $COD;
    /**
     * The SignedForByName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SignedForByName;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType[]
     */
    public $Activity;
    /**
     * The OriginPortDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackOriginPortDetailType
     */
    public $OriginPortDetail;
    /**
     * The DestinationPortDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDestinationPortDetailType
     */
    public $DestinationPortDetail;
    /**
     * The DescriptionOfGoods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionOfGoods;
    /**
     * The CargoReady
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDateTimeType
     */
    public $CargoReady;
    /**
     * The Manifest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDateTimeType
     */
    public $Manifest;
    /**
     * The CarrierActivityInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType[]
     */
    public $CarrierActivityInformation;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDocumentType[]
     */
    public $Document;
    /**
     * The FileNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FileNumber;
    /**
     * The Appointment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackAppointmentType
     */
    public $Appointment;
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackPackageType[]
     */
    public $Package;
    /**
     * The AdditionalAttribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[]
     */
    public $AdditionalAttribute;
    /**
     * Constructor method for ShipmentType
     * @uses Ups_trackShipmentType::setInquiryNumber()
     * @uses Ups_trackShipmentType::setShipmentType()
     * @uses Ups_trackShipmentType::setCandidateBookmark()
     * @uses Ups_trackShipmentType::setShipperNumber()
     * @uses Ups_trackShipmentType::setShipmentAddress()
     * @uses Ups_trackShipmentType::setShipmentWeight()
     * @uses Ups_trackShipmentType::setService()
     * @uses Ups_trackShipmentType::setReferenceNumber()
     * @uses Ups_trackShipmentType::setCurrentStatus()
     * @uses Ups_trackShipmentType::setPickupDate()
     * @uses Ups_trackShipmentType::setServiceCenter()
     * @uses Ups_trackShipmentType::setDeliveryDateUnavailable()
     * @uses Ups_trackShipmentType::setDeliveryDetail()
     * @uses Ups_trackShipmentType::setVolume()
     * @uses Ups_trackShipmentType::setBillToName()
     * @uses Ups_trackShipmentType::setNumberOfPackagingUnit()
     * @uses Ups_trackShipmentType::setCOD()
     * @uses Ups_trackShipmentType::setSignedForByName()
     * @uses Ups_trackShipmentType::setActivity()
     * @uses Ups_trackShipmentType::setOriginPortDetail()
     * @uses Ups_trackShipmentType::setDestinationPortDetail()
     * @uses Ups_trackShipmentType::setDescriptionOfGoods()
     * @uses Ups_trackShipmentType::setCargoReady()
     * @uses Ups_trackShipmentType::setManifest()
     * @uses Ups_trackShipmentType::setCarrierActivityInformation()
     * @uses Ups_trackShipmentType::setDocument()
     * @uses Ups_trackShipmentType::setFileNumber()
     * @uses Ups_trackShipmentType::setAppointment()
     * @uses Ups_trackShipmentType::setPackage()
     * @uses Ups_trackShipmentType::setAdditionalAttribute()
     * @param \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionValueType $inquiryNumber
     * @param \Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType
     * @param string $candidateBookmark
     * @param string $shipperNumber
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType[] $shipmentAddress
     * @param \Ups_track\UPStrackStruct\Ups_trackWeightType $shipmentWeight
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceType $service
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType[] $referenceNumber
     * @param \Ups_track\UPStrackStruct\Ups_trackCommonCodeDescriptionType $currentStatus
     * @param string $pickupDate
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceCenterType[] $serviceCenter
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDateUnavailableType $deliveryDateUnavailable
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[] $deliveryDetail
     * @param \Ups_track\UPStrackStruct\Ups_trackVolumeType $volume
     * @param string $billToName
     * @param \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType[] $numberOfPackagingUnit
     * @param \Ups_track\UPStrackStruct\Ups_trackCODType $cOD
     * @param string $signedForByName
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType[] $activity
     * @param \Ups_track\UPStrackStruct\Ups_trackOriginPortDetailType $originPortDetail
     * @param \Ups_track\UPStrackStruct\Ups_trackDestinationPortDetailType $destinationPortDetail
     * @param string $descriptionOfGoods
     * @param \Ups_track\UPStrackStruct\Ups_trackDateTimeType $cargoReady
     * @param \Ups_track\UPStrackStruct\Ups_trackDateTimeType $manifest
     * @param \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType[] $carrierActivityInformation
     * @param \Ups_track\UPStrackStruct\Ups_trackDocumentType[] $document
     * @param string $fileNumber
     * @param \Ups_track\UPStrackStruct\Ups_trackAppointmentType $appointment
     * @param \Ups_track\UPStrackStruct\Ups_trackPackageType[] $package
     * @param \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[] $additionalAttribute
     */
    public function __construct(\Ups_track\UPStrackStruct\Ups_trackCodeDescriptionValueType $inquiryNumber = null, \Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType = null, $candidateBookmark = null, $shipperNumber = null, array $shipmentAddress = array(), \Ups_track\UPStrackStruct\Ups_trackWeightType $shipmentWeight = null, \Ups_track\UPStrackStruct\Ups_trackServiceType $service = null, array $referenceNumber = array(), \Ups_track\UPStrackStruct\Ups_trackCommonCodeDescriptionType $currentStatus = null, $pickupDate = null, array $serviceCenter = array(), \Ups_track\UPStrackStruct\Ups_trackDeliveryDateUnavailableType $deliveryDateUnavailable = null, array $deliveryDetail = array(), \Ups_track\UPStrackStruct\Ups_trackVolumeType $volume = null, $billToName = null, array $numberOfPackagingUnit = array(), \Ups_track\UPStrackStruct\Ups_trackCODType $cOD = null, $signedForByName = null, array $activity = array(), \Ups_track\UPStrackStruct\Ups_trackOriginPortDetailType $originPortDetail = null, \Ups_track\UPStrackStruct\Ups_trackDestinationPortDetailType $destinationPortDetail = null, $descriptionOfGoods = null, \Ups_track\UPStrackStruct\Ups_trackDateTimeType $cargoReady = null, \Ups_track\UPStrackStruct\Ups_trackDateTimeType $manifest = null, array $carrierActivityInformation = array(), array $document = array(), $fileNumber = null, \Ups_track\UPStrackStruct\Ups_trackAppointmentType $appointment = null, array $package = array(), array $additionalAttribute = array())
    {
        $this
            ->setInquiryNumber($inquiryNumber)
            ->setShipmentType($shipmentType)
            ->setCandidateBookmark($candidateBookmark)
            ->setShipperNumber($shipperNumber)
            ->setShipmentAddress($shipmentAddress)
            ->setShipmentWeight($shipmentWeight)
            ->setService($service)
            ->setReferenceNumber($referenceNumber)
            ->setCurrentStatus($currentStatus)
            ->setPickupDate($pickupDate)
            ->setServiceCenter($serviceCenter)
            ->setDeliveryDateUnavailable($deliveryDateUnavailable)
            ->setDeliveryDetail($deliveryDetail)
            ->setVolume($volume)
            ->setBillToName($billToName)
            ->setNumberOfPackagingUnit($numberOfPackagingUnit)
            ->setCOD($cOD)
            ->setSignedForByName($signedForByName)
            ->setActivity($activity)
            ->setOriginPortDetail($originPortDetail)
            ->setDestinationPortDetail($destinationPortDetail)
            ->setDescriptionOfGoods($descriptionOfGoods)
            ->setCargoReady($cargoReady)
            ->setManifest($manifest)
            ->setCarrierActivityInformation($carrierActivityInformation)
            ->setDocument($document)
            ->setFileNumber($fileNumber)
            ->setAppointment($appointment)
            ->setPackage($package)
            ->setAdditionalAttribute($additionalAttribute);
    }
    /**
     * Get InquiryNumber value
     * @return \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionValueType|null
     */
    public function getInquiryNumber()
    {
        return $this->InquiryNumber;
    }
    /**
     * Set InquiryNumber value
     * @param \Ups_track\UPStrackStruct\Ups_trackCodeDescriptionValueType $inquiryNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setInquiryNumber(\Ups_track\UPStrackStruct\Ups_trackCodeDescriptionValueType $inquiryNumber = null)
    {
        $this->InquiryNumber = $inquiryNumber;
        return $this;
    }
    /**
     * Get ShipmentType value
     * @return \Ups_track\UPStrackStruct\Ups_trackRefShipmentType|null
     */
    public function getShipmentType()
    {
        return $this->ShipmentType;
    }
    /**
     * Set ShipmentType value
     * @param \Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setShipmentType(\Ups_track\UPStrackStruct\Ups_trackRefShipmentType $shipmentType = null)
    {
        $this->ShipmentType = $shipmentType;
        return $this;
    }
    /**
     * Get CandidateBookmark value
     * @return string|null
     */
    public function getCandidateBookmark()
    {
        return $this->CandidateBookmark;
    }
    /**
     * Set CandidateBookmark value
     * @param string $candidateBookmark
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setCandidateBookmark($candidateBookmark = null)
    {
        // validation for constraint: string
        if (!is_null($candidateBookmark) && !is_string($candidateBookmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidateBookmark, true), gettype($candidateBookmark)), __LINE__);
        }
        $this->CandidateBookmark = $candidateBookmark;
        return $this;
    }
    /**
     * Get ShipperNumber value
     * @return string|null
     */
    public function getShipperNumber()
    {
        return $this->ShipperNumber;
    }
    /**
     * Set ShipperNumber value
     * @param string $shipperNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setShipperNumber($shipperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperNumber) && !is_string($shipperNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperNumber, true), gettype($shipperNumber)), __LINE__);
        }
        $this->ShipperNumber = $shipperNumber;
        return $this;
    }
    /**
     * Get ShipmentAddress value
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType[]|null
     */
    public function getShipmentAddress()
    {
        return $this->ShipmentAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentAddressForArrayConstraintsFromSetShipmentAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentAddressItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentAddressItem instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType) {
                $invalidValues[] = is_object($shipmentTypeShipmentAddressItem) ? get_class($shipmentTypeShipmentAddressItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentAddressItem), var_export($shipmentTypeShipmentAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentAddress property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentAddress value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType[] $shipmentAddress
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setShipmentAddress(array $shipmentAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentAddressArrayErrorMessage = self::validateShipmentAddressForArrayConstraintsFromSetShipmentAddress($shipmentAddress))) {
            throw new \InvalidArgumentException($shipmentAddressArrayErrorMessage, __LINE__);
        }
        $this->ShipmentAddress = $shipmentAddress;
        return $this;
    }
    /**
     * Add item to ShipmentAddress value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToShipmentAddress(\Ups_track\UPStrackStruct\Ups_trackShipmentAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentAddress property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentAddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentAddress[] = $item;
        return $this;
    }
    /**
     * Get ShipmentWeight value
     * @return \Ups_track\UPStrackStruct\Ups_trackWeightType|null
     */
    public function getShipmentWeight()
    {
        return $this->ShipmentWeight;
    }
    /**
     * Set ShipmentWeight value
     * @param \Ups_track\UPStrackStruct\Ups_trackWeightType $shipmentWeight
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setShipmentWeight(\Ups_track\UPStrackStruct\Ups_trackWeightType $shipmentWeight = null)
    {
        $this->ShipmentWeight = $shipmentWeight;
        return $this;
    }
    /**
     * Get Service value
     * @return \Ups_track\UPStrackStruct\Ups_trackServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceType $service
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setService(\Ups_track\UPStrackStruct\Ups_trackServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeReferenceNumberItem instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType) {
                $invalidValues[] = is_object($shipmentTypeReferenceNumberItem) ? get_class($shipmentTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($shipmentTypeReferenceNumberItem), var_export($shipmentTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType[] $referenceNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToReferenceNumber(\Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentReferenceNumberType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
    /**
     * Get CurrentStatus value
     * @return \Ups_track\UPStrackStruct\Ups_trackCommonCodeDescriptionType|null
     */
    public function getCurrentStatus()
    {
        return $this->CurrentStatus;
    }
    /**
     * Set CurrentStatus value
     * @param \Ups_track\UPStrackStruct\Ups_trackCommonCodeDescriptionType $currentStatus
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setCurrentStatus(\Ups_track\UPStrackStruct\Ups_trackCommonCodeDescriptionType $currentStatus = null)
    {
        $this->CurrentStatus = $currentStatus;
        return $this;
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get ServiceCenter value
     * @return \Ups_track\UPStrackStruct\Ups_trackServiceCenterType[]|null
     */
    public function getServiceCenter()
    {
        return $this->ServiceCenter;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCenter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCenter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCenterForArrayConstraintsFromSetServiceCenter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeServiceCenterItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeServiceCenterItem instanceof \Ups_track\UPStrackStruct\Ups_trackServiceCenterType) {
                $invalidValues[] = is_object($shipmentTypeServiceCenterItem) ? get_class($shipmentTypeServiceCenterItem) : sprintf('%s(%s)', gettype($shipmentTypeServiceCenterItem), var_export($shipmentTypeServiceCenterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCenter property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackServiceCenterType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCenter value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceCenterType[] $serviceCenter
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setServiceCenter(array $serviceCenter = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCenterArrayErrorMessage = self::validateServiceCenterForArrayConstraintsFromSetServiceCenter($serviceCenter))) {
            throw new \InvalidArgumentException($serviceCenterArrayErrorMessage, __LINE__);
        }
        $this->ServiceCenter = $serviceCenter;
        return $this;
    }
    /**
     * Add item to ServiceCenter value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackServiceCenterType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToServiceCenter(\Ups_track\UPStrackStruct\Ups_trackServiceCenterType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackServiceCenterType) {
            throw new \InvalidArgumentException(sprintf('The ServiceCenter property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackServiceCenterType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCenter[] = $item;
        return $this;
    }
    /**
     * Get DeliveryDateUnavailable value
     * @return \Ups_track\UPStrackStruct\Ups_trackDeliveryDateUnavailableType|null
     */
    public function getDeliveryDateUnavailable()
    {
        return $this->DeliveryDateUnavailable;
    }
    /**
     * Set DeliveryDateUnavailable value
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDateUnavailableType $deliveryDateUnavailable
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setDeliveryDateUnavailable(\Ups_track\UPStrackStruct\Ups_trackDeliveryDateUnavailableType $deliveryDateUnavailable = null)
    {
        $this->DeliveryDateUnavailable = $deliveryDateUnavailable;
        return $this;
    }
    /**
     * Get DeliveryDetail value
     * @return \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[]|null
     */
    public function getDeliveryDetail()
    {
        return $this->DeliveryDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryDetailForArrayConstraintsFromSetDeliveryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeDeliveryDetailItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeDeliveryDetailItem instanceof \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType) {
                $invalidValues[] = is_object($shipmentTypeDeliveryDetailItem) ? get_class($shipmentTypeDeliveryDetailItem) : sprintf('%s(%s)', gettype($shipmentTypeDeliveryDetailItem), var_export($shipmentTypeDeliveryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryDetail property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType[] $deliveryDetail
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setDeliveryDetail(array $deliveryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryDetailArrayErrorMessage = self::validateDeliveryDetailForArrayConstraintsFromSetDeliveryDetail($deliveryDetail))) {
            throw new \InvalidArgumentException($deliveryDetailArrayErrorMessage, __LINE__);
        }
        $this->DeliveryDetail = $deliveryDetail;
        return $this;
    }
    /**
     * Add item to DeliveryDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToDeliveryDetail(\Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryDetail property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDeliveryDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryDetail[] = $item;
        return $this;
    }
    /**
     * Get Volume value
     * @return \Ups_track\UPStrackStruct\Ups_trackVolumeType|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param \Ups_track\UPStrackStruct\Ups_trackVolumeType $volume
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setVolume(\Ups_track\UPStrackStruct\Ups_trackVolumeType $volume = null)
    {
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get BillToName value
     * @return string|null
     */
    public function getBillToName()
    {
        return $this->BillToName;
    }
    /**
     * Set BillToName value
     * @param string $billToName
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setBillToName($billToName = null)
    {
        // validation for constraint: string
        if (!is_null($billToName) && !is_string($billToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billToName, true), gettype($billToName)), __LINE__);
        }
        $this->BillToName = $billToName;
        return $this;
    }
    /**
     * Get NumberOfPackagingUnit value
     * @return \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType[]|null
     */
    public function getNumberOfPackagingUnit()
    {
        return $this->NumberOfPackagingUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setNumberOfPackagingUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumberOfPackagingUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberOfPackagingUnitForArrayConstraintsFromSetNumberOfPackagingUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeNumberOfPackagingUnitItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeNumberOfPackagingUnitItem instanceof \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType) {
                $invalidValues[] = is_object($shipmentTypeNumberOfPackagingUnitItem) ? get_class($shipmentTypeNumberOfPackagingUnitItem) : sprintf('%s(%s)', gettype($shipmentTypeNumberOfPackagingUnitItem), var_export($shipmentTypeNumberOfPackagingUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NumberOfPackagingUnit property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NumberOfPackagingUnit value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType[] $numberOfPackagingUnit
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setNumberOfPackagingUnit(array $numberOfPackagingUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($numberOfPackagingUnitArrayErrorMessage = self::validateNumberOfPackagingUnitForArrayConstraintsFromSetNumberOfPackagingUnit($numberOfPackagingUnit))) {
            throw new \InvalidArgumentException($numberOfPackagingUnitArrayErrorMessage, __LINE__);
        }
        $this->NumberOfPackagingUnit = $numberOfPackagingUnit;
        return $this;
    }
    /**
     * Add item to NumberOfPackagingUnit value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToNumberOfPackagingUnit(\Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType) {
            throw new \InvalidArgumentException(sprintf('The NumberOfPackagingUnit property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackNumberOfPackagingUnitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NumberOfPackagingUnit[] = $item;
        return $this;
    }
    /**
     * Get COD value
     * @return \Ups_track\UPStrackStruct\Ups_trackCODType|null
     */
    public function getCOD()
    {
        return $this->COD;
    }
    /**
     * Set COD value
     * @param \Ups_track\UPStrackStruct\Ups_trackCODType $cOD
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setCOD(\Ups_track\UPStrackStruct\Ups_trackCODType $cOD = null)
    {
        $this->COD = $cOD;
        return $this;
    }
    /**
     * Get SignedForByName value
     * @return string|null
     */
    public function getSignedForByName()
    {
        return $this->SignedForByName;
    }
    /**
     * Set SignedForByName value
     * @param string $signedForByName
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setSignedForByName($signedForByName = null)
    {
        // validation for constraint: string
        if (!is_null($signedForByName) && !is_string($signedForByName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signedForByName, true), gettype($signedForByName)), __LINE__);
        }
        $this->SignedForByName = $signedForByName;
        return $this;
    }
    /**
     * Get Activity value
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeActivityItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeActivityItem instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType) {
                $invalidValues[] = is_object($shipmentTypeActivityItem) ? get_class($shipmentTypeActivityItem) : sprintf('%s(%s)', gettype($shipmentTypeActivityItem), var_export($shipmentTypeActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType[] $activity
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToActivity(\Ups_track\UPStrackStruct\Ups_trackShipmentActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackShipmentActivityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Get OriginPortDetail value
     * @return \Ups_track\UPStrackStruct\Ups_trackOriginPortDetailType|null
     */
    public function getOriginPortDetail()
    {
        return $this->OriginPortDetail;
    }
    /**
     * Set OriginPortDetail value
     * @param \Ups_track\UPStrackStruct\Ups_trackOriginPortDetailType $originPortDetail
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setOriginPortDetail(\Ups_track\UPStrackStruct\Ups_trackOriginPortDetailType $originPortDetail = null)
    {
        $this->OriginPortDetail = $originPortDetail;
        return $this;
    }
    /**
     * Get DestinationPortDetail value
     * @return \Ups_track\UPStrackStruct\Ups_trackDestinationPortDetailType|null
     */
    public function getDestinationPortDetail()
    {
        return $this->DestinationPortDetail;
    }
    /**
     * Set DestinationPortDetail value
     * @param \Ups_track\UPStrackStruct\Ups_trackDestinationPortDetailType $destinationPortDetail
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setDestinationPortDetail(\Ups_track\UPStrackStruct\Ups_trackDestinationPortDetailType $destinationPortDetail = null)
    {
        $this->DestinationPortDetail = $destinationPortDetail;
        return $this;
    }
    /**
     * Get DescriptionOfGoods value
     * @return string|null
     */
    public function getDescriptionOfGoods()
    {
        return $this->DescriptionOfGoods;
    }
    /**
     * Set DescriptionOfGoods value
     * @param string $descriptionOfGoods
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setDescriptionOfGoods($descriptionOfGoods = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionOfGoods) && !is_string($descriptionOfGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionOfGoods, true), gettype($descriptionOfGoods)), __LINE__);
        }
        $this->DescriptionOfGoods = $descriptionOfGoods;
        return $this;
    }
    /**
     * Get CargoReady value
     * @return \Ups_track\UPStrackStruct\Ups_trackDateTimeType|null
     */
    public function getCargoReady()
    {
        return $this->CargoReady;
    }
    /**
     * Set CargoReady value
     * @param \Ups_track\UPStrackStruct\Ups_trackDateTimeType $cargoReady
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setCargoReady(\Ups_track\UPStrackStruct\Ups_trackDateTimeType $cargoReady = null)
    {
        $this->CargoReady = $cargoReady;
        return $this;
    }
    /**
     * Get Manifest value
     * @return \Ups_track\UPStrackStruct\Ups_trackDateTimeType|null
     */
    public function getManifest()
    {
        return $this->Manifest;
    }
    /**
     * Set Manifest value
     * @param \Ups_track\UPStrackStruct\Ups_trackDateTimeType $manifest
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setManifest(\Ups_track\UPStrackStruct\Ups_trackDateTimeType $manifest = null)
    {
        $this->Manifest = $manifest;
        return $this;
    }
    /**
     * Get CarrierActivityInformation value
     * @return \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType[]|null
     */
    public function getCarrierActivityInformation()
    {
        return $this->CarrierActivityInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierActivityInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierActivityInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierActivityInformationForArrayConstraintsFromSetCarrierActivityInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeCarrierActivityInformationItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeCarrierActivityInformationItem instanceof \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType) {
                $invalidValues[] = is_object($shipmentTypeCarrierActivityInformationItem) ? get_class($shipmentTypeCarrierActivityInformationItem) : sprintf('%s(%s)', gettype($shipmentTypeCarrierActivityInformationItem), var_export($shipmentTypeCarrierActivityInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierActivityInformation property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierActivityInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType[] $carrierActivityInformation
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setCarrierActivityInformation(array $carrierActivityInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierActivityInformationArrayErrorMessage = self::validateCarrierActivityInformationForArrayConstraintsFromSetCarrierActivityInformation($carrierActivityInformation))) {
            throw new \InvalidArgumentException($carrierActivityInformationArrayErrorMessage, __LINE__);
        }
        $this->CarrierActivityInformation = $carrierActivityInformation;
        return $this;
    }
    /**
     * Add item to CarrierActivityInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToCarrierActivityInformation(\Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType) {
            throw new \InvalidArgumentException(sprintf('The CarrierActivityInformation property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackCarrierActivityInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierActivityInformation[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \Ups_track\UPStrackStruct\Ups_trackDocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeDocumentItem instanceof \Ups_track\UPStrackStruct\Ups_trackDocumentType) {
                $invalidValues[] = is_object($shipmentTypeDocumentItem) ? get_class($shipmentTypeDocumentItem) : sprintf('%s(%s)', gettype($shipmentTypeDocumentItem), var_export($shipmentTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDocumentType[] $document
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDocumentType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToDocument(\Ups_track\UPStrackStruct\Ups_trackDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackDocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get FileNumber value
     * @return string|null
     */
    public function getFileNumber()
    {
        return $this->FileNumber;
    }
    /**
     * Set FileNumber value
     * @param string $fileNumber
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setFileNumber($fileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fileNumber) && !is_string($fileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileNumber, true), gettype($fileNumber)), __LINE__);
        }
        $this->FileNumber = $fileNumber;
        return $this;
    }
    /**
     * Get Appointment value
     * @return \Ups_track\UPStrackStruct\Ups_trackAppointmentType|null
     */
    public function getAppointment()
    {
        return $this->Appointment;
    }
    /**
     * Set Appointment value
     * @param \Ups_track\UPStrackStruct\Ups_trackAppointmentType $appointment
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setAppointment(\Ups_track\UPStrackStruct\Ups_trackAppointmentType $appointment = null)
    {
        $this->Appointment = $appointment;
        return $this;
    }
    /**
     * Get Package value
     * @return \Ups_track\UPStrackStruct\Ups_trackPackageType[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypePackageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypePackageItem instanceof \Ups_track\UPStrackStruct\Ups_trackPackageType) {
                $invalidValues[] = is_object($shipmentTypePackageItem) ? get_class($shipmentTypePackageItem) : sprintf('%s(%s)', gettype($shipmentTypePackageItem), var_export($shipmentTypePackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackPackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackPackageType[] $package
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackPackageType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToPackage(\Ups_track\UPStrackStruct\Ups_trackPackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackPackageType) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackPackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
    /**
     * Get AdditionalAttribute value
     * @return \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[]|null
     */
    public function getAdditionalAttribute()
    {
        return $this->AdditionalAttribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalAttributeForArrayConstraintsFromSetAdditionalAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeAdditionalAttributeItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeAdditionalAttributeItem instanceof \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType) {
                $invalidValues[] = is_object($shipmentTypeAdditionalAttributeItem) ? get_class($shipmentTypeAdditionalAttributeItem) : sprintf('%s(%s)', gettype($shipmentTypeAdditionalAttributeItem), var_export($shipmentTypeAdditionalAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalAttribute property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalAttribute value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[] $additionalAttribute
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function setAdditionalAttribute(array $additionalAttribute = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalAttributeArrayErrorMessage = self::validateAdditionalAttributeForArrayConstraintsFromSetAdditionalAttribute($additionalAttribute))) {
            throw new \InvalidArgumentException($additionalAttributeArrayErrorMessage, __LINE__);
        }
        $this->AdditionalAttribute = $additionalAttribute;
        return $this;
    }
    /**
     * Add item to AdditionalAttribute value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackShipmentType
     */
    public function addToAdditionalAttribute(\Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalAttribute property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalAttribute[] = $item;
        return $this;
    }
}
