<?php

namespace Ups_track\UPStrackStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityType UPStrackStruct
 * @package Ups_track
 * @subpackage Structs
 */
class Ups_trackActivityType extends AbstractStructBase
{
    /**
     * The AlternateTrackingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[]
     */
    public $AlternateTrackingInfo;
    /**
     * The ActivityLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackActivityLocationType
     */
    public $ActivityLocation;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackStatusType
     */
    public $Status;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Time
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Time;
    /**
     * The GMTDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GMTDate;
    /**
     * The GMTTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GMTTime;
    /**
     * The GMTOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GMTOffset;
    /**
     * The DeliveryDateFromManifestIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDateFromManifestIndicator;
    /**
     * The NextScheduleActivity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackNextScheduleActivityType
     */
    public $NextScheduleActivity;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackDocumentType[]
     */
    public $Document;
    /**
     * The AdditionalAttribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[]
     */
    public $AdditionalAttribute;
    /**
     * Constructor method for ActivityType
     * @uses Ups_trackActivityType::setAlternateTrackingInfo()
     * @uses Ups_trackActivityType::setActivityLocation()
     * @uses Ups_trackActivityType::setStatus()
     * @uses Ups_trackActivityType::setDate()
     * @uses Ups_trackActivityType::setTime()
     * @uses Ups_trackActivityType::setGMTDate()
     * @uses Ups_trackActivityType::setGMTTime()
     * @uses Ups_trackActivityType::setGMTOffset()
     * @uses Ups_trackActivityType::setDeliveryDateFromManifestIndicator()
     * @uses Ups_trackActivityType::setNextScheduleActivity()
     * @uses Ups_trackActivityType::setDocument()
     * @uses Ups_trackActivityType::setAdditionalAttribute()
     * @param \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[] $alternateTrackingInfo
     * @param \Ups_track\UPStrackStruct\Ups_trackActivityLocationType $activityLocation
     * @param \Ups_track\UPStrackStruct\Ups_trackStatusType $status
     * @param string $date
     * @param string $time
     * @param string $gMTDate
     * @param string $gMTTime
     * @param string $gMTOffset
     * @param string $deliveryDateFromManifestIndicator
     * @param \Ups_track\UPStrackStruct\Ups_trackNextScheduleActivityType $nextScheduleActivity
     * @param \Ups_track\UPStrackStruct\Ups_trackDocumentType[] $document
     * @param \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[] $additionalAttribute
     */
    public function __construct(array $alternateTrackingInfo = array(), \Ups_track\UPStrackStruct\Ups_trackActivityLocationType $activityLocation = null, \Ups_track\UPStrackStruct\Ups_trackStatusType $status = null, $date = null, $time = null, $gMTDate = null, $gMTTime = null, $gMTOffset = null, $deliveryDateFromManifestIndicator = null, \Ups_track\UPStrackStruct\Ups_trackNextScheduleActivityType $nextScheduleActivity = null, array $document = array(), array $additionalAttribute = array())
    {
        $this
            ->setAlternateTrackingInfo($alternateTrackingInfo)
            ->setActivityLocation($activityLocation)
            ->setStatus($status)
            ->setDate($date)
            ->setTime($time)
            ->setGMTDate($gMTDate)
            ->setGMTTime($gMTTime)
            ->setGMTOffset($gMTOffset)
            ->setDeliveryDateFromManifestIndicator($deliveryDateFromManifestIndicator)
            ->setNextScheduleActivity($nextScheduleActivity)
            ->setDocument($document)
            ->setAdditionalAttribute($additionalAttribute);
    }
    /**
     * Get AlternateTrackingInfo value
     * @return \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[]|null
     */
    public function getAlternateTrackingInfo()
    {
        return $this->AlternateTrackingInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateTrackingInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateTrackingInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateTrackingInfoForArrayConstraintsFromSetAlternateTrackingInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityTypeAlternateTrackingInfoItem) {
            // validation for constraint: itemType
            if (!$activityTypeAlternateTrackingInfoItem instanceof \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType) {
                $invalidValues[] = is_object($activityTypeAlternateTrackingInfoItem) ? get_class($activityTypeAlternateTrackingInfoItem) : sprintf('%s(%s)', gettype($activityTypeAlternateTrackingInfoItem), var_export($activityTypeAlternateTrackingInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternateTrackingInfo property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternateTrackingInfo value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType[] $alternateTrackingInfo
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setAlternateTrackingInfo(array $alternateTrackingInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateTrackingInfoArrayErrorMessage = self::validateAlternateTrackingInfoForArrayConstraintsFromSetAlternateTrackingInfo($alternateTrackingInfo))) {
            throw new \InvalidArgumentException($alternateTrackingInfoArrayErrorMessage, __LINE__);
        }
        $this->AlternateTrackingInfo = $alternateTrackingInfo;
        return $this;
    }
    /**
     * Add item to AlternateTrackingInfo value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function addToAlternateTrackingInfo(\Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType) {
            throw new \InvalidArgumentException(sprintf('The AlternateTrackingInfo property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAlternateTrackingInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlternateTrackingInfo[] = $item;
        return $this;
    }
    /**
     * Get ActivityLocation value
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityLocationType|null
     */
    public function getActivityLocation()
    {
        return $this->ActivityLocation;
    }
    /**
     * Set ActivityLocation value
     * @param \Ups_track\UPStrackStruct\Ups_trackActivityLocationType $activityLocation
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setActivityLocation(\Ups_track\UPStrackStruct\Ups_trackActivityLocationType $activityLocation = null)
    {
        $this->ActivityLocation = $activityLocation;
        return $this;
    }
    /**
     * Get Status value
     * @return \Ups_track\UPStrackStruct\Ups_trackStatusType|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \Ups_track\UPStrackStruct\Ups_trackStatusType $status
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setStatus(\Ups_track\UPStrackStruct\Ups_trackStatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get GMTDate value
     * @return string|null
     */
    public function getGMTDate()
    {
        return $this->GMTDate;
    }
    /**
     * Set GMTDate value
     * @param string $gMTDate
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setGMTDate($gMTDate = null)
    {
        // validation for constraint: string
        if (!is_null($gMTDate) && !is_string($gMTDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gMTDate, true), gettype($gMTDate)), __LINE__);
        }
        $this->GMTDate = $gMTDate;
        return $this;
    }
    /**
     * Get GMTTime value
     * @return string|null
     */
    public function getGMTTime()
    {
        return $this->GMTTime;
    }
    /**
     * Set GMTTime value
     * @param string $gMTTime
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setGMTTime($gMTTime = null)
    {
        // validation for constraint: string
        if (!is_null($gMTTime) && !is_string($gMTTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gMTTime, true), gettype($gMTTime)), __LINE__);
        }
        $this->GMTTime = $gMTTime;
        return $this;
    }
    /**
     * Get GMTOffset value
     * @return string|null
     */
    public function getGMTOffset()
    {
        return $this->GMTOffset;
    }
    /**
     * Set GMTOffset value
     * @param string $gMTOffset
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setGMTOffset($gMTOffset = null)
    {
        // validation for constraint: string
        if (!is_null($gMTOffset) && !is_string($gMTOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gMTOffset, true), gettype($gMTOffset)), __LINE__);
        }
        $this->GMTOffset = $gMTOffset;
        return $this;
    }
    /**
     * Get DeliveryDateFromManifestIndicator value
     * @return string|null
     */
    public function getDeliveryDateFromManifestIndicator()
    {
        return $this->DeliveryDateFromManifestIndicator;
    }
    /**
     * Set DeliveryDateFromManifestIndicator value
     * @param string $deliveryDateFromManifestIndicator
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setDeliveryDateFromManifestIndicator($deliveryDateFromManifestIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDateFromManifestIndicator) && !is_string($deliveryDateFromManifestIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDateFromManifestIndicator, true), gettype($deliveryDateFromManifestIndicator)), __LINE__);
        }
        $this->DeliveryDateFromManifestIndicator = $deliveryDateFromManifestIndicator;
        return $this;
    }
    /**
     * Get NextScheduleActivity value
     * @return \Ups_track\UPStrackStruct\Ups_trackNextScheduleActivityType|null
     */
    public function getNextScheduleActivity()
    {
        return $this->NextScheduleActivity;
    }
    /**
     * Set NextScheduleActivity value
     * @param \Ups_track\UPStrackStruct\Ups_trackNextScheduleActivityType $nextScheduleActivity
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setNextScheduleActivity(\Ups_track\UPStrackStruct\Ups_trackNextScheduleActivityType $nextScheduleActivity = null)
    {
        $this->NextScheduleActivity = $nextScheduleActivity;
        return $this;
    }
    /**
     * Get Document value
     * @return \Ups_track\UPStrackStruct\Ups_trackDocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$activityTypeDocumentItem instanceof \Ups_track\UPStrackStruct\Ups_trackDocumentType) {
                $invalidValues[] = is_object($activityTypeDocumentItem) ? get_class($activityTypeDocumentItem) : sprintf('%s(%s)', gettype($activityTypeDocumentItem), var_export($activityTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDocumentType[] $document
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackDocumentType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function addToDocument(\Ups_track\UPStrackStruct\Ups_trackDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackDocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackDocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get AdditionalAttribute value
     * @return \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[]|null
     */
    public function getAdditionalAttribute()
    {
        return $this->AdditionalAttribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalAttributeForArrayConstraintsFromSetAdditionalAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityTypeAdditionalAttributeItem) {
            // validation for constraint: itemType
            if (!$activityTypeAdditionalAttributeItem instanceof \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType) {
                $invalidValues[] = is_object($activityTypeAdditionalAttributeItem) ? get_class($activityTypeAdditionalAttributeItem) : sprintf('%s(%s)', gettype($activityTypeAdditionalAttributeItem), var_export($activityTypeAdditionalAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalAttribute property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalAttribute value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType[] $additionalAttribute
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function setAdditionalAttribute(array $additionalAttribute = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalAttributeArrayErrorMessage = self::validateAdditionalAttributeForArrayConstraintsFromSetAdditionalAttribute($additionalAttribute))) {
            throw new \InvalidArgumentException($additionalAttributeArrayErrorMessage, __LINE__);
        }
        $this->AdditionalAttribute = $additionalAttribute;
        return $this;
    }
    /**
     * Add item to AdditionalAttribute value
     * @throws \InvalidArgumentException
     * @param \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType $item
     * @return \Ups_track\UPStrackStruct\Ups_trackActivityType
     */
    public function addToAdditionalAttribute(\Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalAttribute property can only contain items of type \Ups_track\UPStrackStruct\Ups_trackAdditionalCodeDescriptionValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalAttribute[] = $item;
        return $this;
    }
}
