<?php

namespace Ups_track\UPStrackServicet;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process UPStrackServicet
 * @package Ups_track
 * @subpackage Services
 */
class Ups_trackProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_track\UPStrackStruct\Ups_trackUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_track\UPStrackStruct\Ups_trackUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessTrack
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_track\UPStrackStruct\Ups_trackUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_track\UPStrackStruct\Ups_trackTrackRequest $body
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackResponse|bool
     */
    public function ProcessTrack(\Ups_track\UPStrackStruct\Ups_trackTrackRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessTrack($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_track\UPStrackStruct\Ups_trackTrackResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
