<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWeightType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsProductWeightType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \Ups\upsshipStruct\UpsUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for ProductWeightType
     * @uses UpsProductWeightType::setUnitOfMeasurement()
     * @uses UpsProductWeightType::setWeight()
     * @param \Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement
     * @param string $weight
     */
    public function __construct(\Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement = null, $weight = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setWeight($weight);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups\upsshipStruct\UpsUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement
     * @return \Ups\upsshipStruct\UpsProductWeightType
     */
    public function setUnitOfMeasurement(\Ups\upsshipStruct\UpsUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Ups\upsshipStruct\UpsProductWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
