<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsProductType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * @var string[]
     */
    public $Description;
    /**
     * The Unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsUnitType
     */
    public $Unit;
    /**
     * The CommodityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommodityCode;
    /**
     * The PartNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - usage: notused
     * @var string
     */
    public $PartNumber;
    /**
     * The OriginCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginCountryCode;
    /**
     * The JointProductionIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $JointProductionIndicator;
    /**
     * The NetCostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NetCostCode;
    /**
     * The NetCostDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsNetCostDateType
     */
    public $NetCostDateRange;
    /**
     * The PreferenceCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PreferenceCriteria;
    /**
     * The ProducerInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProducerInfo;
    /**
     * The MarksAndNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MarksAndNumbers;
    /**
     * The NumberOfPackagesPerCommodity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfPackagesPerCommodity;
    /**
     * The ProductWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsProductWeightType
     */
    public $ProductWeight;
    /**
     * The VehicleID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VehicleID;
    /**
     * The ScheduleB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsScheduleBType
     */
    public $ScheduleB;
    /**
     * The ExportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportType;
    /**
     * The SEDTotalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SEDTotalValue;
    /**
     * The ExcludeFromForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsExcludeFromFormType
     */
    public $ExcludeFromForm;
    /**
     * The ProductCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductCurrencyCode;
    /**
     * The PackingListInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPackingListInfoType
     */
    public $PackingListInfo;
    /**
     * The EEIInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsEEIInformationType
     */
    public $EEIInformation;
    /**
     * Constructor method for ProductType
     * @uses UpsProductType::setDescription()
     * @uses UpsProductType::setUnit()
     * @uses UpsProductType::setCommodityCode()
     * @uses UpsProductType::setPartNumber()
     * @uses UpsProductType::setOriginCountryCode()
     * @uses UpsProductType::setJointProductionIndicator()
     * @uses UpsProductType::setNetCostCode()
     * @uses UpsProductType::setNetCostDateRange()
     * @uses UpsProductType::setPreferenceCriteria()
     * @uses UpsProductType::setProducerInfo()
     * @uses UpsProductType::setMarksAndNumbers()
     * @uses UpsProductType::setNumberOfPackagesPerCommodity()
     * @uses UpsProductType::setProductWeight()
     * @uses UpsProductType::setVehicleID()
     * @uses UpsProductType::setScheduleB()
     * @uses UpsProductType::setExportType()
     * @uses UpsProductType::setSEDTotalValue()
     * @uses UpsProductType::setExcludeFromForm()
     * @uses UpsProductType::setProductCurrencyCode()
     * @uses UpsProductType::setPackingListInfo()
     * @uses UpsProductType::setEEIInformation()
     * @param string[] $description
     * @param \Ups\upsshipStruct\UpsUnitType $unit
     * @param string $commodityCode
     * @param string $partNumber
     * @param string $originCountryCode
     * @param string $jointProductionIndicator
     * @param string $netCostCode
     * @param \Ups\upsshipStruct\UpsNetCostDateType $netCostDateRange
     * @param string $preferenceCriteria
     * @param string $producerInfo
     * @param string $marksAndNumbers
     * @param string $numberOfPackagesPerCommodity
     * @param \Ups\upsshipStruct\UpsProductWeightType $productWeight
     * @param string $vehicleID
     * @param \Ups\upsshipStruct\UpsScheduleBType $scheduleB
     * @param string $exportType
     * @param string $sEDTotalValue
     * @param \Ups\upsshipStruct\UpsExcludeFromFormType $excludeFromForm
     * @param string $productCurrencyCode
     * @param \Ups\upsshipStruct\UpsPackingListInfoType $packingListInfo
     * @param \Ups\upsshipStruct\UpsEEIInformationType $eEIInformation
     */
    public function __construct(array $description = array(), \Ups\upsshipStruct\UpsUnitType $unit = null, $commodityCode = null, $partNumber = null, $originCountryCode = null, $jointProductionIndicator = null, $netCostCode = null, \Ups\upsshipStruct\UpsNetCostDateType $netCostDateRange = null, $preferenceCriteria = null, $producerInfo = null, $marksAndNumbers = null, $numberOfPackagesPerCommodity = null, \Ups\upsshipStruct\UpsProductWeightType $productWeight = null, $vehicleID = null, \Ups\upsshipStruct\UpsScheduleBType $scheduleB = null, $exportType = null, $sEDTotalValue = null, \Ups\upsshipStruct\UpsExcludeFromFormType $excludeFromForm = null, $productCurrencyCode = null, \Ups\upsshipStruct\UpsPackingListInfoType $packingListInfo = null, \Ups\upsshipStruct\UpsEEIInformationType $eEIInformation = null)
    {
        $this
            ->setDescription($description)
            ->setUnit($unit)
            ->setCommodityCode($commodityCode)
            ->setPartNumber($partNumber)
            ->setOriginCountryCode($originCountryCode)
            ->setJointProductionIndicator($jointProductionIndicator)
            ->setNetCostCode($netCostCode)
            ->setNetCostDateRange($netCostDateRange)
            ->setPreferenceCriteria($preferenceCriteria)
            ->setProducerInfo($producerInfo)
            ->setMarksAndNumbers($marksAndNumbers)
            ->setNumberOfPackagesPerCommodity($numberOfPackagesPerCommodity)
            ->setProductWeight($productWeight)
            ->setVehicleID($vehicleID)
            ->setScheduleB($scheduleB)
            ->setExportType($exportType)
            ->setSEDTotalValue($sEDTotalValue)
            ->setExcludeFromForm($excludeFromForm)
            ->setProductCurrencyCode($productCurrencyCode)
            ->setPackingListInfo($packingListInfo)
            ->setEEIInformation($eEIInformation);
    }
    /**
     * Get Description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($productTypeDescriptionItem)) {
                $invalidValues[] = is_object($productTypeDescriptionItem) ? get_class($productTypeDescriptionItem) : sprintf('%s(%s)', gettype($productTypeDescriptionItem), var_export($productTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($description) && count($description) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Description) && count($this->Description) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Unit value
     * @return \Ups\upsshipStruct\UpsUnitType|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param \Ups\upsshipStruct\UpsUnitType $unit
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setUnit(\Ups\upsshipStruct\UpsUnitType $unit = null)
    {
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get CommodityCode value
     * @return string|null
     */
    public function getCommodityCode()
    {
        return $this->CommodityCode;
    }
    /**
     * Set CommodityCode value
     * @param string $commodityCode
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setCommodityCode($commodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($commodityCode) && !is_string($commodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityCode, true), gettype($commodityCode)), __LINE__);
        }
        $this->CommodityCode = $commodityCode;
        return $this;
    }
    /**
     * Get PartNumber value
     * @return string|null
     */
    public function getPartNumber()
    {
        return $this->PartNumber;
    }
    /**
     * Set PartNumber value
     * @param string $partNumber
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setPartNumber($partNumber = null)
    {
        // validation for constraint: string
        if (!is_null($partNumber) && !is_string($partNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partNumber, true), gettype($partNumber)), __LINE__);
        }
        $this->PartNumber = $partNumber;
        return $this;
    }
    /**
     * Get OriginCountryCode value
     * @return string|null
     */
    public function getOriginCountryCode()
    {
        return $this->OriginCountryCode;
    }
    /**
     * Set OriginCountryCode value
     * @param string $originCountryCode
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setOriginCountryCode($originCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCountryCode) && !is_string($originCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCountryCode, true), gettype($originCountryCode)), __LINE__);
        }
        $this->OriginCountryCode = $originCountryCode;
        return $this;
    }
    /**
     * Get JointProductionIndicator value
     * @return string|null
     */
    public function getJointProductionIndicator()
    {
        return $this->JointProductionIndicator;
    }
    /**
     * Set JointProductionIndicator value
     * @param string $jointProductionIndicator
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setJointProductionIndicator($jointProductionIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($jointProductionIndicator) && !is_string($jointProductionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointProductionIndicator, true), gettype($jointProductionIndicator)), __LINE__);
        }
        $this->JointProductionIndicator = $jointProductionIndicator;
        return $this;
    }
    /**
     * Get NetCostCode value
     * @return string|null
     */
    public function getNetCostCode()
    {
        return $this->NetCostCode;
    }
    /**
     * Set NetCostCode value
     * @param string $netCostCode
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setNetCostCode($netCostCode = null)
    {
        // validation for constraint: string
        if (!is_null($netCostCode) && !is_string($netCostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netCostCode, true), gettype($netCostCode)), __LINE__);
        }
        $this->NetCostCode = $netCostCode;
        return $this;
    }
    /**
     * Get NetCostDateRange value
     * @return \Ups\upsshipStruct\UpsNetCostDateType|null
     */
    public function getNetCostDateRange()
    {
        return $this->NetCostDateRange;
    }
    /**
     * Set NetCostDateRange value
     * @param \Ups\upsshipStruct\UpsNetCostDateType $netCostDateRange
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setNetCostDateRange(\Ups\upsshipStruct\UpsNetCostDateType $netCostDateRange = null)
    {
        $this->NetCostDateRange = $netCostDateRange;
        return $this;
    }
    /**
     * Get PreferenceCriteria value
     * @return string|null
     */
    public function getPreferenceCriteria()
    {
        return $this->PreferenceCriteria;
    }
    /**
     * Set PreferenceCriteria value
     * @param string $preferenceCriteria
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setPreferenceCriteria($preferenceCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($preferenceCriteria) && !is_string($preferenceCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferenceCriteria, true), gettype($preferenceCriteria)), __LINE__);
        }
        $this->PreferenceCriteria = $preferenceCriteria;
        return $this;
    }
    /**
     * Get ProducerInfo value
     * @return string|null
     */
    public function getProducerInfo()
    {
        return $this->ProducerInfo;
    }
    /**
     * Set ProducerInfo value
     * @param string $producerInfo
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setProducerInfo($producerInfo = null)
    {
        // validation for constraint: string
        if (!is_null($producerInfo) && !is_string($producerInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($producerInfo, true), gettype($producerInfo)), __LINE__);
        }
        $this->ProducerInfo = $producerInfo;
        return $this;
    }
    /**
     * Get MarksAndNumbers value
     * @return string|null
     */
    public function getMarksAndNumbers()
    {
        return $this->MarksAndNumbers;
    }
    /**
     * Set MarksAndNumbers value
     * @param string $marksAndNumbers
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setMarksAndNumbers($marksAndNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($marksAndNumbers) && !is_string($marksAndNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marksAndNumbers, true), gettype($marksAndNumbers)), __LINE__);
        }
        $this->MarksAndNumbers = $marksAndNumbers;
        return $this;
    }
    /**
     * Get NumberOfPackagesPerCommodity value
     * @return string|null
     */
    public function getNumberOfPackagesPerCommodity()
    {
        return $this->NumberOfPackagesPerCommodity;
    }
    /**
     * Set NumberOfPackagesPerCommodity value
     * @param string $numberOfPackagesPerCommodity
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setNumberOfPackagesPerCommodity($numberOfPackagesPerCommodity = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfPackagesPerCommodity) && !is_string($numberOfPackagesPerCommodity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfPackagesPerCommodity, true), gettype($numberOfPackagesPerCommodity)), __LINE__);
        }
        $this->NumberOfPackagesPerCommodity = $numberOfPackagesPerCommodity;
        return $this;
    }
    /**
     * Get ProductWeight value
     * @return \Ups\upsshipStruct\UpsProductWeightType|null
     */
    public function getProductWeight()
    {
        return $this->ProductWeight;
    }
    /**
     * Set ProductWeight value
     * @param \Ups\upsshipStruct\UpsProductWeightType $productWeight
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setProductWeight(\Ups\upsshipStruct\UpsProductWeightType $productWeight = null)
    {
        $this->ProductWeight = $productWeight;
        return $this;
    }
    /**
     * Get VehicleID value
     * @return string|null
     */
    public function getVehicleID()
    {
        return $this->VehicleID;
    }
    /**
     * Set VehicleID value
     * @param string $vehicleID
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID) && !is_string($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleID, true), gettype($vehicleID)), __LINE__);
        }
        $this->VehicleID = $vehicleID;
        return $this;
    }
    /**
     * Get ScheduleB value
     * @return \Ups\upsshipStruct\UpsScheduleBType|null
     */
    public function getScheduleB()
    {
        return $this->ScheduleB;
    }
    /**
     * Set ScheduleB value
     * @param \Ups\upsshipStruct\UpsScheduleBType $scheduleB
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setScheduleB(\Ups\upsshipStruct\UpsScheduleBType $scheduleB = null)
    {
        $this->ScheduleB = $scheduleB;
        return $this;
    }
    /**
     * Get ExportType value
     * @return string|null
     */
    public function getExportType()
    {
        return $this->ExportType;
    }
    /**
     * Set ExportType value
     * @param string $exportType
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setExportType($exportType = null)
    {
        // validation for constraint: string
        if (!is_null($exportType) && !is_string($exportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportType, true), gettype($exportType)), __LINE__);
        }
        $this->ExportType = $exportType;
        return $this;
    }
    /**
     * Get SEDTotalValue value
     * @return string|null
     */
    public function getSEDTotalValue()
    {
        return $this->SEDTotalValue;
    }
    /**
     * Set SEDTotalValue value
     * @param string $sEDTotalValue
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setSEDTotalValue($sEDTotalValue = null)
    {
        // validation for constraint: string
        if (!is_null($sEDTotalValue) && !is_string($sEDTotalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEDTotalValue, true), gettype($sEDTotalValue)), __LINE__);
        }
        $this->SEDTotalValue = $sEDTotalValue;
        return $this;
    }
    /**
     * Get ExcludeFromForm value
     * @return \Ups\upsshipStruct\UpsExcludeFromFormType|null
     */
    public function getExcludeFromForm()
    {
        return $this->ExcludeFromForm;
    }
    /**
     * Set ExcludeFromForm value
     * @param \Ups\upsshipStruct\UpsExcludeFromFormType $excludeFromForm
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setExcludeFromForm(\Ups\upsshipStruct\UpsExcludeFromFormType $excludeFromForm = null)
    {
        $this->ExcludeFromForm = $excludeFromForm;
        return $this;
    }
    /**
     * Get ProductCurrencyCode value
     * @return string|null
     */
    public function getProductCurrencyCode()
    {
        return $this->ProductCurrencyCode;
    }
    /**
     * Set ProductCurrencyCode value
     * @param string $productCurrencyCode
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setProductCurrencyCode($productCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCurrencyCode) && !is_string($productCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCurrencyCode, true), gettype($productCurrencyCode)), __LINE__);
        }
        $this->ProductCurrencyCode = $productCurrencyCode;
        return $this;
    }
    /**
     * Get PackingListInfo value
     * @return \Ups\upsshipStruct\UpsPackingListInfoType|null
     */
    public function getPackingListInfo()
    {
        return $this->PackingListInfo;
    }
    /**
     * Set PackingListInfo value
     * @param \Ups\upsshipStruct\UpsPackingListInfoType $packingListInfo
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setPackingListInfo(\Ups\upsshipStruct\UpsPackingListInfoType $packingListInfo = null)
    {
        $this->PackingListInfo = $packingListInfo;
        return $this;
    }
    /**
     * Get EEIInformation value
     * @return \Ups\upsshipStruct\UpsEEIInformationType|null
     */
    public function getEEIInformation()
    {
        return $this->EEIInformation;
    }
    /**
     * Set EEIInformation value
     * @param \Ups\upsshipStruct\UpsEEIInformationType $eEIInformation
     * @return \Ups\upsshipStruct\UpsProductType
     */
    public function setEEIInformation(\Ups\upsshipStruct\UpsEEIInformationType $eEIInformation = null)
    {
        $this->EEIInformation = $eEIInformation;
        return $this;
    }
}
