<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageDeclaredValueType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPackageDeclaredValueType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsDeclaredValueType
     */
    public $Type;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MonetaryValue
     * @var string
     */
    public $MonetaryValue;
    /**
     * Constructor method for PackageDeclaredValueType
     * @uses UpsPackageDeclaredValueType::setType()
     * @uses UpsPackageDeclaredValueType::setCurrencyCode()
     * @uses UpsPackageDeclaredValueType::setMonetaryValue()
     * @param \Ups\upsshipStruct\UpsDeclaredValueType $type
     * @param string $currencyCode
     * @param string $monetaryValue
     */
    public function __construct(\Ups\upsshipStruct\UpsDeclaredValueType $type = null, $currencyCode = null, $monetaryValue = null)
    {
        $this
            ->setType($type)
            ->setCurrencyCode($currencyCode)
            ->setMonetaryValue($monetaryValue);
    }
    /**
     * Get Type value
     * @return \Ups\upsshipStruct\UpsDeclaredValueType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups\upsshipStruct\UpsDeclaredValueType $type
     * @return \Ups\upsshipStruct\UpsPackageDeclaredValueType
     */
    public function setType(\Ups\upsshipStruct\UpsDeclaredValueType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Ups\upsshipStruct\UpsPackageDeclaredValueType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MonetaryValue value
     * @return string|null
     */
    public function getMonetaryValue()
    {
        return $this->MonetaryValue;
    }
    /**
     * Set MonetaryValue value
     * @param string $monetaryValue
     * @return \Ups\upsshipStruct\UpsPackageDeclaredValueType
     */
    public function setMonetaryValue($monetaryValue = null)
    {
        // validation for constraint: string
        if (!is_null($monetaryValue) && !is_string($monetaryValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monetaryValue, true), gettype($monetaryValue)), __LINE__);
        }
        $this->MonetaryValue = $monetaryValue;
        return $this;
    }
}
