<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingUnitsType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsHandlingUnitsType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The Type
     * @var \Ups\upsshipStruct\UpsShipUnitOfMeasurementType
     */
    public $Type;
    /**
     * The Dimensions
     * @var \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType
     */
    public $Dimensions;
    /**
     * Constructor method for HandlingUnitsType
     * @uses UpsHandlingUnitsType::setQuantity()
     * @uses UpsHandlingUnitsType::setType()
     * @uses UpsHandlingUnitsType::setDimensions()
     * @param string $quantity
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type
     * @param \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions
     */
    public function __construct($quantity = null, \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type = null, \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions = null)
    {
        $this
            ->setQuantity($quantity)
            ->setType($type)
            ->setDimensions($dimensions);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Ups\upsshipStruct\UpsHandlingUnitsType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return \Ups\upsshipStruct\UpsShipUnitOfMeasurementType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type
     * @return \Ups\upsshipStruct\UpsHandlingUnitsType
     */
    public function setType(\Ups\upsshipStruct\UpsShipUnitOfMeasurementType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions
     * @return \Ups\upsshipStruct\UpsHandlingUnitsType
     */
    public function setDimensions(\Ups\upsshipStruct\UpsHandlingUnitsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
}
