<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FRSShipmentDataType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsFRSShipmentDataType extends AbstractStructBase
{
    /**
     * The TransportationCharges
     * @var \Ups\upsshipStruct\UpsTransportationChargeType
     */
    public $TransportationCharges;
    /**
     * The FreightDensityRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsFreightDensityRateType
     */
    public $FreightDensityRate;
    /**
     * The HandlingUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsHandlingUnitsResponseType[]
     */
    public $HandlingUnits;
    /**
     * Constructor method for FRSShipmentDataType
     * @uses UpsFRSShipmentDataType::setTransportationCharges()
     * @uses UpsFRSShipmentDataType::setFreightDensityRate()
     * @uses UpsFRSShipmentDataType::setHandlingUnits()
     * @param \Ups\upsshipStruct\UpsTransportationChargeType $transportationCharges
     * @param \Ups\upsshipStruct\UpsFreightDensityRateType $freightDensityRate
     * @param \Ups\upsshipStruct\UpsHandlingUnitsResponseType[] $handlingUnits
     */
    public function __construct(\Ups\upsshipStruct\UpsTransportationChargeType $transportationCharges = null, \Ups\upsshipStruct\UpsFreightDensityRateType $freightDensityRate = null, array $handlingUnits = array())
    {
        $this
            ->setTransportationCharges($transportationCharges)
            ->setFreightDensityRate($freightDensityRate)
            ->setHandlingUnits($handlingUnits);
    }
    /**
     * Get TransportationCharges value
     * @return \Ups\upsshipStruct\UpsTransportationChargeType|null
     */
    public function getTransportationCharges()
    {
        return $this->TransportationCharges;
    }
    /**
     * Set TransportationCharges value
     * @param \Ups\upsshipStruct\UpsTransportationChargeType $transportationCharges
     * @return \Ups\upsshipStruct\UpsFRSShipmentDataType
     */
    public function setTransportationCharges(\Ups\upsshipStruct\UpsTransportationChargeType $transportationCharges = null)
    {
        $this->TransportationCharges = $transportationCharges;
        return $this;
    }
    /**
     * Get FreightDensityRate value
     * @return \Ups\upsshipStruct\UpsFreightDensityRateType|null
     */
    public function getFreightDensityRate()
    {
        return $this->FreightDensityRate;
    }
    /**
     * Set FreightDensityRate value
     * @param \Ups\upsshipStruct\UpsFreightDensityRateType $freightDensityRate
     * @return \Ups\upsshipStruct\UpsFRSShipmentDataType
     */
    public function setFreightDensityRate(\Ups\upsshipStruct\UpsFreightDensityRateType $freightDensityRate = null)
    {
        $this->FreightDensityRate = $freightDensityRate;
        return $this;
    }
    /**
     * Get HandlingUnits value
     * @return \Ups\upsshipStruct\UpsHandlingUnitsResponseType[]|null
     */
    public function getHandlingUnits()
    {
        return $this->HandlingUnits;
    }
    /**
     * This method is responsible for validating the values passed to the setHandlingUnits method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHandlingUnits method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fRSShipmentDataTypeHandlingUnitsItem) {
            // validation for constraint: itemType
            if (!$fRSShipmentDataTypeHandlingUnitsItem instanceof \Ups\upsshipStruct\UpsHandlingUnitsResponseType) {
                $invalidValues[] = is_object($fRSShipmentDataTypeHandlingUnitsItem) ? get_class($fRSShipmentDataTypeHandlingUnitsItem) : sprintf('%s(%s)', gettype($fRSShipmentDataTypeHandlingUnitsItem), var_export($fRSShipmentDataTypeHandlingUnitsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HandlingUnits property can only contain items of type \Ups\upsshipStruct\UpsHandlingUnitsResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsHandlingUnitsResponseType[] $handlingUnits
     * @return \Ups\upsshipStruct\UpsFRSShipmentDataType
     */
    public function setHandlingUnits(array $handlingUnits = array())
    {
        // validation for constraint: array
        if ('' !== ($handlingUnitsArrayErrorMessage = self::validateHandlingUnitsForArrayConstraintsFromSetHandlingUnits($handlingUnits))) {
            throw new \InvalidArgumentException($handlingUnitsArrayErrorMessage, __LINE__);
        }
        $this->HandlingUnits = $handlingUnits;
        return $this;
    }
    /**
     * Add item to HandlingUnits value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsHandlingUnitsResponseType $item
     * @return \Ups\upsshipStruct\UpsFRSShipmentDataType
     */
    public function addToHandlingUnits(\Ups\upsshipStruct\UpsHandlingUnitsResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsHandlingUnitsResponseType) {
            throw new \InvalidArgumentException(sprintf('The HandlingUnits property can only contain items of type \Ups\upsshipStruct\UpsHandlingUnitsResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HandlingUnits[] = $item;
        return $this;
    }
}
