<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DryIceType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsDryIceType extends AbstractStructBase
{
    /**
     * The RegulationSet
     * @var string
     */
    public $RegulationSet;
    /**
     * The DryIceWeight
     * @var \Ups\upsshipStruct\UpsDryIceWeightType
     */
    public $DryIceWeight;
    /**
     * The MedicalUseIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MedicalUseIndicator;
    /**
     * Constructor method for DryIceType
     * @uses UpsDryIceType::setRegulationSet()
     * @uses UpsDryIceType::setDryIceWeight()
     * @uses UpsDryIceType::setMedicalUseIndicator()
     * @param string $regulationSet
     * @param \Ups\upsshipStruct\UpsDryIceWeightType $dryIceWeight
     * @param string $medicalUseIndicator
     */
    public function __construct($regulationSet = null, \Ups\upsshipStruct\UpsDryIceWeightType $dryIceWeight = null, $medicalUseIndicator = null)
    {
        $this
            ->setRegulationSet($regulationSet)
            ->setDryIceWeight($dryIceWeight)
            ->setMedicalUseIndicator($medicalUseIndicator);
    }
    /**
     * Get RegulationSet value
     * @return string|null
     */
    public function getRegulationSet()
    {
        return $this->RegulationSet;
    }
    /**
     * Set RegulationSet value
     * @param string $regulationSet
     * @return \Ups\upsshipStruct\UpsDryIceType
     */
    public function setRegulationSet($regulationSet = null)
    {
        // validation for constraint: string
        if (!is_null($regulationSet) && !is_string($regulationSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regulationSet, true), gettype($regulationSet)), __LINE__);
        }
        $this->RegulationSet = $regulationSet;
        return $this;
    }
    /**
     * Get DryIceWeight value
     * @return \Ups\upsshipStruct\UpsDryIceWeightType|null
     */
    public function getDryIceWeight()
    {
        return $this->DryIceWeight;
    }
    /**
     * Set DryIceWeight value
     * @param \Ups\upsshipStruct\UpsDryIceWeightType $dryIceWeight
     * @return \Ups\upsshipStruct\UpsDryIceType
     */
    public function setDryIceWeight(\Ups\upsshipStruct\UpsDryIceWeightType $dryIceWeight = null)
    {
        $this->DryIceWeight = $dryIceWeight;
        return $this;
    }
    /**
     * Get MedicalUseIndicator value
     * @return string|null
     */
    public function getMedicalUseIndicator()
    {
        return $this->MedicalUseIndicator;
    }
    /**
     * Set MedicalUseIndicator value
     * @param string $medicalUseIndicator
     * @return \Ups\upsshipStruct\UpsDryIceType
     */
    public function setMedicalUseIndicator($medicalUseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($medicalUseIndicator) && !is_string($medicalUseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalUseIndicator, true), gettype($medicalUseIndicator)), __LINE__);
        }
        $this->MedicalUseIndicator = $medicalUseIndicator;
        return $this;
    }
}
