<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommodityType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsCommodityType extends AbstractStructBase
{
    /**
     * The FreightClass
     * @var string
     */
    public $FreightClass;
    /**
     * The NMFC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsNMFCType
     */
    public $NMFC;
    /**
     * Constructor method for CommodityType
     * @uses UpsCommodityType::setFreightClass()
     * @uses UpsCommodityType::setNMFC()
     * @param string $freightClass
     * @param \Ups\upsshipStruct\UpsNMFCType $nMFC
     */
    public function __construct($freightClass = null, \Ups\upsshipStruct\UpsNMFCType $nMFC = null)
    {
        $this
            ->setFreightClass($freightClass)
            ->setNMFC($nMFC);
    }
    /**
     * Get FreightClass value
     * @return string|null
     */
    public function getFreightClass()
    {
        return $this->FreightClass;
    }
    /**
     * Set FreightClass value
     * @param string $freightClass
     * @return \Ups\upsshipStruct\UpsCommodityType
     */
    public function setFreightClass($freightClass = null)
    {
        // validation for constraint: string
        if (!is_null($freightClass) && !is_string($freightClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freightClass, true), gettype($freightClass)), __LINE__);
        }
        $this->FreightClass = $freightClass;
        return $this;
    }
    /**
     * Get NMFC value
     * @return \Ups\upsshipStruct\UpsNMFCType|null
     */
    public function getNMFC()
    {
        return $this->NMFC;
    }
    /**
     * Set NMFC value
     * @param \Ups\upsshipStruct\UpsNMFCType $nMFC
     * @return \Ups\upsshipStruct\UpsCommodityType
     */
    public function setNMFC(\Ups\upsshipStruct\UpsNMFCType $nMFC = null)
    {
        $this->NMFC = $nMFC;
        return $this;
    }
}
