<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UltimateConsigneeType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsUltimateConsigneeType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsAddressType
     */
    public $Address;
    /**
     * The UltimateConsigneeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsUltimateConsigneeTypeType
     */
    public $UltimateConsigneeType;
    /**
     * Constructor method for UltimateConsigneeType
     * @uses UpsUltimateConsigneeType::setCompanyName()
     * @uses UpsUltimateConsigneeType::setAddress()
     * @uses UpsUltimateConsigneeType::setUltimateConsigneeType()
     * @param string $companyName
     * @param \Ups\upsshipStruct\UpsAddressType $address
     * @param \Ups\upsshipStruct\UpsUltimateConsigneeTypeType $ultimateConsigneeType
     */
    public function __construct($companyName = null, \Ups\upsshipStruct\UpsAddressType $address = null, \Ups\upsshipStruct\UpsUltimateConsigneeTypeType $ultimateConsigneeType = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address)
            ->setUltimateConsigneeType($ultimateConsigneeType);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \Ups\upsshipStruct\UpsUltimateConsigneeType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsAddressType $address
     * @return \Ups\upsshipStruct\UpsUltimateConsigneeType
     */
    public function setAddress(\Ups\upsshipStruct\UpsAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get UltimateConsigneeType value
     * @return \Ups\upsshipStruct\UpsUltimateConsigneeTypeType|null
     */
    public function getUltimateConsigneeType()
    {
        return $this->UltimateConsigneeType;
    }
    /**
     * Set UltimateConsigneeType value
     * @param \Ups\upsshipStruct\UpsUltimateConsigneeTypeType $ultimateConsigneeType
     * @return \Ups\upsshipStruct\UpsUltimateConsigneeType
     */
    public function setUltimateConsigneeType(\Ups\upsshipStruct\UpsUltimateConsigneeTypeType $ultimateConsigneeType = null)
    {
        $this->UltimateConsigneeType = $ultimateConsigneeType;
        return $this;
    }
}
