<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPackageType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PalletDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PalletDescription;
    /**
     * The NumOfPieces
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumOfPieces;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UnitPrice;
    /**
     * The Packaging
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPackagingType
     */
    public $Packaging;
    /**
     * The Dimensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsDimensionsType
     */
    public $Dimensions;
    /**
     * The DimWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPackageWeightType
     */
    public $DimWeight;
    /**
     * The PackageWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPackageWeightType
     */
    public $PackageWeight;
    /**
     * The LargePackageIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LargePackageIndicator;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsReferenceNumberType[]
     */
    public $ReferenceNumber;
    /**
     * The AdditionalHandlingIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalHandlingIndicator;
    /**
     * The PackageServiceOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public $PackageServiceOptions;
    /**
     * The Commodity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCommodityType
     */
    public $Commodity;
    /**
     * The HazMatPackageInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsHazMatPackageInformationType
     */
    public $HazMatPackageInformation;
    /**
     * The SimpleRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCodeDescriptionType
     */
    public $SimpleRate;
    /**
     * The UPSPremier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsUPSPremierType
     */
    public $UPSPremier;
    /**
     * Constructor method for PackageType
     * @uses UpsPackageType::setDescription()
     * @uses UpsPackageType::setPalletDescription()
     * @uses UpsPackageType::setNumOfPieces()
     * @uses UpsPackageType::setUnitPrice()
     * @uses UpsPackageType::setPackaging()
     * @uses UpsPackageType::setDimensions()
     * @uses UpsPackageType::setDimWeight()
     * @uses UpsPackageType::setPackageWeight()
     * @uses UpsPackageType::setLargePackageIndicator()
     * @uses UpsPackageType::setReferenceNumber()
     * @uses UpsPackageType::setAdditionalHandlingIndicator()
     * @uses UpsPackageType::setPackageServiceOptions()
     * @uses UpsPackageType::setCommodity()
     * @uses UpsPackageType::setHazMatPackageInformation()
     * @uses UpsPackageType::setSimpleRate()
     * @uses UpsPackageType::setUPSPremier()
     * @param string $description
     * @param string $palletDescription
     * @param string $numOfPieces
     * @param string $unitPrice
     * @param \Ups\upsshipStruct\UpsPackagingType $packaging
     * @param \Ups\upsshipStruct\UpsDimensionsType $dimensions
     * @param \Ups\upsshipStruct\UpsPackageWeightType $dimWeight
     * @param \Ups\upsshipStruct\UpsPackageWeightType $packageWeight
     * @param string $largePackageIndicator
     * @param \Ups\upsshipStruct\UpsReferenceNumberType[] $referenceNumber
     * @param string $additionalHandlingIndicator
     * @param \Ups\upsshipStruct\UpsPackageServiceOptionsType $packageServiceOptions
     * @param \Ups\upsshipStruct\UpsCommodityType $commodity
     * @param \Ups\upsshipStruct\UpsHazMatPackageInformationType $hazMatPackageInformation
     * @param \Ups\upsshipStruct\UpsCodeDescriptionType $simpleRate
     * @param \Ups\upsshipStruct\UpsUPSPremierType $uPSPremier
     */
    public function __construct($description = null, $palletDescription = null, $numOfPieces = null, $unitPrice = null, \Ups\upsshipStruct\UpsPackagingType $packaging = null, \Ups\upsshipStruct\UpsDimensionsType $dimensions = null, \Ups\upsshipStruct\UpsPackageWeightType $dimWeight = null, \Ups\upsshipStruct\UpsPackageWeightType $packageWeight = null, $largePackageIndicator = null, array $referenceNumber = array(), $additionalHandlingIndicator = null, \Ups\upsshipStruct\UpsPackageServiceOptionsType $packageServiceOptions = null, \Ups\upsshipStruct\UpsCommodityType $commodity = null, \Ups\upsshipStruct\UpsHazMatPackageInformationType $hazMatPackageInformation = null, \Ups\upsshipStruct\UpsCodeDescriptionType $simpleRate = null, \Ups\upsshipStruct\UpsUPSPremierType $uPSPremier = null)
    {
        $this
            ->setDescription($description)
            ->setPalletDescription($palletDescription)
            ->setNumOfPieces($numOfPieces)
            ->setUnitPrice($unitPrice)
            ->setPackaging($packaging)
            ->setDimensions($dimensions)
            ->setDimWeight($dimWeight)
            ->setPackageWeight($packageWeight)
            ->setLargePackageIndicator($largePackageIndicator)
            ->setReferenceNumber($referenceNumber)
            ->setAdditionalHandlingIndicator($additionalHandlingIndicator)
            ->setPackageServiceOptions($packageServiceOptions)
            ->setCommodity($commodity)
            ->setHazMatPackageInformation($hazMatPackageInformation)
            ->setSimpleRate($simpleRate)
            ->setUPSPremier($uPSPremier);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PalletDescription value
     * @return string|null
     */
    public function getPalletDescription()
    {
        return $this->PalletDescription;
    }
    /**
     * Set PalletDescription value
     * @param string $palletDescription
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setPalletDescription($palletDescription = null)
    {
        // validation for constraint: string
        if (!is_null($palletDescription) && !is_string($palletDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletDescription, true), gettype($palletDescription)), __LINE__);
        }
        $this->PalletDescription = $palletDescription;
        return $this;
    }
    /**
     * Get NumOfPieces value
     * @return string|null
     */
    public function getNumOfPieces()
    {
        return $this->NumOfPieces;
    }
    /**
     * Set NumOfPieces value
     * @param string $numOfPieces
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setNumOfPieces($numOfPieces = null)
    {
        // validation for constraint: string
        if (!is_null($numOfPieces) && !is_string($numOfPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfPieces, true), gettype($numOfPieces)), __LINE__);
        }
        $this->NumOfPieces = $numOfPieces;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param string $unitPrice
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Packaging value
     * @return \Ups\upsshipStruct\UpsPackagingType|null
     */
    public function getPackaging()
    {
        return $this->Packaging;
    }
    /**
     * Set Packaging value
     * @param \Ups\upsshipStruct\UpsPackagingType $packaging
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setPackaging(\Ups\upsshipStruct\UpsPackagingType $packaging = null)
    {
        $this->Packaging = $packaging;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \Ups\upsshipStruct\UpsDimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \Ups\upsshipStruct\UpsDimensionsType $dimensions
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setDimensions(\Ups\upsshipStruct\UpsDimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get DimWeight value
     * @return \Ups\upsshipStruct\UpsPackageWeightType|null
     */
    public function getDimWeight()
    {
        return $this->DimWeight;
    }
    /**
     * Set DimWeight value
     * @param \Ups\upsshipStruct\UpsPackageWeightType $dimWeight
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setDimWeight(\Ups\upsshipStruct\UpsPackageWeightType $dimWeight = null)
    {
        $this->DimWeight = $dimWeight;
        return $this;
    }
    /**
     * Get PackageWeight value
     * @return \Ups\upsshipStruct\UpsPackageWeightType|null
     */
    public function getPackageWeight()
    {
        return $this->PackageWeight;
    }
    /**
     * Set PackageWeight value
     * @param \Ups\upsshipStruct\UpsPackageWeightType $packageWeight
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setPackageWeight(\Ups\upsshipStruct\UpsPackageWeightType $packageWeight = null)
    {
        $this->PackageWeight = $packageWeight;
        return $this;
    }
    /**
     * Get LargePackageIndicator value
     * @return string|null
     */
    public function getLargePackageIndicator()
    {
        return $this->LargePackageIndicator;
    }
    /**
     * Set LargePackageIndicator value
     * @param string $largePackageIndicator
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setLargePackageIndicator($largePackageIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($largePackageIndicator) && !is_string($largePackageIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largePackageIndicator, true), gettype($largePackageIndicator)), __LINE__);
        }
        $this->LargePackageIndicator = $largePackageIndicator;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups\upsshipStruct\UpsReferenceNumberType[]|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceNumberForArrayConstraintsFromSetReferenceNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeReferenceNumberItem) {
            // validation for constraint: itemType
            if (!$packageTypeReferenceNumberItem instanceof \Ups\upsshipStruct\UpsReferenceNumberType) {
                $invalidValues[] = is_object($packageTypeReferenceNumberItem) ? get_class($packageTypeReferenceNumberItem) : sprintf('%s(%s)', gettype($packageTypeReferenceNumberItem), var_export($packageTypeReferenceNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceNumber property can only contain items of type \Ups\upsshipStruct\UpsReferenceNumberType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsReferenceNumberType[] $referenceNumber
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setReferenceNumber(array $referenceNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceNumberArrayErrorMessage = self::validateReferenceNumberForArrayConstraintsFromSetReferenceNumber($referenceNumber))) {
            throw new \InvalidArgumentException($referenceNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($referenceNumber) && count($referenceNumber) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Add item to ReferenceNumber value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsReferenceNumberType $item
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function addToReferenceNumber(\Ups\upsshipStruct\UpsReferenceNumberType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsReferenceNumberType) {
            throw new \InvalidArgumentException(sprintf('The ReferenceNumber property can only contain items of type \Ups\upsshipStruct\UpsReferenceNumberType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ReferenceNumber) && count($this->ReferenceNumber) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ReferenceNumber)), __LINE__);
        }
        $this->ReferenceNumber[] = $item;
        return $this;
    }
    /**
     * Get AdditionalHandlingIndicator value
     * @return string|null
     */
    public function getAdditionalHandlingIndicator()
    {
        return $this->AdditionalHandlingIndicator;
    }
    /**
     * Set AdditionalHandlingIndicator value
     * @param string $additionalHandlingIndicator
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setAdditionalHandlingIndicator($additionalHandlingIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($additionalHandlingIndicator) && !is_string($additionalHandlingIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalHandlingIndicator, true), gettype($additionalHandlingIndicator)), __LINE__);
        }
        $this->AdditionalHandlingIndicator = $additionalHandlingIndicator;
        return $this;
    }
    /**
     * Get PackageServiceOptions value
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType|null
     */
    public function getPackageServiceOptions()
    {
        return $this->PackageServiceOptions;
    }
    /**
     * Set PackageServiceOptions value
     * @param \Ups\upsshipStruct\UpsPackageServiceOptionsType $packageServiceOptions
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setPackageServiceOptions(\Ups\upsshipStruct\UpsPackageServiceOptionsType $packageServiceOptions = null)
    {
        $this->PackageServiceOptions = $packageServiceOptions;
        return $this;
    }
    /**
     * Get Commodity value
     * @return \Ups\upsshipStruct\UpsCommodityType|null
     */
    public function getCommodity()
    {
        return $this->Commodity;
    }
    /**
     * Set Commodity value
     * @param \Ups\upsshipStruct\UpsCommodityType $commodity
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setCommodity(\Ups\upsshipStruct\UpsCommodityType $commodity = null)
    {
        $this->Commodity = $commodity;
        return $this;
    }
    /**
     * Get HazMatPackageInformation value
     * @return \Ups\upsshipStruct\UpsHazMatPackageInformationType|null
     */
    public function getHazMatPackageInformation()
    {
        return $this->HazMatPackageInformation;
    }
    /**
     * Set HazMatPackageInformation value
     * @param \Ups\upsshipStruct\UpsHazMatPackageInformationType $hazMatPackageInformation
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setHazMatPackageInformation(\Ups\upsshipStruct\UpsHazMatPackageInformationType $hazMatPackageInformation = null)
    {
        $this->HazMatPackageInformation = $hazMatPackageInformation;
        return $this;
    }
    /**
     * Get SimpleRate value
     * @return \Ups\upsshipStruct\UpsCodeDescriptionType|null
     */
    public function getSimpleRate()
    {
        return $this->SimpleRate;
    }
    /**
     * Set SimpleRate value
     * @param \Ups\upsshipStruct\UpsCodeDescriptionType $simpleRate
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setSimpleRate(\Ups\upsshipStruct\UpsCodeDescriptionType $simpleRate = null)
    {
        $this->SimpleRate = $simpleRate;
        return $this;
    }
    /**
     * Get UPSPremier value
     * @return \Ups\upsshipStruct\UpsUPSPremierType|null
     */
    public function getUPSPremier()
    {
        return $this->UPSPremier;
    }
    /**
     * Set UPSPremier value
     * @param \Ups\upsshipStruct\UpsUPSPremierType $uPSPremier
     * @return \Ups\upsshipStruct\UpsPackageType
     */
    public function setUPSPremier(\Ups\upsshipStruct\UpsUPSPremierType $uPSPremier = null)
    {
        $this->UPSPremier = $uPSPremier;
        return $this;
    }
}
