<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSONotificationType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPSONotificationType extends AbstractStructBase
{
    /**
     * The NotificationCode
     * @var string
     */
    public $NotificationCode;
    /**
     * The EMail
     * @var \Ups\upsshipStruct\UpsEmailDetailsType
     */
    public $EMail;
    /**
     * Constructor method for PSONotificationType
     * @uses UpsPSONotificationType::setNotificationCode()
     * @uses UpsPSONotificationType::setEMail()
     * @param string $notificationCode
     * @param \Ups\upsshipStruct\UpsEmailDetailsType $eMail
     */
    public function __construct($notificationCode = null, \Ups\upsshipStruct\UpsEmailDetailsType $eMail = null)
    {
        $this
            ->setNotificationCode($notificationCode)
            ->setEMail($eMail);
    }
    /**
     * Get NotificationCode value
     * @return string|null
     */
    public function getNotificationCode()
    {
        return $this->NotificationCode;
    }
    /**
     * Set NotificationCode value
     * @param string $notificationCode
     * @return \Ups\upsshipStruct\UpsPSONotificationType
     */
    public function setNotificationCode($notificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($notificationCode) && !is_string($notificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationCode, true), gettype($notificationCode)), __LINE__);
        }
        $this->NotificationCode = $notificationCode;
        return $this;
    }
    /**
     * Get EMail value
     * @return \Ups\upsshipStruct\UpsEmailDetailsType|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param \Ups\upsshipStruct\UpsEmailDetailsType $eMail
     * @return \Ups\upsshipStruct\UpsPSONotificationType
     */
    public function setEMail(\Ups\upsshipStruct\UpsEmailDetailsType $eMail = null)
    {
        $this->EMail = $eMail;
        return $this;
    }
}
