<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternationalFormType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsInternationalFormType extends AbstractStructBase
{
    /**
     * The FormType
     * Meta information extracted from the WSDL
     * - maxOccurs: 6
     * @var string[]
     */
    public $FormType;
    /**
     * The UserCreatedForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsUserCreatedFormType
     */
    public $UserCreatedForm;
    /**
     * The CN22Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCN22FormType
     */
    public $CN22Form;
    /**
     * The UPSPremiumCareForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsUPSPremiumCareFormType
     */
    public $UPSPremiumCareForm;
    /**
     * The AdditionalDocumentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalDocumentIndicator;
    /**
     * The FormGroupIdName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormGroupIdName;
    /**
     * The SEDFilingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SEDFilingOption;
    /**
     * The EEIFilingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsEEIFilingOptionType
     */
    public $EEIFilingOption;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsContactType
     */
    public $Contacts;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 50
     * @var \Ups\upsshipStruct\UpsProductType[]
     */
    public $Product;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The PurchaseOrderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderNumber;
    /**
     * The TermsOfShipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TermsOfShipment;
    /**
     * The ReasonForExport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReasonForExport;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The DeclarationStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeclarationStatement;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsIFChargesType
     */
    public $Discount;
    /**
     * The FreightCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsIFChargesType
     */
    public $FreightCharges;
    /**
     * The InsuranceCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsIFChargesType
     */
    public $InsuranceCharges;
    /**
     * The OtherCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsOtherChargesType
     */
    public $OtherCharges;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The BlanketPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsBlanketPeriodType
     */
    public $BlanketPeriod;
    /**
     * The ExportDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportDate;
    /**
     * The ExportingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportingCarrier;
    /**
     * The CarrierID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CarrierID;
    /**
     * The InBondCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InBondCode;
    /**
     * The EntryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntryNumber;
    /**
     * The PointOfOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PointOfOrigin;
    /**
     * The PointOfOriginType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PointOfOriginType;
    /**
     * The ModeOfTransport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModeOfTransport;
    /**
     * The PortOfExport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PortOfExport;
    /**
     * The PortOfUnloading
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PortOfUnloading;
    /**
     * The LoadingPier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LoadingPier;
    /**
     * The PartiesToTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PartiesToTransaction;
    /**
     * The RoutedExportTransactionIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoutedExportTransactionIndicator;
    /**
     * The ContainerizedIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContainerizedIndicator;
    /**
     * The License
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsLicenseType
     */
    public $License;
    /**
     * The ECCNNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ECCNNumber;
    /**
     * The OverridePaperlessIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OverridePaperlessIndicator;
    /**
     * The ShipperMemo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperMemo;
    /**
     * The MultiCurrencyInvoiceLineTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MultiCurrencyInvoiceLineTotal;
    /**
     * The HazardousMaterialsIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HazardousMaterialsIndicator;
    /**
     * Constructor method for InternationalFormType
     * @uses UpsInternationalFormType::setFormType()
     * @uses UpsInternationalFormType::setUserCreatedForm()
     * @uses UpsInternationalFormType::setCN22Form()
     * @uses UpsInternationalFormType::setUPSPremiumCareForm()
     * @uses UpsInternationalFormType::setAdditionalDocumentIndicator()
     * @uses UpsInternationalFormType::setFormGroupIdName()
     * @uses UpsInternationalFormType::setSEDFilingOption()
     * @uses UpsInternationalFormType::setEEIFilingOption()
     * @uses UpsInternationalFormType::setContacts()
     * @uses UpsInternationalFormType::setProduct()
     * @uses UpsInternationalFormType::setInvoiceNumber()
     * @uses UpsInternationalFormType::setInvoiceDate()
     * @uses UpsInternationalFormType::setPurchaseOrderNumber()
     * @uses UpsInternationalFormType::setTermsOfShipment()
     * @uses UpsInternationalFormType::setReasonForExport()
     * @uses UpsInternationalFormType::setComments()
     * @uses UpsInternationalFormType::setDeclarationStatement()
     * @uses UpsInternationalFormType::setDiscount()
     * @uses UpsInternationalFormType::setFreightCharges()
     * @uses UpsInternationalFormType::setInsuranceCharges()
     * @uses UpsInternationalFormType::setOtherCharges()
     * @uses UpsInternationalFormType::setCurrencyCode()
     * @uses UpsInternationalFormType::setBlanketPeriod()
     * @uses UpsInternationalFormType::setExportDate()
     * @uses UpsInternationalFormType::setExportingCarrier()
     * @uses UpsInternationalFormType::setCarrierID()
     * @uses UpsInternationalFormType::setInBondCode()
     * @uses UpsInternationalFormType::setEntryNumber()
     * @uses UpsInternationalFormType::setPointOfOrigin()
     * @uses UpsInternationalFormType::setPointOfOriginType()
     * @uses UpsInternationalFormType::setModeOfTransport()
     * @uses UpsInternationalFormType::setPortOfExport()
     * @uses UpsInternationalFormType::setPortOfUnloading()
     * @uses UpsInternationalFormType::setLoadingPier()
     * @uses UpsInternationalFormType::setPartiesToTransaction()
     * @uses UpsInternationalFormType::setRoutedExportTransactionIndicator()
     * @uses UpsInternationalFormType::setContainerizedIndicator()
     * @uses UpsInternationalFormType::setLicense()
     * @uses UpsInternationalFormType::setECCNNumber()
     * @uses UpsInternationalFormType::setOverridePaperlessIndicator()
     * @uses UpsInternationalFormType::setShipperMemo()
     * @uses UpsInternationalFormType::setMultiCurrencyInvoiceLineTotal()
     * @uses UpsInternationalFormType::setHazardousMaterialsIndicator()
     * @param string[] $formType
     * @param \Ups\upsshipStruct\UpsUserCreatedFormType $userCreatedForm
     * @param \Ups\upsshipStruct\UpsCN22FormType $cN22Form
     * @param \Ups\upsshipStruct\UpsUPSPremiumCareFormType $uPSPremiumCareForm
     * @param string $additionalDocumentIndicator
     * @param string $formGroupIdName
     * @param string $sEDFilingOption
     * @param \Ups\upsshipStruct\UpsEEIFilingOptionType $eEIFilingOption
     * @param \Ups\upsshipStruct\UpsContactType $contacts
     * @param \Ups\upsshipStruct\UpsProductType[] $product
     * @param string $invoiceNumber
     * @param string $invoiceDate
     * @param string $purchaseOrderNumber
     * @param string $termsOfShipment
     * @param string $reasonForExport
     * @param string $comments
     * @param string $declarationStatement
     * @param \Ups\upsshipStruct\UpsIFChargesType $discount
     * @param \Ups\upsshipStruct\UpsIFChargesType $freightCharges
     * @param \Ups\upsshipStruct\UpsIFChargesType $insuranceCharges
     * @param \Ups\upsshipStruct\UpsOtherChargesType $otherCharges
     * @param string $currencyCode
     * @param \Ups\upsshipStruct\UpsBlanketPeriodType $blanketPeriod
     * @param string $exportDate
     * @param string $exportingCarrier
     * @param string $carrierID
     * @param string $inBondCode
     * @param string $entryNumber
     * @param string $pointOfOrigin
     * @param string $pointOfOriginType
     * @param string $modeOfTransport
     * @param string $portOfExport
     * @param string $portOfUnloading
     * @param string $loadingPier
     * @param string $partiesToTransaction
     * @param string $routedExportTransactionIndicator
     * @param string $containerizedIndicator
     * @param \Ups\upsshipStruct\UpsLicenseType $license
     * @param string $eCCNNumber
     * @param string $overridePaperlessIndicator
     * @param string $shipperMemo
     * @param string $multiCurrencyInvoiceLineTotal
     * @param string $hazardousMaterialsIndicator
     */
    public function __construct(array $formType = array(), \Ups\upsshipStruct\UpsUserCreatedFormType $userCreatedForm = null, \Ups\upsshipStruct\UpsCN22FormType $cN22Form = null, \Ups\upsshipStruct\UpsUPSPremiumCareFormType $uPSPremiumCareForm = null, $additionalDocumentIndicator = null, $formGroupIdName = null, $sEDFilingOption = null, \Ups\upsshipStruct\UpsEEIFilingOptionType $eEIFilingOption = null, \Ups\upsshipStruct\UpsContactType $contacts = null, array $product = array(), $invoiceNumber = null, $invoiceDate = null, $purchaseOrderNumber = null, $termsOfShipment = null, $reasonForExport = null, $comments = null, $declarationStatement = null, \Ups\upsshipStruct\UpsIFChargesType $discount = null, \Ups\upsshipStruct\UpsIFChargesType $freightCharges = null, \Ups\upsshipStruct\UpsIFChargesType $insuranceCharges = null, \Ups\upsshipStruct\UpsOtherChargesType $otherCharges = null, $currencyCode = null, \Ups\upsshipStruct\UpsBlanketPeriodType $blanketPeriod = null, $exportDate = null, $exportingCarrier = null, $carrierID = null, $inBondCode = null, $entryNumber = null, $pointOfOrigin = null, $pointOfOriginType = null, $modeOfTransport = null, $portOfExport = null, $portOfUnloading = null, $loadingPier = null, $partiesToTransaction = null, $routedExportTransactionIndicator = null, $containerizedIndicator = null, \Ups\upsshipStruct\UpsLicenseType $license = null, $eCCNNumber = null, $overridePaperlessIndicator = null, $shipperMemo = null, $multiCurrencyInvoiceLineTotal = null, $hazardousMaterialsIndicator = null)
    {
        $this
            ->setFormType($formType)
            ->setUserCreatedForm($userCreatedForm)
            ->setCN22Form($cN22Form)
            ->setUPSPremiumCareForm($uPSPremiumCareForm)
            ->setAdditionalDocumentIndicator($additionalDocumentIndicator)
            ->setFormGroupIdName($formGroupIdName)
            ->setSEDFilingOption($sEDFilingOption)
            ->setEEIFilingOption($eEIFilingOption)
            ->setContacts($contacts)
            ->setProduct($product)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate)
            ->setPurchaseOrderNumber($purchaseOrderNumber)
            ->setTermsOfShipment($termsOfShipment)
            ->setReasonForExport($reasonForExport)
            ->setComments($comments)
            ->setDeclarationStatement($declarationStatement)
            ->setDiscount($discount)
            ->setFreightCharges($freightCharges)
            ->setInsuranceCharges($insuranceCharges)
            ->setOtherCharges($otherCharges)
            ->setCurrencyCode($currencyCode)
            ->setBlanketPeriod($blanketPeriod)
            ->setExportDate($exportDate)
            ->setExportingCarrier($exportingCarrier)
            ->setCarrierID($carrierID)
            ->setInBondCode($inBondCode)
            ->setEntryNumber($entryNumber)
            ->setPointOfOrigin($pointOfOrigin)
            ->setPointOfOriginType($pointOfOriginType)
            ->setModeOfTransport($modeOfTransport)
            ->setPortOfExport($portOfExport)
            ->setPortOfUnloading($portOfUnloading)
            ->setLoadingPier($loadingPier)
            ->setPartiesToTransaction($partiesToTransaction)
            ->setRoutedExportTransactionIndicator($routedExportTransactionIndicator)
            ->setContainerizedIndicator($containerizedIndicator)
            ->setLicense($license)
            ->setECCNNumber($eCCNNumber)
            ->setOverridePaperlessIndicator($overridePaperlessIndicator)
            ->setShipperMemo($shipperMemo)
            ->setMultiCurrencyInvoiceLineTotal($multiCurrencyInvoiceLineTotal)
            ->setHazardousMaterialsIndicator($hazardousMaterialsIndicator);
    }
    /**
     * Get FormType value
     * @return string[]|null
     */
    public function getFormType()
    {
        return $this->FormType;
    }
    /**
     * This method is responsible for validating the values passed to the setFormType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFormType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormTypeForArrayConstraintsFromSetFormType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internationalFormTypeFormTypeItem) {
            // validation for constraint: itemType
            if (!is_string($internationalFormTypeFormTypeItem)) {
                $invalidValues[] = is_object($internationalFormTypeFormTypeItem) ? get_class($internationalFormTypeFormTypeItem) : sprintf('%s(%s)', gettype($internationalFormTypeFormTypeItem), var_export($internationalFormTypeFormTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FormType property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FormType value
     * @throws \InvalidArgumentException
     * @param string[] $formType
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setFormType(array $formType = array())
    {
        // validation for constraint: array
        if ('' !== ($formTypeArrayErrorMessage = self::validateFormTypeForArrayConstraintsFromSetFormType($formType))) {
            throw new \InvalidArgumentException($formTypeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(6)
        if (is_array($formType) && count($formType) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 6', count($formType)), __LINE__);
        }
        $this->FormType = $formType;
        return $this;
    }
    /**
     * Add item to FormType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function addToFormType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FormType property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(6)
        if (is_array($this->FormType) && count($this->FormType) >= 6) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 6', count($this->FormType)), __LINE__);
        }
        $this->FormType[] = $item;
        return $this;
    }
    /**
     * Get UserCreatedForm value
     * @return \Ups\upsshipStruct\UpsUserCreatedFormType|null
     */
    public function getUserCreatedForm()
    {
        return $this->UserCreatedForm;
    }
    /**
     * Set UserCreatedForm value
     * @param \Ups\upsshipStruct\UpsUserCreatedFormType $userCreatedForm
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setUserCreatedForm(\Ups\upsshipStruct\UpsUserCreatedFormType $userCreatedForm = null)
    {
        $this->UserCreatedForm = $userCreatedForm;
        return $this;
    }
    /**
     * Get CN22Form value
     * @return \Ups\upsshipStruct\UpsCN22FormType|null
     */
    public function getCN22Form()
    {
        return $this->CN22Form;
    }
    /**
     * Set CN22Form value
     * @param \Ups\upsshipStruct\UpsCN22FormType $cN22Form
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setCN22Form(\Ups\upsshipStruct\UpsCN22FormType $cN22Form = null)
    {
        $this->CN22Form = $cN22Form;
        return $this;
    }
    /**
     * Get UPSPremiumCareForm value
     * @return \Ups\upsshipStruct\UpsUPSPremiumCareFormType|null
     */
    public function getUPSPremiumCareForm()
    {
        return $this->UPSPremiumCareForm;
    }
    /**
     * Set UPSPremiumCareForm value
     * @param \Ups\upsshipStruct\UpsUPSPremiumCareFormType $uPSPremiumCareForm
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setUPSPremiumCareForm(\Ups\upsshipStruct\UpsUPSPremiumCareFormType $uPSPremiumCareForm = null)
    {
        $this->UPSPremiumCareForm = $uPSPremiumCareForm;
        return $this;
    }
    /**
     * Get AdditionalDocumentIndicator value
     * @return string|null
     */
    public function getAdditionalDocumentIndicator()
    {
        return $this->AdditionalDocumentIndicator;
    }
    /**
     * Set AdditionalDocumentIndicator value
     * @param string $additionalDocumentIndicator
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setAdditionalDocumentIndicator($additionalDocumentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDocumentIndicator) && !is_string($additionalDocumentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDocumentIndicator, true), gettype($additionalDocumentIndicator)), __LINE__);
        }
        $this->AdditionalDocumentIndicator = $additionalDocumentIndicator;
        return $this;
    }
    /**
     * Get FormGroupIdName value
     * @return string|null
     */
    public function getFormGroupIdName()
    {
        return $this->FormGroupIdName;
    }
    /**
     * Set FormGroupIdName value
     * @param string $formGroupIdName
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setFormGroupIdName($formGroupIdName = null)
    {
        // validation for constraint: string
        if (!is_null($formGroupIdName) && !is_string($formGroupIdName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formGroupIdName, true), gettype($formGroupIdName)), __LINE__);
        }
        $this->FormGroupIdName = $formGroupIdName;
        return $this;
    }
    /**
     * Get SEDFilingOption value
     * @return string|null
     */
    public function getSEDFilingOption()
    {
        return $this->SEDFilingOption;
    }
    /**
     * Set SEDFilingOption value
     * @param string $sEDFilingOption
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setSEDFilingOption($sEDFilingOption = null)
    {
        // validation for constraint: string
        if (!is_null($sEDFilingOption) && !is_string($sEDFilingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEDFilingOption, true), gettype($sEDFilingOption)), __LINE__);
        }
        $this->SEDFilingOption = $sEDFilingOption;
        return $this;
    }
    /**
     * Get EEIFilingOption value
     * @return \Ups\upsshipStruct\UpsEEIFilingOptionType|null
     */
    public function getEEIFilingOption()
    {
        return $this->EEIFilingOption;
    }
    /**
     * Set EEIFilingOption value
     * @param \Ups\upsshipStruct\UpsEEIFilingOptionType $eEIFilingOption
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setEEIFilingOption(\Ups\upsshipStruct\UpsEEIFilingOptionType $eEIFilingOption = null)
    {
        $this->EEIFilingOption = $eEIFilingOption;
        return $this;
    }
    /**
     * Get Contacts value
     * @return \Ups\upsshipStruct\UpsContactType|null
     */
    public function getContacts()
    {
        return $this->Contacts;
    }
    /**
     * Set Contacts value
     * @param \Ups\upsshipStruct\UpsContactType $contacts
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setContacts(\Ups\upsshipStruct\UpsContactType $contacts = null)
    {
        $this->Contacts = $contacts;
        return $this;
    }
    /**
     * Get Product value
     * @return \Ups\upsshipStruct\UpsProductType[]|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * This method is responsible for validating the values passed to the setProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductForArrayConstraintsFromSetProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internationalFormTypeProductItem) {
            // validation for constraint: itemType
            if (!$internationalFormTypeProductItem instanceof \Ups\upsshipStruct\UpsProductType) {
                $invalidValues[] = is_object($internationalFormTypeProductItem) ? get_class($internationalFormTypeProductItem) : sprintf('%s(%s)', gettype($internationalFormTypeProductItem), var_export($internationalFormTypeProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Product property can only contain items of type \Ups\upsshipStruct\UpsProductType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Product value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsProductType[] $product
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setProduct(array $product = array())
    {
        // validation for constraint: array
        if ('' !== ($productArrayErrorMessage = self::validateProductForArrayConstraintsFromSetProduct($product))) {
            throw new \InvalidArgumentException($productArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($product) && count($product) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($product)), __LINE__);
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Add item to Product value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsProductType $item
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function addToProduct(\Ups\upsshipStruct\UpsProductType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsProductType) {
            throw new \InvalidArgumentException(sprintf('The Product property can only contain items of type \Ups\upsshipStruct\UpsProductType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->Product) && count($this->Product) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->Product)), __LINE__);
        }
        $this->Product[] = $item;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get PurchaseOrderNumber value
     * @return string|null
     */
    public function getPurchaseOrderNumber()
    {
        return $this->PurchaseOrderNumber;
    }
    /**
     * Set PurchaseOrderNumber value
     * @param string $purchaseOrderNumber
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderNumber) && !is_string($purchaseOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderNumber, true), gettype($purchaseOrderNumber)), __LINE__);
        }
        $this->PurchaseOrderNumber = $purchaseOrderNumber;
        return $this;
    }
    /**
     * Get TermsOfShipment value
     * @return string|null
     */
    public function getTermsOfShipment()
    {
        return $this->TermsOfShipment;
    }
    /**
     * Set TermsOfShipment value
     * @param string $termsOfShipment
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setTermsOfShipment($termsOfShipment = null)
    {
        // validation for constraint: string
        if (!is_null($termsOfShipment) && !is_string($termsOfShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsOfShipment, true), gettype($termsOfShipment)), __LINE__);
        }
        $this->TermsOfShipment = $termsOfShipment;
        return $this;
    }
    /**
     * Get ReasonForExport value
     * @return string|null
     */
    public function getReasonForExport()
    {
        return $this->ReasonForExport;
    }
    /**
     * Set ReasonForExport value
     * @param string $reasonForExport
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setReasonForExport($reasonForExport = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForExport) && !is_string($reasonForExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForExport, true), gettype($reasonForExport)), __LINE__);
        }
        $this->ReasonForExport = $reasonForExport;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get DeclarationStatement value
     * @return string|null
     */
    public function getDeclarationStatement()
    {
        return $this->DeclarationStatement;
    }
    /**
     * Set DeclarationStatement value
     * @param string $declarationStatement
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setDeclarationStatement($declarationStatement = null)
    {
        // validation for constraint: string
        if (!is_null($declarationStatement) && !is_string($declarationStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declarationStatement, true), gettype($declarationStatement)), __LINE__);
        }
        $this->DeclarationStatement = $declarationStatement;
        return $this;
    }
    /**
     * Get Discount value
     * @return \Ups\upsshipStruct\UpsIFChargesType|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \Ups\upsshipStruct\UpsIFChargesType $discount
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setDiscount(\Ups\upsshipStruct\UpsIFChargesType $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get FreightCharges value
     * @return \Ups\upsshipStruct\UpsIFChargesType|null
     */
    public function getFreightCharges()
    {
        return $this->FreightCharges;
    }
    /**
     * Set FreightCharges value
     * @param \Ups\upsshipStruct\UpsIFChargesType $freightCharges
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setFreightCharges(\Ups\upsshipStruct\UpsIFChargesType $freightCharges = null)
    {
        $this->FreightCharges = $freightCharges;
        return $this;
    }
    /**
     * Get InsuranceCharges value
     * @return \Ups\upsshipStruct\UpsIFChargesType|null
     */
    public function getInsuranceCharges()
    {
        return $this->InsuranceCharges;
    }
    /**
     * Set InsuranceCharges value
     * @param \Ups\upsshipStruct\UpsIFChargesType $insuranceCharges
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setInsuranceCharges(\Ups\upsshipStruct\UpsIFChargesType $insuranceCharges = null)
    {
        $this->InsuranceCharges = $insuranceCharges;
        return $this;
    }
    /**
     * Get OtherCharges value
     * @return \Ups\upsshipStruct\UpsOtherChargesType|null
     */
    public function getOtherCharges()
    {
        return $this->OtherCharges;
    }
    /**
     * Set OtherCharges value
     * @param \Ups\upsshipStruct\UpsOtherChargesType $otherCharges
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setOtherCharges(\Ups\upsshipStruct\UpsOtherChargesType $otherCharges = null)
    {
        $this->OtherCharges = $otherCharges;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get BlanketPeriod value
     * @return \Ups\upsshipStruct\UpsBlanketPeriodType|null
     */
    public function getBlanketPeriod()
    {
        return $this->BlanketPeriod;
    }
    /**
     * Set BlanketPeriod value
     * @param \Ups\upsshipStruct\UpsBlanketPeriodType $blanketPeriod
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setBlanketPeriod(\Ups\upsshipStruct\UpsBlanketPeriodType $blanketPeriod = null)
    {
        $this->BlanketPeriod = $blanketPeriod;
        return $this;
    }
    /**
     * Get ExportDate value
     * @return string|null
     */
    public function getExportDate()
    {
        return $this->ExportDate;
    }
    /**
     * Set ExportDate value
     * @param string $exportDate
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setExportDate($exportDate = null)
    {
        // validation for constraint: string
        if (!is_null($exportDate) && !is_string($exportDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportDate, true), gettype($exportDate)), __LINE__);
        }
        $this->ExportDate = $exportDate;
        return $this;
    }
    /**
     * Get ExportingCarrier value
     * @return string|null
     */
    public function getExportingCarrier()
    {
        return $this->ExportingCarrier;
    }
    /**
     * Set ExportingCarrier value
     * @param string $exportingCarrier
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setExportingCarrier($exportingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($exportingCarrier) && !is_string($exportingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportingCarrier, true), gettype($exportingCarrier)), __LINE__);
        }
        $this->ExportingCarrier = $exportingCarrier;
        return $this;
    }
    /**
     * Get CarrierID value
     * @return string|null
     */
    public function getCarrierID()
    {
        return $this->CarrierID;
    }
    /**
     * Set CarrierID value
     * @param string $carrierID
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setCarrierID($carrierID = null)
    {
        // validation for constraint: string
        if (!is_null($carrierID) && !is_string($carrierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierID, true), gettype($carrierID)), __LINE__);
        }
        $this->CarrierID = $carrierID;
        return $this;
    }
    /**
     * Get InBondCode value
     * @return string|null
     */
    public function getInBondCode()
    {
        return $this->InBondCode;
    }
    /**
     * Set InBondCode value
     * @param string $inBondCode
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setInBondCode($inBondCode = null)
    {
        // validation for constraint: string
        if (!is_null($inBondCode) && !is_string($inBondCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inBondCode, true), gettype($inBondCode)), __LINE__);
        }
        $this->InBondCode = $inBondCode;
        return $this;
    }
    /**
     * Get EntryNumber value
     * @return string|null
     */
    public function getEntryNumber()
    {
        return $this->EntryNumber;
    }
    /**
     * Set EntryNumber value
     * @param string $entryNumber
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setEntryNumber($entryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($entryNumber) && !is_string($entryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryNumber, true), gettype($entryNumber)), __LINE__);
        }
        $this->EntryNumber = $entryNumber;
        return $this;
    }
    /**
     * Get PointOfOrigin value
     * @return string|null
     */
    public function getPointOfOrigin()
    {
        return $this->PointOfOrigin;
    }
    /**
     * Set PointOfOrigin value
     * @param string $pointOfOrigin
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setPointOfOrigin($pointOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($pointOfOrigin) && !is_string($pointOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointOfOrigin, true), gettype($pointOfOrigin)), __LINE__);
        }
        $this->PointOfOrigin = $pointOfOrigin;
        return $this;
    }
    /**
     * Get PointOfOriginType value
     * @return string|null
     */
    public function getPointOfOriginType()
    {
        return $this->PointOfOriginType;
    }
    /**
     * Set PointOfOriginType value
     * @param string $pointOfOriginType
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setPointOfOriginType($pointOfOriginType = null)
    {
        // validation for constraint: string
        if (!is_null($pointOfOriginType) && !is_string($pointOfOriginType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointOfOriginType, true), gettype($pointOfOriginType)), __LINE__);
        }
        $this->PointOfOriginType = $pointOfOriginType;
        return $this;
    }
    /**
     * Get ModeOfTransport value
     * @return string|null
     */
    public function getModeOfTransport()
    {
        return $this->ModeOfTransport;
    }
    /**
     * Set ModeOfTransport value
     * @param string $modeOfTransport
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setModeOfTransport($modeOfTransport = null)
    {
        // validation for constraint: string
        if (!is_null($modeOfTransport) && !is_string($modeOfTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeOfTransport, true), gettype($modeOfTransport)), __LINE__);
        }
        $this->ModeOfTransport = $modeOfTransport;
        return $this;
    }
    /**
     * Get PortOfExport value
     * @return string|null
     */
    public function getPortOfExport()
    {
        return $this->PortOfExport;
    }
    /**
     * Set PortOfExport value
     * @param string $portOfExport
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setPortOfExport($portOfExport = null)
    {
        // validation for constraint: string
        if (!is_null($portOfExport) && !is_string($portOfExport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portOfExport, true), gettype($portOfExport)), __LINE__);
        }
        $this->PortOfExport = $portOfExport;
        return $this;
    }
    /**
     * Get PortOfUnloading value
     * @return string|null
     */
    public function getPortOfUnloading()
    {
        return $this->PortOfUnloading;
    }
    /**
     * Set PortOfUnloading value
     * @param string $portOfUnloading
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setPortOfUnloading($portOfUnloading = null)
    {
        // validation for constraint: string
        if (!is_null($portOfUnloading) && !is_string($portOfUnloading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portOfUnloading, true), gettype($portOfUnloading)), __LINE__);
        }
        $this->PortOfUnloading = $portOfUnloading;
        return $this;
    }
    /**
     * Get LoadingPier value
     * @return string|null
     */
    public function getLoadingPier()
    {
        return $this->LoadingPier;
    }
    /**
     * Set LoadingPier value
     * @param string $loadingPier
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setLoadingPier($loadingPier = null)
    {
        // validation for constraint: string
        if (!is_null($loadingPier) && !is_string($loadingPier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadingPier, true), gettype($loadingPier)), __LINE__);
        }
        $this->LoadingPier = $loadingPier;
        return $this;
    }
    /**
     * Get PartiesToTransaction value
     * @return string|null
     */
    public function getPartiesToTransaction()
    {
        return $this->PartiesToTransaction;
    }
    /**
     * Set PartiesToTransaction value
     * @param string $partiesToTransaction
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setPartiesToTransaction($partiesToTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($partiesToTransaction) && !is_string($partiesToTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partiesToTransaction, true), gettype($partiesToTransaction)), __LINE__);
        }
        $this->PartiesToTransaction = $partiesToTransaction;
        return $this;
    }
    /**
     * Get RoutedExportTransactionIndicator value
     * @return string|null
     */
    public function getRoutedExportTransactionIndicator()
    {
        return $this->RoutedExportTransactionIndicator;
    }
    /**
     * Set RoutedExportTransactionIndicator value
     * @param string $routedExportTransactionIndicator
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setRoutedExportTransactionIndicator($routedExportTransactionIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($routedExportTransactionIndicator) && !is_string($routedExportTransactionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routedExportTransactionIndicator, true), gettype($routedExportTransactionIndicator)), __LINE__);
        }
        $this->RoutedExportTransactionIndicator = $routedExportTransactionIndicator;
        return $this;
    }
    /**
     * Get ContainerizedIndicator value
     * @return string|null
     */
    public function getContainerizedIndicator()
    {
        return $this->ContainerizedIndicator;
    }
    /**
     * Set ContainerizedIndicator value
     * @param string $containerizedIndicator
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setContainerizedIndicator($containerizedIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($containerizedIndicator) && !is_string($containerizedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerizedIndicator, true), gettype($containerizedIndicator)), __LINE__);
        }
        $this->ContainerizedIndicator = $containerizedIndicator;
        return $this;
    }
    /**
     * Get License value
     * @return \Ups\upsshipStruct\UpsLicenseType|null
     */
    public function getLicense()
    {
        return $this->License;
    }
    /**
     * Set License value
     * @param \Ups\upsshipStruct\UpsLicenseType $license
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setLicense(\Ups\upsshipStruct\UpsLicenseType $license = null)
    {
        $this->License = $license;
        return $this;
    }
    /**
     * Get ECCNNumber value
     * @return string|null
     */
    public function getECCNNumber()
    {
        return $this->ECCNNumber;
    }
    /**
     * Set ECCNNumber value
     * @param string $eCCNNumber
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setECCNNumber($eCCNNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eCCNNumber) && !is_string($eCCNNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCCNNumber, true), gettype($eCCNNumber)), __LINE__);
        }
        $this->ECCNNumber = $eCCNNumber;
        return $this;
    }
    /**
     * Get OverridePaperlessIndicator value
     * @return string|null
     */
    public function getOverridePaperlessIndicator()
    {
        return $this->OverridePaperlessIndicator;
    }
    /**
     * Set OverridePaperlessIndicator value
     * @param string $overridePaperlessIndicator
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setOverridePaperlessIndicator($overridePaperlessIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($overridePaperlessIndicator) && !is_string($overridePaperlessIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overridePaperlessIndicator, true), gettype($overridePaperlessIndicator)), __LINE__);
        }
        $this->OverridePaperlessIndicator = $overridePaperlessIndicator;
        return $this;
    }
    /**
     * Get ShipperMemo value
     * @return string|null
     */
    public function getShipperMemo()
    {
        return $this->ShipperMemo;
    }
    /**
     * Set ShipperMemo value
     * @param string $shipperMemo
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setShipperMemo($shipperMemo = null)
    {
        // validation for constraint: string
        if (!is_null($shipperMemo) && !is_string($shipperMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperMemo, true), gettype($shipperMemo)), __LINE__);
        }
        $this->ShipperMemo = $shipperMemo;
        return $this;
    }
    /**
     * Get MultiCurrencyInvoiceLineTotal value
     * @return string|null
     */
    public function getMultiCurrencyInvoiceLineTotal()
    {
        return $this->MultiCurrencyInvoiceLineTotal;
    }
    /**
     * Set MultiCurrencyInvoiceLineTotal value
     * @param string $multiCurrencyInvoiceLineTotal
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setMultiCurrencyInvoiceLineTotal($multiCurrencyInvoiceLineTotal = null)
    {
        // validation for constraint: string
        if (!is_null($multiCurrencyInvoiceLineTotal) && !is_string($multiCurrencyInvoiceLineTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multiCurrencyInvoiceLineTotal, true), gettype($multiCurrencyInvoiceLineTotal)), __LINE__);
        }
        $this->MultiCurrencyInvoiceLineTotal = $multiCurrencyInvoiceLineTotal;
        return $this;
    }
    /**
     * Get HazardousMaterialsIndicator value
     * @return string|null
     */
    public function getHazardousMaterialsIndicator()
    {
        return $this->HazardousMaterialsIndicator;
    }
    /**
     * Set HazardousMaterialsIndicator value
     * @param string $hazardousMaterialsIndicator
     * @return \Ups\upsshipStruct\UpsInternationalFormType
     */
    public function setHazardousMaterialsIndicator($hazardousMaterialsIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($hazardousMaterialsIndicator) && !is_string($hazardousMaterialsIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hazardousMaterialsIndicator, true), gettype($hazardousMaterialsIndicator)), __LINE__);
        }
        $this->HazardousMaterialsIndicator = $hazardousMaterialsIndicator;
        return $this;
    }
}
