<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForwardAgentType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsForwardAgentType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The TaxIdentificationNumber
     * @var string
     */
    public $TaxIdentificationNumber;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsAddressType
     */
    public $Address;
    /**
     * Constructor method for ForwardAgentType
     * @uses UpsForwardAgentType::setCompanyName()
     * @uses UpsForwardAgentType::setTaxIdentificationNumber()
     * @uses UpsForwardAgentType::setAddress()
     * @param string $companyName
     * @param string $taxIdentificationNumber
     * @param \Ups\upsshipStruct\UpsAddressType $address
     */
    public function __construct($companyName = null, $taxIdentificationNumber = null, \Ups\upsshipStruct\UpsAddressType $address = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setTaxIdentificationNumber($taxIdentificationNumber)
            ->setAddress($address);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \Ups\upsshipStruct\UpsForwardAgentType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get TaxIdentificationNumber value
     * @return string|null
     */
    public function getTaxIdentificationNumber()
    {
        return $this->TaxIdentificationNumber;
    }
    /**
     * Set TaxIdentificationNumber value
     * @param string $taxIdentificationNumber
     * @return \Ups\upsshipStruct\UpsForwardAgentType
     */
    public function setTaxIdentificationNumber($taxIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentificationNumber) && !is_string($taxIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdentificationNumber, true), gettype($taxIdentificationNumber)), __LINE__);
        }
        $this->TaxIdentificationNumber = $taxIdentificationNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsAddressType $address
     * @return \Ups\upsshipStruct\UpsForwardAgentType
     */
    public function setAddress(\Ups\upsshipStruct\UpsAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
