<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EEIInformationType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsEEIInformationType extends AbstractStructBase
{
    /**
     * The ExportInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportInformation;
    /**
     * The License
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsEEILicenseType
     */
    public $License;
    /**
     * The DDTCInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsDDTCInformationType
     */
    public $DDTCInformation;
    /**
     * Constructor method for EEIInformationType
     * @uses UpsEEIInformationType::setExportInformation()
     * @uses UpsEEIInformationType::setLicense()
     * @uses UpsEEIInformationType::setDDTCInformation()
     * @param string $exportInformation
     * @param \Ups\upsshipStruct\UpsEEILicenseType $license
     * @param \Ups\upsshipStruct\UpsDDTCInformationType $dDTCInformation
     */
    public function __construct($exportInformation = null, \Ups\upsshipStruct\UpsEEILicenseType $license = null, \Ups\upsshipStruct\UpsDDTCInformationType $dDTCInformation = null)
    {
        $this
            ->setExportInformation($exportInformation)
            ->setLicense($license)
            ->setDDTCInformation($dDTCInformation);
    }
    /**
     * Get ExportInformation value
     * @return string|null
     */
    public function getExportInformation()
    {
        return $this->ExportInformation;
    }
    /**
     * Set ExportInformation value
     * @param string $exportInformation
     * @return \Ups\upsshipStruct\UpsEEIInformationType
     */
    public function setExportInformation($exportInformation = null)
    {
        // validation for constraint: string
        if (!is_null($exportInformation) && !is_string($exportInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportInformation, true), gettype($exportInformation)), __LINE__);
        }
        $this->ExportInformation = $exportInformation;
        return $this;
    }
    /**
     * Get License value
     * @return \Ups\upsshipStruct\UpsEEILicenseType|null
     */
    public function getLicense()
    {
        return $this->License;
    }
    /**
     * Set License value
     * @param \Ups\upsshipStruct\UpsEEILicenseType $license
     * @return \Ups\upsshipStruct\UpsEEIInformationType
     */
    public function setLicense(\Ups\upsshipStruct\UpsEEILicenseType $license = null)
    {
        $this->License = $license;
        return $this;
    }
    /**
     * Get DDTCInformation value
     * @return \Ups\upsshipStruct\UpsDDTCInformationType|null
     */
    public function getDDTCInformation()
    {
        return $this->DDTCInformation;
    }
    /**
     * Set DDTCInformation value
     * @param \Ups\upsshipStruct\UpsDDTCInformationType $dDTCInformation
     * @return \Ups\upsshipStruct\UpsEEIInformationType
     */
    public function setDDTCInformation(\Ups\upsshipStruct\UpsDDTCInformationType $dDTCInformation = null)
    {
        $this->DDTCInformation = $dDTCInformation;
        return $this;
    }
}
