<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingWeightType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsBillingWeightType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \Ups\upsshipStruct\UpsBillingUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for BillingWeightType
     * @uses UpsBillingWeightType::setUnitOfMeasurement()
     * @uses UpsBillingWeightType::setWeight()
     * @param \Ups\upsshipStruct\UpsBillingUnitOfMeasurementType $unitOfMeasurement
     * @param string $weight
     */
    public function __construct(\Ups\upsshipStruct\UpsBillingUnitOfMeasurementType $unitOfMeasurement = null, $weight = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setWeight($weight);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \Ups\upsshipStruct\UpsBillingUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \Ups\upsshipStruct\UpsBillingUnitOfMeasurementType $unitOfMeasurement
     * @return \Ups\upsshipStruct\UpsBillingWeightType
     */
    public function setUnitOfMeasurement(\Ups\upsshipStruct\UpsBillingUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Ups\upsshipStruct\UpsBillingWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
