<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationChargeType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsTransportationChargeType extends AbstractStructBase
{
    /**
     * The GrossCharge
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $GrossCharge;
    /**
     * The DiscountAmount
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $DiscountAmount;
    /**
     * The DiscountPercentage
     * @var string
     */
    public $DiscountPercentage;
    /**
     * The NetCharge
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $NetCharge;
    /**
     * Constructor method for TransportationChargeType
     * @uses UpsTransportationChargeType::setGrossCharge()
     * @uses UpsTransportationChargeType::setDiscountAmount()
     * @uses UpsTransportationChargeType::setDiscountPercentage()
     * @uses UpsTransportationChargeType::setNetCharge()
     * @param \Ups\upsshipStruct\UpsShipChargeType $grossCharge
     * @param \Ups\upsshipStruct\UpsShipChargeType $discountAmount
     * @param string $discountPercentage
     * @param \Ups\upsshipStruct\UpsShipChargeType $netCharge
     */
    public function __construct(\Ups\upsshipStruct\UpsShipChargeType $grossCharge = null, \Ups\upsshipStruct\UpsShipChargeType $discountAmount = null, $discountPercentage = null, \Ups\upsshipStruct\UpsShipChargeType $netCharge = null)
    {
        $this
            ->setGrossCharge($grossCharge)
            ->setDiscountAmount($discountAmount)
            ->setDiscountPercentage($discountPercentage)
            ->setNetCharge($netCharge);
    }
    /**
     * Get GrossCharge value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getGrossCharge()
    {
        return $this->GrossCharge;
    }
    /**
     * Set GrossCharge value
     * @param \Ups\upsshipStruct\UpsShipChargeType $grossCharge
     * @return \Ups\upsshipStruct\UpsTransportationChargeType
     */
    public function setGrossCharge(\Ups\upsshipStruct\UpsShipChargeType $grossCharge = null)
    {
        $this->GrossCharge = $grossCharge;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param \Ups\upsshipStruct\UpsShipChargeType $discountAmount
     * @return \Ups\upsshipStruct\UpsTransportationChargeType
     */
    public function setDiscountAmount(\Ups\upsshipStruct\UpsShipChargeType $discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountPercentage value
     * @return string|null
     */
    public function getDiscountPercentage()
    {
        return $this->DiscountPercentage;
    }
    /**
     * Set DiscountPercentage value
     * @param string $discountPercentage
     * @return \Ups\upsshipStruct\UpsTransportationChargeType
     */
    public function setDiscountPercentage($discountPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($discountPercentage) && !is_string($discountPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountPercentage, true), gettype($discountPercentage)), __LINE__);
        }
        $this->DiscountPercentage = $discountPercentage;
        return $this;
    }
    /**
     * Get NetCharge value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getNetCharge()
    {
        return $this->NetCharge;
    }
    /**
     * Set NetCharge value
     * @param \Ups\upsshipStruct\UpsShipChargeType $netCharge
     * @return \Ups\upsshipStruct\UpsTransportationChargeType
     */
    public function setNetCharge(\Ups\upsshipStruct\UpsShipChargeType $netCharge = null)
    {
        $this->NetCharge = $netCharge;
        return $this;
    }
}
