<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipperType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipperType extends UpsCompanyInfoType
{
    /**
     * The ShipperNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperNumber;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsShipAddressType
     */
    public $Address;
    /**
     * Constructor method for ShipperType
     * @uses UpsShipperType::setShipperNumber()
     * @uses UpsShipperType::setFaxNumber()
     * @uses UpsShipperType::setEMailAddress()
     * @uses UpsShipperType::setAddress()
     * @param string $shipperNumber
     * @param string $faxNumber
     * @param string $eMailAddress
     * @param \Ups\upsshipStruct\UpsShipAddressType $address
     */
    public function __construct($shipperNumber = null, $faxNumber = null, $eMailAddress = null, \Ups\upsshipStruct\UpsShipAddressType $address = null)
    {
        $this
            ->setShipperNumber($shipperNumber)
            ->setFaxNumber($faxNumber)
            ->setEMailAddress($eMailAddress)
            ->setAddress($address);
    }
    /**
     * Get ShipperNumber value
     * @return string|null
     */
    public function getShipperNumber()
    {
        return $this->ShipperNumber;
    }
    /**
     * Set ShipperNumber value
     * @param string $shipperNumber
     * @return \Ups\upsshipStruct\UpsShipperType
     */
    public function setShipperNumber($shipperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperNumber) && !is_string($shipperNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperNumber, true), gettype($shipperNumber)), __LINE__);
        }
        $this->ShipperNumber = $shipperNumber;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Ups\upsshipStruct\UpsShipperType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \Ups\upsshipStruct\UpsShipperType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsShipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsShipAddressType $address
     * @return \Ups\upsshipStruct\UpsShipperType
     */
    public function setAddress(\Ups\upsshipStruct\UpsShipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
