<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipToAddressType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipToAddressType extends UpsShipAddressType
{
    /**
     * The ResidentialAddressIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResidentialAddressIndicator;
    /**
     * Constructor method for ShipToAddressType
     * @uses UpsShipToAddressType::setResidentialAddressIndicator()
     * @param string $residentialAddressIndicator
     */
    public function __construct($residentialAddressIndicator = null)
    {
        $this
            ->setResidentialAddressIndicator($residentialAddressIndicator);
    }
    /**
     * Get ResidentialAddressIndicator value
     * @return string|null
     */
    public function getResidentialAddressIndicator()
    {
        return $this->ResidentialAddressIndicator;
    }
    /**
     * Set ResidentialAddressIndicator value
     * @param string $residentialAddressIndicator
     * @return \Ups\upsshipStruct\UpsShipToAddressType
     */
    public function setResidentialAddressIndicator($residentialAddressIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($residentialAddressIndicator) && !is_string($residentialAddressIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialAddressIndicator, true), gettype($residentialAddressIndicator)), __LINE__);
        }
        $this->ResidentialAddressIndicator = $residentialAddressIndicator;
        return $this;
    }
}
