<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipConfirmRequest upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipConfirmRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups\upsshipStruct\UpsRequestType
     */
    public $Request;
    /**
     * The Shipment
     * @var \Ups\upsshipStruct\UpsShipmentType
     */
    public $Shipment;
    /**
     * The LabelSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsLabelSpecificationType
     */
    public $LabelSpecification;
    /**
     * The ReceiptSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsReceiptSpecificationType
     */
    public $ReceiptSpecification;
    /**
     * Constructor method for ShipConfirmRequest
     * @uses UpsShipConfirmRequest::setRequest()
     * @uses UpsShipConfirmRequest::setShipment()
     * @uses UpsShipConfirmRequest::setLabelSpecification()
     * @uses UpsShipConfirmRequest::setReceiptSpecification()
     * @param \Ups\upsshipStruct\UpsRequestType $request
     * @param \Ups\upsshipStruct\UpsShipmentType $shipment
     * @param \Ups\upsshipStruct\UpsLabelSpecificationType $labelSpecification
     * @param \Ups\upsshipStruct\UpsReceiptSpecificationType $receiptSpecification
     */
    public function __construct(\Ups\upsshipStruct\UpsRequestType $request = null, \Ups\upsshipStruct\UpsShipmentType $shipment = null, \Ups\upsshipStruct\UpsLabelSpecificationType $labelSpecification = null, \Ups\upsshipStruct\UpsReceiptSpecificationType $receiptSpecification = null)
    {
        $this
            ->setRequest($request)
            ->setShipment($shipment)
            ->setLabelSpecification($labelSpecification)
            ->setReceiptSpecification($receiptSpecification);
    }
    /**
     * Get Request value
     * @return \Ups\upsshipStruct\UpsRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups\upsshipStruct\UpsRequestType $request
     * @return \Ups\upsshipStruct\UpsShipConfirmRequest
     */
    public function setRequest(\Ups\upsshipStruct\UpsRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \Ups\upsshipStruct\UpsShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Ups\upsshipStruct\UpsShipmentType $shipment
     * @return \Ups\upsshipStruct\UpsShipConfirmRequest
     */
    public function setShipment(\Ups\upsshipStruct\UpsShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get LabelSpecification value
     * @return \Ups\upsshipStruct\UpsLabelSpecificationType|null
     */
    public function getLabelSpecification()
    {
        return $this->LabelSpecification;
    }
    /**
     * Set LabelSpecification value
     * @param \Ups\upsshipStruct\UpsLabelSpecificationType $labelSpecification
     * @return \Ups\upsshipStruct\UpsShipConfirmRequest
     */
    public function setLabelSpecification(\Ups\upsshipStruct\UpsLabelSpecificationType $labelSpecification = null)
    {
        $this->LabelSpecification = $labelSpecification;
        return $this;
    }
    /**
     * Get ReceiptSpecification value
     * @return \Ups\upsshipStruct\UpsReceiptSpecificationType|null
     */
    public function getReceiptSpecification()
    {
        return $this->ReceiptSpecification;
    }
    /**
     * Set ReceiptSpecification value
     * @param \Ups\upsshipStruct\UpsReceiptSpecificationType $receiptSpecification
     * @return \Ups\upsshipStruct\UpsShipConfirmRequest
     */
    public function setReceiptSpecification(\Ups\upsshipStruct\UpsReceiptSpecificationType $receiptSpecification = null)
    {
        $this->ReceiptSpecification = $receiptSpecification;
        return $this;
    }
}
