<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageServiceOptionsType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsPackageServiceOptionsType extends AbstractStructBase
{
    /**
     * The DeliveryConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsDeliveryConfirmationType
     */
    public $DeliveryConfirmation;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPackageDeclaredValueType
     */
    public $DeclaredValue;
    /**
     * The COD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPSOCODType
     */
    public $COD;
    /**
     * The AccessPointCOD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPackageServiceOptionsAccessPointCODType
     */
    public $AccessPointCOD;
    /**
     * The ShipperReleaseIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperReleaseIndicator;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPSONotificationType
     */
    public $Notification;
    /**
     * The HazMat
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsHazMatType[]
     */
    public $HazMat;
    /**
     * The DryIce
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsDryIceType
     */
    public $DryIce;
    /**
     * The UPSPremiumCareIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UPSPremiumCareIndicator;
    /**
     * The ProactiveIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProactiveIndicator;
    /**
     * The PackageIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageIdentifier;
    /**
     * The ClinicalTrialsID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClinicalTrialsID;
    /**
     * The RefrigerationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RefrigerationIndicator;
    /**
     * Constructor method for PackageServiceOptionsType
     * @uses UpsPackageServiceOptionsType::setDeliveryConfirmation()
     * @uses UpsPackageServiceOptionsType::setDeclaredValue()
     * @uses UpsPackageServiceOptionsType::setCOD()
     * @uses UpsPackageServiceOptionsType::setAccessPointCOD()
     * @uses UpsPackageServiceOptionsType::setShipperReleaseIndicator()
     * @uses UpsPackageServiceOptionsType::setNotification()
     * @uses UpsPackageServiceOptionsType::setHazMat()
     * @uses UpsPackageServiceOptionsType::setDryIce()
     * @uses UpsPackageServiceOptionsType::setUPSPremiumCareIndicator()
     * @uses UpsPackageServiceOptionsType::setProactiveIndicator()
     * @uses UpsPackageServiceOptionsType::setPackageIdentifier()
     * @uses UpsPackageServiceOptionsType::setClinicalTrialsID()
     * @uses UpsPackageServiceOptionsType::setRefrigerationIndicator()
     * @param \Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation
     * @param \Ups\upsshipStruct\UpsPackageDeclaredValueType $declaredValue
     * @param \Ups\upsshipStruct\UpsPSOCODType $cOD
     * @param \Ups\upsshipStruct\UpsPackageServiceOptionsAccessPointCODType $accessPointCOD
     * @param string $shipperReleaseIndicator
     * @param \Ups\upsshipStruct\UpsPSONotificationType $notification
     * @param \Ups\upsshipStruct\UpsHazMatType[] $hazMat
     * @param \Ups\upsshipStruct\UpsDryIceType $dryIce
     * @param string $uPSPremiumCareIndicator
     * @param string $proactiveIndicator
     * @param string $packageIdentifier
     * @param string $clinicalTrialsID
     * @param string $refrigerationIndicator
     */
    public function __construct(\Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation = null, \Ups\upsshipStruct\UpsPackageDeclaredValueType $declaredValue = null, \Ups\upsshipStruct\UpsPSOCODType $cOD = null, \Ups\upsshipStruct\UpsPackageServiceOptionsAccessPointCODType $accessPointCOD = null, $shipperReleaseIndicator = null, \Ups\upsshipStruct\UpsPSONotificationType $notification = null, array $hazMat = array(), \Ups\upsshipStruct\UpsDryIceType $dryIce = null, $uPSPremiumCareIndicator = null, $proactiveIndicator = null, $packageIdentifier = null, $clinicalTrialsID = null, $refrigerationIndicator = null)
    {
        $this
            ->setDeliveryConfirmation($deliveryConfirmation)
            ->setDeclaredValue($declaredValue)
            ->setCOD($cOD)
            ->setAccessPointCOD($accessPointCOD)
            ->setShipperReleaseIndicator($shipperReleaseIndicator)
            ->setNotification($notification)
            ->setHazMat($hazMat)
            ->setDryIce($dryIce)
            ->setUPSPremiumCareIndicator($uPSPremiumCareIndicator)
            ->setProactiveIndicator($proactiveIndicator)
            ->setPackageIdentifier($packageIdentifier)
            ->setClinicalTrialsID($clinicalTrialsID)
            ->setRefrigerationIndicator($refrigerationIndicator);
    }
    /**
     * Get DeliveryConfirmation value
     * @return \Ups\upsshipStruct\UpsDeliveryConfirmationType|null
     */
    public function getDeliveryConfirmation()
    {
        return $this->DeliveryConfirmation;
    }
    /**
     * Set DeliveryConfirmation value
     * @param \Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setDeliveryConfirmation(\Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation = null)
    {
        $this->DeliveryConfirmation = $deliveryConfirmation;
        return $this;
    }
    /**
     * Get DeclaredValue value
     * @return \Ups\upsshipStruct\UpsPackageDeclaredValueType|null
     */
    public function getDeclaredValue()
    {
        return $this->DeclaredValue;
    }
    /**
     * Set DeclaredValue value
     * @param \Ups\upsshipStruct\UpsPackageDeclaredValueType $declaredValue
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setDeclaredValue(\Ups\upsshipStruct\UpsPackageDeclaredValueType $declaredValue = null)
    {
        $this->DeclaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get COD value
     * @return \Ups\upsshipStruct\UpsPSOCODType|null
     */
    public function getCOD()
    {
        return $this->COD;
    }
    /**
     * Set COD value
     * @param \Ups\upsshipStruct\UpsPSOCODType $cOD
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setCOD(\Ups\upsshipStruct\UpsPSOCODType $cOD = null)
    {
        $this->COD = $cOD;
        return $this;
    }
    /**
     * Get AccessPointCOD value
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsAccessPointCODType|null
     */
    public function getAccessPointCOD()
    {
        return $this->AccessPointCOD;
    }
    /**
     * Set AccessPointCOD value
     * @param \Ups\upsshipStruct\UpsPackageServiceOptionsAccessPointCODType $accessPointCOD
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setAccessPointCOD(\Ups\upsshipStruct\UpsPackageServiceOptionsAccessPointCODType $accessPointCOD = null)
    {
        $this->AccessPointCOD = $accessPointCOD;
        return $this;
    }
    /**
     * Get ShipperReleaseIndicator value
     * @return string|null
     */
    public function getShipperReleaseIndicator()
    {
        return $this->ShipperReleaseIndicator;
    }
    /**
     * Set ShipperReleaseIndicator value
     * @param string $shipperReleaseIndicator
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setShipperReleaseIndicator($shipperReleaseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($shipperReleaseIndicator) && !is_string($shipperReleaseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperReleaseIndicator, true), gettype($shipperReleaseIndicator)), __LINE__);
        }
        $this->ShipperReleaseIndicator = $shipperReleaseIndicator;
        return $this;
    }
    /**
     * Get Notification value
     * @return \Ups\upsshipStruct\UpsPSONotificationType|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \Ups\upsshipStruct\UpsPSONotificationType $notification
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setNotification(\Ups\upsshipStruct\UpsPSONotificationType $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get HazMat value
     * @return \Ups\upsshipStruct\UpsHazMatType[]|null
     */
    public function getHazMat()
    {
        return $this->HazMat;
    }
    /**
     * This method is responsible for validating the values passed to the setHazMat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazMat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazMatForArrayConstraintsFromSetHazMat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageServiceOptionsTypeHazMatItem) {
            // validation for constraint: itemType
            if (!$packageServiceOptionsTypeHazMatItem instanceof \Ups\upsshipStruct\UpsHazMatType) {
                $invalidValues[] = is_object($packageServiceOptionsTypeHazMatItem) ? get_class($packageServiceOptionsTypeHazMatItem) : sprintf('%s(%s)', gettype($packageServiceOptionsTypeHazMatItem), var_export($packageServiceOptionsTypeHazMatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazMat property can only contain items of type \Ups\upsshipStruct\UpsHazMatType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HazMat value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsHazMatType[] $hazMat
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setHazMat(array $hazMat = array())
    {
        // validation for constraint: array
        if ('' !== ($hazMatArrayErrorMessage = self::validateHazMatForArrayConstraintsFromSetHazMat($hazMat))) {
            throw new \InvalidArgumentException($hazMatArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($hazMat) && count($hazMat) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($hazMat)), __LINE__);
        }
        $this->HazMat = $hazMat;
        return $this;
    }
    /**
     * Add item to HazMat value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsHazMatType $item
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function addToHazMat(\Ups\upsshipStruct\UpsHazMatType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsHazMatType) {
            throw new \InvalidArgumentException(sprintf('The HazMat property can only contain items of type \Ups\upsshipStruct\UpsHazMatType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->HazMat) && count($this->HazMat) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->HazMat)), __LINE__);
        }
        $this->HazMat[] = $item;
        return $this;
    }
    /**
     * Get DryIce value
     * @return \Ups\upsshipStruct\UpsDryIceType|null
     */
    public function getDryIce()
    {
        return $this->DryIce;
    }
    /**
     * Set DryIce value
     * @param \Ups\upsshipStruct\UpsDryIceType $dryIce
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setDryIce(\Ups\upsshipStruct\UpsDryIceType $dryIce = null)
    {
        $this->DryIce = $dryIce;
        return $this;
    }
    /**
     * Get UPSPremiumCareIndicator value
     * @return string|null
     */
    public function getUPSPremiumCareIndicator()
    {
        return $this->UPSPremiumCareIndicator;
    }
    /**
     * Set UPSPremiumCareIndicator value
     * @param string $uPSPremiumCareIndicator
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setUPSPremiumCareIndicator($uPSPremiumCareIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($uPSPremiumCareIndicator) && !is_string($uPSPremiumCareIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPSPremiumCareIndicator, true), gettype($uPSPremiumCareIndicator)), __LINE__);
        }
        $this->UPSPremiumCareIndicator = $uPSPremiumCareIndicator;
        return $this;
    }
    /**
     * Get ProactiveIndicator value
     * @return string|null
     */
    public function getProactiveIndicator()
    {
        return $this->ProactiveIndicator;
    }
    /**
     * Set ProactiveIndicator value
     * @param string $proactiveIndicator
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setProactiveIndicator($proactiveIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($proactiveIndicator) && !is_string($proactiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proactiveIndicator, true), gettype($proactiveIndicator)), __LINE__);
        }
        $this->ProactiveIndicator = $proactiveIndicator;
        return $this;
    }
    /**
     * Get PackageIdentifier value
     * @return string|null
     */
    public function getPackageIdentifier()
    {
        return $this->PackageIdentifier;
    }
    /**
     * Set PackageIdentifier value
     * @param string $packageIdentifier
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setPackageIdentifier($packageIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($packageIdentifier) && !is_string($packageIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageIdentifier, true), gettype($packageIdentifier)), __LINE__);
        }
        $this->PackageIdentifier = $packageIdentifier;
        return $this;
    }
    /**
     * Get ClinicalTrialsID value
     * @return string|null
     */
    public function getClinicalTrialsID()
    {
        return $this->ClinicalTrialsID;
    }
    /**
     * Set ClinicalTrialsID value
     * @param string $clinicalTrialsID
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setClinicalTrialsID($clinicalTrialsID = null)
    {
        // validation for constraint: string
        if (!is_null($clinicalTrialsID) && !is_string($clinicalTrialsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clinicalTrialsID, true), gettype($clinicalTrialsID)), __LINE__);
        }
        $this->ClinicalTrialsID = $clinicalTrialsID;
        return $this;
    }
    /**
     * Get RefrigerationIndicator value
     * @return string|null
     */
    public function getRefrigerationIndicator()
    {
        return $this->RefrigerationIndicator;
    }
    /**
     * Set RefrigerationIndicator value
     * @param string $refrigerationIndicator
     * @return \Ups\upsshipStruct\UpsPackageServiceOptionsType
     */
    public function setRefrigerationIndicator($refrigerationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($refrigerationIndicator) && !is_string($refrigerationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refrigerationIndicator, true), gettype($refrigerationIndicator)), __LINE__);
        }
        $this->RefrigerationIndicator = $refrigerationIndicator;
        return $this;
    }
}
