<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegotiatedRateChargesType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsNegotiatedRateChargesType extends AbstractStructBase
{
    /**
     * The ItemizedCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType[]
     */
    public $ItemizedCharges;
    /**
     * The TaxCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsTaxChargeType[]
     */
    public $TaxCharges;
    /**
     * The TotalCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $TotalCharge;
    /**
     * The TotalChargesWithTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipChargeType
     */
    public $TotalChargesWithTaxes;
    /**
     * Constructor method for NegotiatedRateChargesType
     * @uses UpsNegotiatedRateChargesType::setItemizedCharges()
     * @uses UpsNegotiatedRateChargesType::setTaxCharges()
     * @uses UpsNegotiatedRateChargesType::setTotalCharge()
     * @uses UpsNegotiatedRateChargesType::setTotalChargesWithTaxes()
     * @param \Ups\upsshipStruct\UpsShipChargeType[] $itemizedCharges
     * @param \Ups\upsshipStruct\UpsTaxChargeType[] $taxCharges
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalCharge
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes
     */
    public function __construct(array $itemizedCharges = array(), array $taxCharges = array(), \Ups\upsshipStruct\UpsShipChargeType $totalCharge = null, \Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes = null)
    {
        $this
            ->setItemizedCharges($itemizedCharges)
            ->setTaxCharges($taxCharges)
            ->setTotalCharge($totalCharge)
            ->setTotalChargesWithTaxes($totalChargesWithTaxes);
    }
    /**
     * Get ItemizedCharges value
     * @return \Ups\upsshipStruct\UpsShipChargeType[]|null
     */
    public function getItemizedCharges()
    {
        return $this->ItemizedCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setItemizedCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemizedCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemizedChargesForArrayConstraintsFromSetItemizedCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negotiatedRateChargesTypeItemizedChargesItem) {
            // validation for constraint: itemType
            if (!$negotiatedRateChargesTypeItemizedChargesItem instanceof \Ups\upsshipStruct\UpsShipChargeType) {
                $invalidValues[] = is_object($negotiatedRateChargesTypeItemizedChargesItem) ? get_class($negotiatedRateChargesTypeItemizedChargesItem) : sprintf('%s(%s)', gettype($negotiatedRateChargesTypeItemizedChargesItem), var_export($negotiatedRateChargesTypeItemizedChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemizedCharges property can only contain items of type \Ups\upsshipStruct\UpsShipChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsShipChargeType[] $itemizedCharges
     * @return \Ups\upsshipStruct\UpsNegotiatedRateChargesType
     */
    public function setItemizedCharges(array $itemizedCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($itemizedChargesArrayErrorMessage = self::validateItemizedChargesForArrayConstraintsFromSetItemizedCharges($itemizedCharges))) {
            throw new \InvalidArgumentException($itemizedChargesArrayErrorMessage, __LINE__);
        }
        $this->ItemizedCharges = $itemizedCharges;
        return $this;
    }
    /**
     * Add item to ItemizedCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsShipChargeType $item
     * @return \Ups\upsshipStruct\UpsNegotiatedRateChargesType
     */
    public function addToItemizedCharges(\Ups\upsshipStruct\UpsShipChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsShipChargeType) {
            throw new \InvalidArgumentException(sprintf('The ItemizedCharges property can only contain items of type \Ups\upsshipStruct\UpsShipChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemizedCharges[] = $item;
        return $this;
    }
    /**
     * Get TaxCharges value
     * @return \Ups\upsshipStruct\UpsTaxChargeType[]|null
     */
    public function getTaxCharges()
    {
        return $this->TaxCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxChargesForArrayConstraintsFromSetTaxCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $negotiatedRateChargesTypeTaxChargesItem) {
            // validation for constraint: itemType
            if (!$negotiatedRateChargesTypeTaxChargesItem instanceof \Ups\upsshipStruct\UpsTaxChargeType) {
                $invalidValues[] = is_object($negotiatedRateChargesTypeTaxChargesItem) ? get_class($negotiatedRateChargesTypeTaxChargesItem) : sprintf('%s(%s)', gettype($negotiatedRateChargesTypeTaxChargesItem), var_export($negotiatedRateChargesTypeTaxChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxCharges property can only contain items of type \Ups\upsshipStruct\UpsTaxChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsTaxChargeType[] $taxCharges
     * @return \Ups\upsshipStruct\UpsNegotiatedRateChargesType
     */
    public function setTaxCharges(array $taxCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($taxChargesArrayErrorMessage = self::validateTaxChargesForArrayConstraintsFromSetTaxCharges($taxCharges))) {
            throw new \InvalidArgumentException($taxChargesArrayErrorMessage, __LINE__);
        }
        $this->TaxCharges = $taxCharges;
        return $this;
    }
    /**
     * Add item to TaxCharges value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsTaxChargeType $item
     * @return \Ups\upsshipStruct\UpsNegotiatedRateChargesType
     */
    public function addToTaxCharges(\Ups\upsshipStruct\UpsTaxChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsTaxChargeType) {
            throw new \InvalidArgumentException(sprintf('The TaxCharges property can only contain items of type \Ups\upsshipStruct\UpsTaxChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxCharges[] = $item;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalCharge
     * @return \Ups\upsshipStruct\UpsNegotiatedRateChargesType
     */
    public function setTotalCharge(\Ups\upsshipStruct\UpsShipChargeType $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get TotalChargesWithTaxes value
     * @return \Ups\upsshipStruct\UpsShipChargeType|null
     */
    public function getTotalChargesWithTaxes()
    {
        return $this->TotalChargesWithTaxes;
    }
    /**
     * Set TotalChargesWithTaxes value
     * @param \Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes
     * @return \Ups\upsshipStruct\UpsNegotiatedRateChargesType
     */
    public function setTotalChargesWithTaxes(\Ups\upsshipStruct\UpsShipChargeType $totalChargesWithTaxes = null)
    {
        $this->TotalChargesWithTaxes = $totalChargesWithTaxes;
        return $this;
    }
}
