<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntermediateConsigneeType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsIntermediateConsigneeType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsAddressType
     */
    public $Address;
    /**
     * Constructor method for IntermediateConsigneeType
     * @uses UpsIntermediateConsigneeType::setCompanyName()
     * @uses UpsIntermediateConsigneeType::setAddress()
     * @param string $companyName
     * @param \Ups\upsshipStruct\UpsAddressType $address
     */
    public function __construct($companyName = null, \Ups\upsshipStruct\UpsAddressType $address = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \Ups\upsshipStruct\UpsIntermediateConsigneeType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsAddressType $address
     * @return \Ups\upsshipStruct\UpsIntermediateConsigneeType
     */
    public function setAddress(\Ups\upsshipStruct\UpsAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
