<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightShipmentInformationType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsFreightShipmentInformationType extends AbstractStructBase
{
    /**
     * The FreightDensityInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsFreightDensityInfoType
     */
    public $FreightDensityInfo;
    /**
     * The DensityEligibleIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DensityEligibleIndicator;
    /**
     * Constructor method for FreightShipmentInformationType
     * @uses UpsFreightShipmentInformationType::setFreightDensityInfo()
     * @uses UpsFreightShipmentInformationType::setDensityEligibleIndicator()
     * @param \Ups\upsshipStruct\UpsFreightDensityInfoType $freightDensityInfo
     * @param string $densityEligibleIndicator
     */
    public function __construct(\Ups\upsshipStruct\UpsFreightDensityInfoType $freightDensityInfo = null, $densityEligibleIndicator = null)
    {
        $this
            ->setFreightDensityInfo($freightDensityInfo)
            ->setDensityEligibleIndicator($densityEligibleIndicator);
    }
    /**
     * Get FreightDensityInfo value
     * @return \Ups\upsshipStruct\UpsFreightDensityInfoType|null
     */
    public function getFreightDensityInfo()
    {
        return $this->FreightDensityInfo;
    }
    /**
     * Set FreightDensityInfo value
     * @param \Ups\upsshipStruct\UpsFreightDensityInfoType $freightDensityInfo
     * @return \Ups\upsshipStruct\UpsFreightShipmentInformationType
     */
    public function setFreightDensityInfo(\Ups\upsshipStruct\UpsFreightDensityInfoType $freightDensityInfo = null)
    {
        $this->FreightDensityInfo = $freightDensityInfo;
        return $this;
    }
    /**
     * Get DensityEligibleIndicator value
     * @return string|null
     */
    public function getDensityEligibleIndicator()
    {
        return $this->DensityEligibleIndicator;
    }
    /**
     * Set DensityEligibleIndicator value
     * @param string $densityEligibleIndicator
     * @return \Ups\upsshipStruct\UpsFreightShipmentInformationType
     */
    public function setDensityEligibleIndicator($densityEligibleIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($densityEligibleIndicator) && !is_string($densityEligibleIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($densityEligibleIndicator, true), gettype($densityEligibleIndicator)), __LINE__);
        }
        $this->DensityEligibleIndicator = $densityEligibleIndicator;
        return $this;
    }
}
