<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsFormType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsFormImageType
     */
    public $Image;
    /**
     * The FormGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormGroupId;
    /**
     * The FormGroupIdName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormGroupIdName;
    /**
     * Constructor method for FormType
     * @uses UpsFormType::setCode()
     * @uses UpsFormType::setDescription()
     * @uses UpsFormType::setImage()
     * @uses UpsFormType::setFormGroupId()
     * @uses UpsFormType::setFormGroupIdName()
     * @param string $code
     * @param string $description
     * @param \Ups\upsshipStruct\UpsFormImageType $image
     * @param string $formGroupId
     * @param string $formGroupIdName
     */
    public function __construct($code = null, $description = null, \Ups\upsshipStruct\UpsFormImageType $image = null, $formGroupId = null, $formGroupIdName = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setImage($image)
            ->setFormGroupId($formGroupId)
            ->setFormGroupIdName($formGroupIdName);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Ups\upsshipStruct\UpsFormType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ups\upsshipStruct\UpsFormType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Image value
     * @return \Ups\upsshipStruct\UpsFormImageType|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \Ups\upsshipStruct\UpsFormImageType $image
     * @return \Ups\upsshipStruct\UpsFormType
     */
    public function setImage(\Ups\upsshipStruct\UpsFormImageType $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get FormGroupId value
     * @return string|null
     */
    public function getFormGroupId()
    {
        return $this->FormGroupId;
    }
    /**
     * Set FormGroupId value
     * @param string $formGroupId
     * @return \Ups\upsshipStruct\UpsFormType
     */
    public function setFormGroupId($formGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($formGroupId) && !is_string($formGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formGroupId, true), gettype($formGroupId)), __LINE__);
        }
        $this->FormGroupId = $formGroupId;
        return $this;
    }
    /**
     * Get FormGroupIdName value
     * @return string|null
     */
    public function getFormGroupIdName()
    {
        return $this->FormGroupIdName;
    }
    /**
     * Set FormGroupIdName value
     * @param string $formGroupIdName
     * @return \Ups\upsshipStruct\UpsFormType
     */
    public function setFormGroupIdName($formGroupIdName = null)
    {
        // validation for constraint: string
        if (!is_null($formGroupIdName) && !is_string($formGroupIdName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formGroupIdName, true), gettype($formGroupIdName)), __LINE__);
        }
        $this->FormGroupIdName = $formGroupIdName;
        return $this;
    }
}
