<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillThirdPartyChargeType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsBillThirdPartyChargeType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * @var \Ups\upsshipStruct\UpsAccountAddressType
     */
    public $Address;
    /**
     * Constructor method for BillThirdPartyChargeType
     * @uses UpsBillThirdPartyChargeType::setAccountNumber()
     * @uses UpsBillThirdPartyChargeType::setAddress()
     * @param string $accountNumber
     * @param \Ups\upsshipStruct\UpsAccountAddressType $address
     */
    public function __construct($accountNumber = null, \Ups\upsshipStruct\UpsAccountAddressType $address = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Ups\upsshipStruct\UpsBillThirdPartyChargeType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \Ups\upsshipStruct\UpsAccountAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Ups\upsshipStruct\UpsAccountAddressType $address
     * @return \Ups\upsshipStruct\UpsBillThirdPartyChargeType
     */
    public function setAddress(\Ups\upsshipStruct\UpsAccountAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
