<?php

namespace Ups;

/**
 * Class which returns the class map definition
 * @package Ups
 */
class UpsClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'UPSSecurity' => '\\Ups\\upsshipStruct\\UpsUPSSecurity',
            'UsernameToken' => '\\Ups\\upsshipStruct\\UpsUsernameToken',
            'ServiceAccessToken' => '\\Ups\\upsshipStruct\\UpsServiceAccessToken',
            'Errors' => '\\Ups\\upsshipStruct\\UpsErrors',
            'ErrorDetailType' => '\\Ups\\upsshipStruct\\UpsErrorDetailType',
            'ElementLevelInformationType' => '\\Ups\\upsshipStruct\\UpsElementLevelInformationType',
            'ElementIdentifierType' => '\\Ups\\upsshipStruct\\UpsElementIdentifierType',
            'CodeType' => '\\Ups\\upsshipStruct\\UpsCodeType',
            'AdditionalInfoType' => '\\Ups\\upsshipStruct\\UpsAdditionalInfoType',
            'AdditionalCodeDescType' => '\\Ups\\upsshipStruct\\UpsAdditionalCodeDescType',
            'LocationType' => '\\Ups\\upsshipStruct\\UpsLocationType',
            'ClientInformationType' => '\\Ups\\upsshipStruct\\UpsClientInformationType',
            'Property' => '\\Ups\\upsshipStruct\\UpsProperty',
            'RequestType' => '\\Ups\\upsshipStruct\\UpsRequestType',
            'TransactionReferenceType' => '\\Ups\\upsshipStruct\\UpsTransactionReferenceType',
            'ResponseType' => '\\Ups\\upsshipStruct\\UpsResponseType',
            'CodeDescriptionType' => '\\Ups\\upsshipStruct\\UpsCodeDescriptionType',
            'DetailType' => '\\Ups\\upsshipStruct\\UpsDetailType',
            'InternationalFormType' => '\\Ups\\upsshipStruct\\UpsInternationalFormType',
            'UPSPremiumCareFormType' => '\\Ups\\upsshipStruct\\UpsUPSPremiumCareFormType',
            'LanguageForUPSPremiumCareType' => '\\Ups\\upsshipStruct\\UpsLanguageForUPSPremiumCareType',
            'UserCreatedFormType' => '\\Ups\\upsshipStruct\\UpsUserCreatedFormType',
            'CN22FormType' => '\\Ups\\upsshipStruct\\UpsCN22FormType',
            'CN22ContentType' => '\\Ups\\upsshipStruct\\UpsCN22ContentType',
            'ContactType' => '\\Ups\\upsshipStruct\\UpsContactType',
            'ForwardAgentType' => '\\Ups\\upsshipStruct\\UpsForwardAgentType',
            'AddressType' => '\\Ups\\upsshipStruct\\UpsAddressType',
            'UltimateConsigneeType' => '\\Ups\\upsshipStruct\\UpsUltimateConsigneeType',
            'IntermediateConsigneeType' => '\\Ups\\upsshipStruct\\UpsIntermediateConsigneeType',
            'ProducerType' => '\\Ups\\upsshipStruct\\UpsProducerType',
            'ProductType' => '\\Ups\\upsshipStruct\\UpsProductType',
            'ExcludeFromFormType' => '\\Ups\\upsshipStruct\\UpsExcludeFromFormType',
            'UnitType' => '\\Ups\\upsshipStruct\\UpsUnitType',
            'PackingListInfoType' => '\\Ups\\upsshipStruct\\UpsPackingListInfoType',
            'PackageAssociatedType' => '\\Ups\\upsshipStruct\\UpsPackageAssociatedType',
            'UnitOfMeasurementType' => '\\Ups\\upsshipStruct\\UpsUnitOfMeasurementType',
            'NetCostDateType' => '\\Ups\\upsshipStruct\\UpsNetCostDateType',
            'ProductWeightType' => '\\Ups\\upsshipStruct\\UpsProductWeightType',
            'ScheduleBType' => '\\Ups\\upsshipStruct\\UpsScheduleBType',
            'IFChargesType' => '\\Ups\\upsshipStruct\\UpsIFChargesType',
            'OtherChargesType' => '\\Ups\\upsshipStruct\\UpsOtherChargesType',
            'BlanketPeriodType' => '\\Ups\\upsshipStruct\\UpsBlanketPeriodType',
            'LicenseType' => '\\Ups\\upsshipStruct\\UpsLicenseType',
            'SoldToType' => '\\Ups\\upsshipStruct\\UpsSoldToType',
            'PhoneType' => '\\Ups\\upsshipStruct\\UpsPhoneType',
            'DDTCInformationType' => '\\Ups\\upsshipStruct\\UpsDDTCInformationType',
            'EEILicenseType' => '\\Ups\\upsshipStruct\\UpsEEILicenseType',
            'EEIFilingOptionType' => '\\Ups\\upsshipStruct\\UpsEEIFilingOptionType',
            'UPSFiledType' => '\\Ups\\upsshipStruct\\UpsUPSFiledType',
            'ShipperFiledType' => '\\Ups\\upsshipStruct\\UpsShipperFiledType',
            'EEIInformationType' => '\\Ups\\upsshipStruct\\UpsEEIInformationType',
            'POAType' => '\\Ups\\upsshipStruct\\UpsPOAType',
            'UltimateConsigneeTypeType' => '\\Ups\\upsshipStruct\\UpsUltimateConsigneeTypeType',
            'ShipmentRequest' => '\\Ups\\upsshipStruct\\UpsShipmentRequest',
            'ShipConfirmRequest' => '\\Ups\\upsshipStruct\\UpsShipConfirmRequest',
            'ShipAcceptRequest' => '\\Ups\\upsshipStruct\\UpsShipAcceptRequest',
            'ShipmentResponse' => '\\Ups\\upsshipStruct\\UpsShipmentResponse',
            'ShipConfirmResponse' => '\\Ups\\upsshipStruct\\UpsShipConfirmResponse',
            'ShipAcceptResponse' => '\\Ups\\upsshipStruct\\UpsShipAcceptResponse',
            'ShipmentType' => '\\Ups\\upsshipStruct\\UpsShipmentType',
            'ShipmentServiceOptions' => '\\Ups\\upsshipStruct\\UpsShipmentServiceOptions',
            'PromotionalDiscountInformationType' => '\\Ups\\upsshipStruct\\UpsPromotionalDiscountInformationType',
            'ReturnServiceType' => '\\Ups\\upsshipStruct\\UpsReturnServiceType',
            'ShipperType' => '\\Ups\\upsshipStruct\\UpsShipperType',
            'CompanyInfoType' => '\\Ups\\upsshipStruct\\UpsCompanyInfoType',
            'ShipPhoneType' => '\\Ups\\upsshipStruct\\UpsShipPhoneType',
            'ShipAddressType' => '\\Ups\\upsshipStruct\\UpsShipAddressType',
            'ShipToType' => '\\Ups\\upsshipStruct\\UpsShipToType',
            'ShipToAddressType' => '\\Ups\\upsshipStruct\\UpsShipToAddressType',
            'ShipFromType' => '\\Ups\\upsshipStruct\\UpsShipFromType',
            'PrepaidType' => '\\Ups\\upsshipStruct\\UpsPrepaidType',
            'BillShipperType' => '\\Ups\\upsshipStruct\\UpsBillShipperType',
            'CreditCardType' => '\\Ups\\upsshipStruct\\UpsCreditCardType',
            'CreditCardAddressType' => '\\Ups\\upsshipStruct\\UpsCreditCardAddressType',
            'BillThirdPartyChargeType' => '\\Ups\\upsshipStruct\\UpsBillThirdPartyChargeType',
            'AccountAddressType' => '\\Ups\\upsshipStruct\\UpsAccountAddressType',
            'FreightCollectType' => '\\Ups\\upsshipStruct\\UpsFreightCollectType',
            'BillReceiverType' => '\\Ups\\upsshipStruct\\UpsBillReceiverType',
            'BillReceiverAddressType' => '\\Ups\\upsshipStruct\\UpsBillReceiverAddressType',
            'PaymentInfoType' => '\\Ups\\upsshipStruct\\UpsPaymentInfoType',
            'ShipmentChargeType' => '\\Ups\\upsshipStruct\\UpsShipmentChargeType',
            'FRSPaymentInfoType' => '\\Ups\\upsshipStruct\\UpsFRSPaymentInfoType',
            'PaymentType' => '\\Ups\\upsshipStruct\\UpsPaymentType',
            'RateInfoType' => '\\Ups\\upsshipStruct\\UpsRateInfoType',
            'ReferenceNumberType' => '\\Ups\\upsshipStruct\\UpsReferenceNumberType',
            'ServiceType' => '\\Ups\\upsshipStruct\\UpsServiceType',
            'CurrencyMonetaryType' => '\\Ups\\upsshipStruct\\UpsCurrencyMonetaryType',
            'ShipmentServiceOptionsType' => '\\Ups\\upsshipStruct\\UpsShipmentServiceOptionsType',
            'RestrictedArticlesType' => '\\Ups\\upsshipStruct\\UpsRestrictedArticlesType',
            'PreAlertNotificationType' => '\\Ups\\upsshipStruct\\UpsPreAlertNotificationType',
            'PreAlertEMailMessageType' => '\\Ups\\upsshipStruct\\UpsPreAlertEMailMessageType',
            'LocaleType' => '\\Ups\\upsshipStruct\\UpsLocaleType',
            'PreAlertVoiceMessageType' => '\\Ups\\upsshipStruct\\UpsPreAlertVoiceMessageType',
            'PreAlertTextMessageType' => '\\Ups\\upsshipStruct\\UpsPreAlertTextMessageType',
            'ContactInfoType' => '\\Ups\\upsshipStruct\\UpsContactInfoType',
            'CODType' => '\\Ups\\upsshipStruct\\UpsCODType',
            'ShipmentServiceOptionsAccessPointCODType' => '\\Ups\\upsshipStruct\\UpsShipmentServiceOptionsAccessPointCODType',
            'NotificationType' => '\\Ups\\upsshipStruct\\UpsNotificationType',
            'LabelDeliveryType' => '\\Ups\\upsshipStruct\\UpsLabelDeliveryType',
            'EmailDetailsType' => '\\Ups\\upsshipStruct\\UpsEmailDetailsType',
            'PackageType' => '\\Ups\\upsshipStruct\\UpsPackageType',
            'PackagingType' => '\\Ups\\upsshipStruct\\UpsPackagingType',
            'DimensionsType' => '\\Ups\\upsshipStruct\\UpsDimensionsType',
            'ShipUnitOfMeasurementType' => '\\Ups\\upsshipStruct\\UpsShipUnitOfMeasurementType',
            'PackageWeightType' => '\\Ups\\upsshipStruct\\UpsPackageWeightType',
            'PackageServiceOptionsType' => '\\Ups\\upsshipStruct\\UpsPackageServiceOptionsType',
            'PackageDeclaredValueType' => '\\Ups\\upsshipStruct\\UpsPackageDeclaredValueType',
            'DeclaredValueType' => '\\Ups\\upsshipStruct\\UpsDeclaredValueType',
            'DeliveryConfirmationType' => '\\Ups\\upsshipStruct\\UpsDeliveryConfirmationType',
            'LabelMethodType' => '\\Ups\\upsshipStruct\\UpsLabelMethodType',
            'PSOCODType' => '\\Ups\\upsshipStruct\\UpsPSOCODType',
            'PackageServiceOptionsAccessPointCODType' => '\\Ups\\upsshipStruct\\UpsPackageServiceOptionsAccessPointCODType',
            'PSONotificationType' => '\\Ups\\upsshipStruct\\UpsPSONotificationType',
            'LabelSpecificationType' => '\\Ups\\upsshipStruct\\UpsLabelSpecificationType',
            'InstructionCodeDescriptionType' => '\\Ups\\upsshipStruct\\UpsInstructionCodeDescriptionType',
            'LabelImageFormatType' => '\\Ups\\upsshipStruct\\UpsLabelImageFormatType',
            'LabelStockSizeType' => '\\Ups\\upsshipStruct\\UpsLabelStockSizeType',
            'CommodityType' => '\\Ups\\upsshipStruct\\UpsCommodityType',
            'NMFCType' => '\\Ups\\upsshipStruct\\UpsNMFCType',
            'ShipmentResultsType' => '\\Ups\\upsshipStruct\\UpsShipmentResultsType',
            'DisclaimerType' => '\\Ups\\upsshipStruct\\UpsDisclaimerType',
            'ShipmentChargesType' => '\\Ups\\upsshipStruct\\UpsShipmentChargesType',
            'NegotiatedRateChargesType' => '\\Ups\\upsshipStruct\\UpsNegotiatedRateChargesType',
            'ShipChargeType' => '\\Ups\\upsshipStruct\\UpsShipChargeType',
            'TaxChargeType' => '\\Ups\\upsshipStruct\\UpsTaxChargeType',
            'FRSShipmentDataType' => '\\Ups\\upsshipStruct\\UpsFRSShipmentDataType',
            'TransportationChargeType' => '\\Ups\\upsshipStruct\\UpsTransportationChargeType',
            'BillingWeightType' => '\\Ups\\upsshipStruct\\UpsBillingWeightType',
            'BillingUnitOfMeasurementType' => '\\Ups\\upsshipStruct\\UpsBillingUnitOfMeasurementType',
            'PackageResultsType' => '\\Ups\\upsshipStruct\\UpsPackageResultsType',
            'AccessorialType' => '\\Ups\\upsshipStruct\\UpsAccessorialType',
            'LabelType' => '\\Ups\\upsshipStruct\\UpsLabelType',
            'ReceiptType' => '\\Ups\\upsshipStruct\\UpsReceiptType',
            'ImageType' => '\\Ups\\upsshipStruct\\UpsImageType',
            'FormType' => '\\Ups\\upsshipStruct\\UpsFormType',
            'FormImageType' => '\\Ups\\upsshipStruct\\UpsFormImageType',
            'ImageFormatType' => '\\Ups\\upsshipStruct\\UpsImageFormatType',
            'SCReportType' => '\\Ups\\upsshipStruct\\UpsSCReportType',
            'HighValueReportType' => '\\Ups\\upsshipStruct\\UpsHighValueReportType',
            'HazMatPackageInformationType' => '\\Ups\\upsshipStruct\\UpsHazMatPackageInformationType',
            'HazMatType' => '\\Ups\\upsshipStruct\\UpsHazMatType',
            'DryIceType' => '\\Ups\\upsshipStruct\\UpsDryIceType',
            'DryIceWeightType' => '\\Ups\\upsshipStruct\\UpsDryIceWeightType',
            'ReceiptSpecificationType' => '\\Ups\\upsshipStruct\\UpsReceiptSpecificationType',
            'ReceiptImageFormatType' => '\\Ups\\upsshipStruct\\UpsReceiptImageFormatType',
            'TaxIDCodeDescType' => '\\Ups\\upsshipStruct\\UpsTaxIDCodeDescType',
            'IndicationType' => '\\Ups\\upsshipStruct\\UpsIndicationType',
            'AlternateDeliveryAddressType' => '\\Ups\\upsshipStruct\\UpsAlternateDeliveryAddressType',
            'ShipmentServiceOptionsNotificationVoiceMessageType' => '\\Ups\\upsshipStruct\\UpsShipmentServiceOptionsNotificationVoiceMessageType',
            'ShipmentServiceOptionsNotificationTextMessageType' => '\\Ups\\upsshipStruct\\UpsShipmentServiceOptionsNotificationTextMessageType',
            'ADLAddressType' => '\\Ups\\upsshipStruct\\UpsADLAddressType',
            'FreightShipmentInformationType' => '\\Ups\\upsshipStruct\\UpsFreightShipmentInformationType',
            'HandlingUnitsType' => '\\Ups\\upsshipStruct\\UpsHandlingUnitsType',
            'HandlingUnitsResponseType' => '\\Ups\\upsshipStruct\\UpsHandlingUnitsResponseType',
            'HandlingUnitsDimensionsType' => '\\Ups\\upsshipStruct\\UpsHandlingUnitsDimensionsType',
            'FreightDensityRateType' => '\\Ups\\upsshipStruct\\UpsFreightDensityRateType',
            'FreightDensityInfoType' => '\\Ups\\upsshipStruct\\UpsFreightDensityInfoType',
            'AdjustedHeightType' => '\\Ups\\upsshipStruct\\UpsAdjustedHeightType',
            'NegotiatedChargesType' => '\\Ups\\upsshipStruct\\UpsNegotiatedChargesType',
            'DGSignatoryInfoType' => '\\Ups\\upsshipStruct\\UpsDGSignatoryInfoType',
            'UPSPremierType' => '\\Ups\\upsshipStruct\\UpsUPSPremierType',
            'HandlingInstructionsType' => '\\Ups\\upsshipStruct\\UpsHandlingInstructionsType',
            'SimpleRateType' => '\\Ups\\upsshipStruct\\UpsSimpleRateType',
            'VendorInfoType' => '\\Ups\\upsshipStruct\\UpsVendorInfoType',
        );
    }
}
