<?php

namespace Ups\upsshipStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentServiceOptionsType upsshipStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsShipmentServiceOptionsType extends AbstractStructBase
{
    /**
     * The SaturdayDeliveryIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SaturdayDeliveryIndicator;
    /**
     * The SaturdayPickupIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SaturdayPickupIndicator;
    /**
     * The COD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsCODType
     */
    public $COD;
    /**
     * The AccessPointCOD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsShipmentServiceOptionsAccessPointCODType
     */
    public $AccessPointCOD;
    /**
     * The DeliverToAddresseeOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliverToAddresseeOnlyIndicator;
    /**
     * The DirectDeliveryOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DirectDeliveryOnlyIndicator;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsNotificationType[]
     */
    public $Notification;
    /**
     * The LabelDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsLabelDeliveryType
     */
    public $LabelDelivery;
    /**
     * The InternationalForms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsInternationalFormType
     */
    public $InternationalForms;
    /**
     * The DeliveryConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsDeliveryConfirmationType
     */
    public $DeliveryConfirmation;
    /**
     * The ReturnOfDocumentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnOfDocumentIndicator;
    /**
     * The ImportControlIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImportControlIndicator;
    /**
     * The LabelMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsLabelMethodType
     */
    public $LabelMethod;
    /**
     * The CommercialInvoiceRemovalIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommercialInvoiceRemovalIndicator;
    /**
     * The UPScarbonneutralIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UPScarbonneutralIndicator;
    /**
     * The PreAlertNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsPreAlertNotificationType[]
     */
    public $PreAlertNotification;
    /**
     * The ExchangeForwardIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeForwardIndicator;
    /**
     * The HoldForPickupIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HoldForPickupIndicator;
    /**
     * The DropoffAtUPSFacilityIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DropoffAtUPSFacilityIndicator;
    /**
     * The LiftGateForPickUpIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LiftGateForPickUpIndicator;
    /**
     * The LiftGateForDeliveryIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LiftGateForDeliveryIndicator;
    /**
     * The SDLShipmentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SDLShipmentIndicator;
    /**
     * The EPRAReleaseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EPRAReleaseCode;
    /**
     * The RestrictedArticles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upsshipStruct\UpsRestrictedArticlesType
     */
    public $RestrictedArticles;
    /**
     * The InsideDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsideDelivery;
    /**
     * The ItemDisposal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemDisposal;
    /**
     * Constructor method for ShipmentServiceOptionsType
     * @uses UpsShipmentServiceOptionsType::setSaturdayDeliveryIndicator()
     * @uses UpsShipmentServiceOptionsType::setSaturdayPickupIndicator()
     * @uses UpsShipmentServiceOptionsType::setCOD()
     * @uses UpsShipmentServiceOptionsType::setAccessPointCOD()
     * @uses UpsShipmentServiceOptionsType::setDeliverToAddresseeOnlyIndicator()
     * @uses UpsShipmentServiceOptionsType::setDirectDeliveryOnlyIndicator()
     * @uses UpsShipmentServiceOptionsType::setNotification()
     * @uses UpsShipmentServiceOptionsType::setLabelDelivery()
     * @uses UpsShipmentServiceOptionsType::setInternationalForms()
     * @uses UpsShipmentServiceOptionsType::setDeliveryConfirmation()
     * @uses UpsShipmentServiceOptionsType::setReturnOfDocumentIndicator()
     * @uses UpsShipmentServiceOptionsType::setImportControlIndicator()
     * @uses UpsShipmentServiceOptionsType::setLabelMethod()
     * @uses UpsShipmentServiceOptionsType::setCommercialInvoiceRemovalIndicator()
     * @uses UpsShipmentServiceOptionsType::setUPScarbonneutralIndicator()
     * @uses UpsShipmentServiceOptionsType::setPreAlertNotification()
     * @uses UpsShipmentServiceOptionsType::setExchangeForwardIndicator()
     * @uses UpsShipmentServiceOptionsType::setHoldForPickupIndicator()
     * @uses UpsShipmentServiceOptionsType::setDropoffAtUPSFacilityIndicator()
     * @uses UpsShipmentServiceOptionsType::setLiftGateForPickUpIndicator()
     * @uses UpsShipmentServiceOptionsType::setLiftGateForDeliveryIndicator()
     * @uses UpsShipmentServiceOptionsType::setSDLShipmentIndicator()
     * @uses UpsShipmentServiceOptionsType::setEPRAReleaseCode()
     * @uses UpsShipmentServiceOptionsType::setRestrictedArticles()
     * @uses UpsShipmentServiceOptionsType::setInsideDelivery()
     * @uses UpsShipmentServiceOptionsType::setItemDisposal()
     * @param string $saturdayDeliveryIndicator
     * @param string $saturdayPickupIndicator
     * @param \Ups\upsshipStruct\UpsCODType $cOD
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptionsAccessPointCODType $accessPointCOD
     * @param string $deliverToAddresseeOnlyIndicator
     * @param string $directDeliveryOnlyIndicator
     * @param \Ups\upsshipStruct\UpsNotificationType[] $notification
     * @param \Ups\upsshipStruct\UpsLabelDeliveryType $labelDelivery
     * @param \Ups\upsshipStruct\UpsInternationalFormType $internationalForms
     * @param \Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation
     * @param string $returnOfDocumentIndicator
     * @param string $importControlIndicator
     * @param \Ups\upsshipStruct\UpsLabelMethodType $labelMethod
     * @param string $commercialInvoiceRemovalIndicator
     * @param string $uPScarbonneutralIndicator
     * @param \Ups\upsshipStruct\UpsPreAlertNotificationType[] $preAlertNotification
     * @param string $exchangeForwardIndicator
     * @param string $holdForPickupIndicator
     * @param string $dropoffAtUPSFacilityIndicator
     * @param string $liftGateForPickUpIndicator
     * @param string $liftGateForDeliveryIndicator
     * @param string $sDLShipmentIndicator
     * @param string $ePRAReleaseCode
     * @param \Ups\upsshipStruct\UpsRestrictedArticlesType $restrictedArticles
     * @param string $insideDelivery
     * @param string $itemDisposal
     */
    public function __construct($saturdayDeliveryIndicator = null, $saturdayPickupIndicator = null, \Ups\upsshipStruct\UpsCODType $cOD = null, \Ups\upsshipStruct\UpsShipmentServiceOptionsAccessPointCODType $accessPointCOD = null, $deliverToAddresseeOnlyIndicator = null, $directDeliveryOnlyIndicator = null, array $notification = array(), \Ups\upsshipStruct\UpsLabelDeliveryType $labelDelivery = null, \Ups\upsshipStruct\UpsInternationalFormType $internationalForms = null, \Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation = null, $returnOfDocumentIndicator = null, $importControlIndicator = null, \Ups\upsshipStruct\UpsLabelMethodType $labelMethod = null, $commercialInvoiceRemovalIndicator = null, $uPScarbonneutralIndicator = null, array $preAlertNotification = array(), $exchangeForwardIndicator = null, $holdForPickupIndicator = null, $dropoffAtUPSFacilityIndicator = null, $liftGateForPickUpIndicator = null, $liftGateForDeliveryIndicator = null, $sDLShipmentIndicator = null, $ePRAReleaseCode = null, \Ups\upsshipStruct\UpsRestrictedArticlesType $restrictedArticles = null, $insideDelivery = null, $itemDisposal = null)
    {
        $this
            ->setSaturdayDeliveryIndicator($saturdayDeliveryIndicator)
            ->setSaturdayPickupIndicator($saturdayPickupIndicator)
            ->setCOD($cOD)
            ->setAccessPointCOD($accessPointCOD)
            ->setDeliverToAddresseeOnlyIndicator($deliverToAddresseeOnlyIndicator)
            ->setDirectDeliveryOnlyIndicator($directDeliveryOnlyIndicator)
            ->setNotification($notification)
            ->setLabelDelivery($labelDelivery)
            ->setInternationalForms($internationalForms)
            ->setDeliveryConfirmation($deliveryConfirmation)
            ->setReturnOfDocumentIndicator($returnOfDocumentIndicator)
            ->setImportControlIndicator($importControlIndicator)
            ->setLabelMethod($labelMethod)
            ->setCommercialInvoiceRemovalIndicator($commercialInvoiceRemovalIndicator)
            ->setUPScarbonneutralIndicator($uPScarbonneutralIndicator)
            ->setPreAlertNotification($preAlertNotification)
            ->setExchangeForwardIndicator($exchangeForwardIndicator)
            ->setHoldForPickupIndicator($holdForPickupIndicator)
            ->setDropoffAtUPSFacilityIndicator($dropoffAtUPSFacilityIndicator)
            ->setLiftGateForPickUpIndicator($liftGateForPickUpIndicator)
            ->setLiftGateForDeliveryIndicator($liftGateForDeliveryIndicator)
            ->setSDLShipmentIndicator($sDLShipmentIndicator)
            ->setEPRAReleaseCode($ePRAReleaseCode)
            ->setRestrictedArticles($restrictedArticles)
            ->setInsideDelivery($insideDelivery)
            ->setItemDisposal($itemDisposal);
    }
    /**
     * Get SaturdayDeliveryIndicator value
     * @return string|null
     */
    public function getSaturdayDeliveryIndicator()
    {
        return $this->SaturdayDeliveryIndicator;
    }
    /**
     * Set SaturdayDeliveryIndicator value
     * @param string $saturdayDeliveryIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setSaturdayDeliveryIndicator($saturdayDeliveryIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($saturdayDeliveryIndicator) && !is_string($saturdayDeliveryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saturdayDeliveryIndicator, true), gettype($saturdayDeliveryIndicator)), __LINE__);
        }
        $this->SaturdayDeliveryIndicator = $saturdayDeliveryIndicator;
        return $this;
    }
    /**
     * Get SaturdayPickupIndicator value
     * @return string|null
     */
    public function getSaturdayPickupIndicator()
    {
        return $this->SaturdayPickupIndicator;
    }
    /**
     * Set SaturdayPickupIndicator value
     * @param string $saturdayPickupIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setSaturdayPickupIndicator($saturdayPickupIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($saturdayPickupIndicator) && !is_string($saturdayPickupIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saturdayPickupIndicator, true), gettype($saturdayPickupIndicator)), __LINE__);
        }
        $this->SaturdayPickupIndicator = $saturdayPickupIndicator;
        return $this;
    }
    /**
     * Get COD value
     * @return \Ups\upsshipStruct\UpsCODType|null
     */
    public function getCOD()
    {
        return $this->COD;
    }
    /**
     * Set COD value
     * @param \Ups\upsshipStruct\UpsCODType $cOD
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setCOD(\Ups\upsshipStruct\UpsCODType $cOD = null)
    {
        $this->COD = $cOD;
        return $this;
    }
    /**
     * Get AccessPointCOD value
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsAccessPointCODType|null
     */
    public function getAccessPointCOD()
    {
        return $this->AccessPointCOD;
    }
    /**
     * Set AccessPointCOD value
     * @param \Ups\upsshipStruct\UpsShipmentServiceOptionsAccessPointCODType $accessPointCOD
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setAccessPointCOD(\Ups\upsshipStruct\UpsShipmentServiceOptionsAccessPointCODType $accessPointCOD = null)
    {
        $this->AccessPointCOD = $accessPointCOD;
        return $this;
    }
    /**
     * Get DeliverToAddresseeOnlyIndicator value
     * @return string|null
     */
    public function getDeliverToAddresseeOnlyIndicator()
    {
        return $this->DeliverToAddresseeOnlyIndicator;
    }
    /**
     * Set DeliverToAddresseeOnlyIndicator value
     * @param string $deliverToAddresseeOnlyIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setDeliverToAddresseeOnlyIndicator($deliverToAddresseeOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($deliverToAddresseeOnlyIndicator) && !is_string($deliverToAddresseeOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverToAddresseeOnlyIndicator, true), gettype($deliverToAddresseeOnlyIndicator)), __LINE__);
        }
        $this->DeliverToAddresseeOnlyIndicator = $deliverToAddresseeOnlyIndicator;
        return $this;
    }
    /**
     * Get DirectDeliveryOnlyIndicator value
     * @return string|null
     */
    public function getDirectDeliveryOnlyIndicator()
    {
        return $this->DirectDeliveryOnlyIndicator;
    }
    /**
     * Set DirectDeliveryOnlyIndicator value
     * @param string $directDeliveryOnlyIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setDirectDeliveryOnlyIndicator($directDeliveryOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($directDeliveryOnlyIndicator) && !is_string($directDeliveryOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDeliveryOnlyIndicator, true), gettype($directDeliveryOnlyIndicator)), __LINE__);
        }
        $this->DirectDeliveryOnlyIndicator = $directDeliveryOnlyIndicator;
        return $this;
    }
    /**
     * Get Notification value
     * @return \Ups\upsshipStruct\UpsNotificationType[]|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * This method is responsible for validating the values passed to the setNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationForArrayConstraintsFromSetNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentServiceOptionsTypeNotificationItem) {
            // validation for constraint: itemType
            if (!$shipmentServiceOptionsTypeNotificationItem instanceof \Ups\upsshipStruct\UpsNotificationType) {
                $invalidValues[] = is_object($shipmentServiceOptionsTypeNotificationItem) ? get_class($shipmentServiceOptionsTypeNotificationItem) : sprintf('%s(%s)', gettype($shipmentServiceOptionsTypeNotificationItem), var_export($shipmentServiceOptionsTypeNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notification property can only contain items of type \Ups\upsshipStruct\UpsNotificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notification value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsNotificationType[] $notification
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setNotification(array $notification = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationArrayErrorMessage = self::validateNotificationForArrayConstraintsFromSetNotification($notification))) {
            throw new \InvalidArgumentException($notificationArrayErrorMessage, __LINE__);
        }
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Add item to Notification value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsNotificationType $item
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function addToNotification(\Ups\upsshipStruct\UpsNotificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsNotificationType) {
            throw new \InvalidArgumentException(sprintf('The Notification property can only contain items of type \Ups\upsshipStruct\UpsNotificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notification[] = $item;
        return $this;
    }
    /**
     * Get LabelDelivery value
     * @return \Ups\upsshipStruct\UpsLabelDeliveryType|null
     */
    public function getLabelDelivery()
    {
        return $this->LabelDelivery;
    }
    /**
     * Set LabelDelivery value
     * @param \Ups\upsshipStruct\UpsLabelDeliveryType $labelDelivery
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setLabelDelivery(\Ups\upsshipStruct\UpsLabelDeliveryType $labelDelivery = null)
    {
        $this->LabelDelivery = $labelDelivery;
        return $this;
    }
    /**
     * Get InternationalForms value
     * @return \Ups\upsshipStruct\UpsInternationalFormType|null
     */
    public function getInternationalForms()
    {
        return $this->InternationalForms;
    }
    /**
     * Set InternationalForms value
     * @param \Ups\upsshipStruct\UpsInternationalFormType $internationalForms
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setInternationalForms(\Ups\upsshipStruct\UpsInternationalFormType $internationalForms = null)
    {
        $this->InternationalForms = $internationalForms;
        return $this;
    }
    /**
     * Get DeliveryConfirmation value
     * @return \Ups\upsshipStruct\UpsDeliveryConfirmationType|null
     */
    public function getDeliveryConfirmation()
    {
        return $this->DeliveryConfirmation;
    }
    /**
     * Set DeliveryConfirmation value
     * @param \Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setDeliveryConfirmation(\Ups\upsshipStruct\UpsDeliveryConfirmationType $deliveryConfirmation = null)
    {
        $this->DeliveryConfirmation = $deliveryConfirmation;
        return $this;
    }
    /**
     * Get ReturnOfDocumentIndicator value
     * @return string|null
     */
    public function getReturnOfDocumentIndicator()
    {
        return $this->ReturnOfDocumentIndicator;
    }
    /**
     * Set ReturnOfDocumentIndicator value
     * @param string $returnOfDocumentIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setReturnOfDocumentIndicator($returnOfDocumentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($returnOfDocumentIndicator) && !is_string($returnOfDocumentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnOfDocumentIndicator, true), gettype($returnOfDocumentIndicator)), __LINE__);
        }
        $this->ReturnOfDocumentIndicator = $returnOfDocumentIndicator;
        return $this;
    }
    /**
     * Get ImportControlIndicator value
     * @return string|null
     */
    public function getImportControlIndicator()
    {
        return $this->ImportControlIndicator;
    }
    /**
     * Set ImportControlIndicator value
     * @param string $importControlIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setImportControlIndicator($importControlIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($importControlIndicator) && !is_string($importControlIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importControlIndicator, true), gettype($importControlIndicator)), __LINE__);
        }
        $this->ImportControlIndicator = $importControlIndicator;
        return $this;
    }
    /**
     * Get LabelMethod value
     * @return \Ups\upsshipStruct\UpsLabelMethodType|null
     */
    public function getLabelMethod()
    {
        return $this->LabelMethod;
    }
    /**
     * Set LabelMethod value
     * @param \Ups\upsshipStruct\UpsLabelMethodType $labelMethod
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setLabelMethod(\Ups\upsshipStruct\UpsLabelMethodType $labelMethod = null)
    {
        $this->LabelMethod = $labelMethod;
        return $this;
    }
    /**
     * Get CommercialInvoiceRemovalIndicator value
     * @return string|null
     */
    public function getCommercialInvoiceRemovalIndicator()
    {
        return $this->CommercialInvoiceRemovalIndicator;
    }
    /**
     * Set CommercialInvoiceRemovalIndicator value
     * @param string $commercialInvoiceRemovalIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setCommercialInvoiceRemovalIndicator($commercialInvoiceRemovalIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($commercialInvoiceRemovalIndicator) && !is_string($commercialInvoiceRemovalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commercialInvoiceRemovalIndicator, true), gettype($commercialInvoiceRemovalIndicator)), __LINE__);
        }
        $this->CommercialInvoiceRemovalIndicator = $commercialInvoiceRemovalIndicator;
        return $this;
    }
    /**
     * Get UPScarbonneutralIndicator value
     * @return string|null
     */
    public function getUPScarbonneutralIndicator()
    {
        return $this->UPScarbonneutralIndicator;
    }
    /**
     * Set UPScarbonneutralIndicator value
     * @param string $uPScarbonneutralIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setUPScarbonneutralIndicator($uPScarbonneutralIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($uPScarbonneutralIndicator) && !is_string($uPScarbonneutralIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPScarbonneutralIndicator, true), gettype($uPScarbonneutralIndicator)), __LINE__);
        }
        $this->UPScarbonneutralIndicator = $uPScarbonneutralIndicator;
        return $this;
    }
    /**
     * Get PreAlertNotification value
     * @return \Ups\upsshipStruct\UpsPreAlertNotificationType[]|null
     */
    public function getPreAlertNotification()
    {
        return $this->PreAlertNotification;
    }
    /**
     * This method is responsible for validating the values passed to the setPreAlertNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreAlertNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreAlertNotificationForArrayConstraintsFromSetPreAlertNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentServiceOptionsTypePreAlertNotificationItem) {
            // validation for constraint: itemType
            if (!$shipmentServiceOptionsTypePreAlertNotificationItem instanceof \Ups\upsshipStruct\UpsPreAlertNotificationType) {
                $invalidValues[] = is_object($shipmentServiceOptionsTypePreAlertNotificationItem) ? get_class($shipmentServiceOptionsTypePreAlertNotificationItem) : sprintf('%s(%s)', gettype($shipmentServiceOptionsTypePreAlertNotificationItem), var_export($shipmentServiceOptionsTypePreAlertNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PreAlertNotification property can only contain items of type \Ups\upsshipStruct\UpsPreAlertNotificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PreAlertNotification value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsPreAlertNotificationType[] $preAlertNotification
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setPreAlertNotification(array $preAlertNotification = array())
    {
        // validation for constraint: array
        if ('' !== ($preAlertNotificationArrayErrorMessage = self::validatePreAlertNotificationForArrayConstraintsFromSetPreAlertNotification($preAlertNotification))) {
            throw new \InvalidArgumentException($preAlertNotificationArrayErrorMessage, __LINE__);
        }
        $this->PreAlertNotification = $preAlertNotification;
        return $this;
    }
    /**
     * Add item to PreAlertNotification value
     * @throws \InvalidArgumentException
     * @param \Ups\upsshipStruct\UpsPreAlertNotificationType $item
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function addToPreAlertNotification(\Ups\upsshipStruct\UpsPreAlertNotificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upsshipStruct\UpsPreAlertNotificationType) {
            throw new \InvalidArgumentException(sprintf('The PreAlertNotification property can only contain items of type \Ups\upsshipStruct\UpsPreAlertNotificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PreAlertNotification[] = $item;
        return $this;
    }
    /**
     * Get ExchangeForwardIndicator value
     * @return string|null
     */
    public function getExchangeForwardIndicator()
    {
        return $this->ExchangeForwardIndicator;
    }
    /**
     * Set ExchangeForwardIndicator value
     * @param string $exchangeForwardIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setExchangeForwardIndicator($exchangeForwardIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeForwardIndicator) && !is_string($exchangeForwardIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeForwardIndicator, true), gettype($exchangeForwardIndicator)), __LINE__);
        }
        $this->ExchangeForwardIndicator = $exchangeForwardIndicator;
        return $this;
    }
    /**
     * Get HoldForPickupIndicator value
     * @return string|null
     */
    public function getHoldForPickupIndicator()
    {
        return $this->HoldForPickupIndicator;
    }
    /**
     * Set HoldForPickupIndicator value
     * @param string $holdForPickupIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setHoldForPickupIndicator($holdForPickupIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($holdForPickupIndicator) && !is_string($holdForPickupIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdForPickupIndicator, true), gettype($holdForPickupIndicator)), __LINE__);
        }
        $this->HoldForPickupIndicator = $holdForPickupIndicator;
        return $this;
    }
    /**
     * Get DropoffAtUPSFacilityIndicator value
     * @return string|null
     */
    public function getDropoffAtUPSFacilityIndicator()
    {
        return $this->DropoffAtUPSFacilityIndicator;
    }
    /**
     * Set DropoffAtUPSFacilityIndicator value
     * @param string $dropoffAtUPSFacilityIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setDropoffAtUPSFacilityIndicator($dropoffAtUPSFacilityIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($dropoffAtUPSFacilityIndicator) && !is_string($dropoffAtUPSFacilityIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropoffAtUPSFacilityIndicator, true), gettype($dropoffAtUPSFacilityIndicator)), __LINE__);
        }
        $this->DropoffAtUPSFacilityIndicator = $dropoffAtUPSFacilityIndicator;
        return $this;
    }
    /**
     * Get LiftGateForPickUpIndicator value
     * @return string|null
     */
    public function getLiftGateForPickUpIndicator()
    {
        return $this->LiftGateForPickUpIndicator;
    }
    /**
     * Set LiftGateForPickUpIndicator value
     * @param string $liftGateForPickUpIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setLiftGateForPickUpIndicator($liftGateForPickUpIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($liftGateForPickUpIndicator) && !is_string($liftGateForPickUpIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liftGateForPickUpIndicator, true), gettype($liftGateForPickUpIndicator)), __LINE__);
        }
        $this->LiftGateForPickUpIndicator = $liftGateForPickUpIndicator;
        return $this;
    }
    /**
     * Get LiftGateForDeliveryIndicator value
     * @return string|null
     */
    public function getLiftGateForDeliveryIndicator()
    {
        return $this->LiftGateForDeliveryIndicator;
    }
    /**
     * Set LiftGateForDeliveryIndicator value
     * @param string $liftGateForDeliveryIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setLiftGateForDeliveryIndicator($liftGateForDeliveryIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($liftGateForDeliveryIndicator) && !is_string($liftGateForDeliveryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liftGateForDeliveryIndicator, true), gettype($liftGateForDeliveryIndicator)), __LINE__);
        }
        $this->LiftGateForDeliveryIndicator = $liftGateForDeliveryIndicator;
        return $this;
    }
    /**
     * Get SDLShipmentIndicator value
     * @return string|null
     */
    public function getSDLShipmentIndicator()
    {
        return $this->SDLShipmentIndicator;
    }
    /**
     * Set SDLShipmentIndicator value
     * @param string $sDLShipmentIndicator
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setSDLShipmentIndicator($sDLShipmentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($sDLShipmentIndicator) && !is_string($sDLShipmentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDLShipmentIndicator, true), gettype($sDLShipmentIndicator)), __LINE__);
        }
        $this->SDLShipmentIndicator = $sDLShipmentIndicator;
        return $this;
    }
    /**
     * Get EPRAReleaseCode value
     * @return string|null
     */
    public function getEPRAReleaseCode()
    {
        return $this->EPRAReleaseCode;
    }
    /**
     * Set EPRAReleaseCode value
     * @param string $ePRAReleaseCode
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setEPRAReleaseCode($ePRAReleaseCode = null)
    {
        // validation for constraint: string
        if (!is_null($ePRAReleaseCode) && !is_string($ePRAReleaseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ePRAReleaseCode, true), gettype($ePRAReleaseCode)), __LINE__);
        }
        $this->EPRAReleaseCode = $ePRAReleaseCode;
        return $this;
    }
    /**
     * Get RestrictedArticles value
     * @return \Ups\upsshipStruct\UpsRestrictedArticlesType|null
     */
    public function getRestrictedArticles()
    {
        return $this->RestrictedArticles;
    }
    /**
     * Set RestrictedArticles value
     * @param \Ups\upsshipStruct\UpsRestrictedArticlesType $restrictedArticles
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setRestrictedArticles(\Ups\upsshipStruct\UpsRestrictedArticlesType $restrictedArticles = null)
    {
        $this->RestrictedArticles = $restrictedArticles;
        return $this;
    }
    /**
     * Get InsideDelivery value
     * @return string|null
     */
    public function getInsideDelivery()
    {
        return $this->InsideDelivery;
    }
    /**
     * Set InsideDelivery value
     * @param string $insideDelivery
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setInsideDelivery($insideDelivery = null)
    {
        // validation for constraint: string
        if (!is_null($insideDelivery) && !is_string($insideDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insideDelivery, true), gettype($insideDelivery)), __LINE__);
        }
        $this->InsideDelivery = $insideDelivery;
        return $this;
    }
    /**
     * Get ItemDisposal value
     * @return string|null
     */
    public function getItemDisposal()
    {
        return $this->ItemDisposal;
    }
    /**
     * Set ItemDisposal value
     * @param string $itemDisposal
     * @return \Ups\upsshipStruct\UpsShipmentServiceOptionsType
     */
    public function setItemDisposal($itemDisposal = null)
    {
        // validation for constraint: string
        if (!is_null($itemDisposal) && !is_string($itemDisposal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDisposal, true), gettype($itemDisposal)), __LINE__);
        }
        $this->ItemDisposal = $itemDisposal;
        return $this;
    }
}
